$(document).ready(inicio);
		function inicio(){
			$('.color').click(clicColor);
			$('#txtValorResistencia').click(borrarContenido);
			calcularValorResistencia();
		}

		function borrarContenido(){
			$(this).val('');
		}

		function clicColor(){
			var listaColor=$(this).attr('data-color');
			if(listaColor==1){
				contenidoHTML="<div data-color='"+listaColor+"' class='lista-color' id='lista-color"+listaColor+"'><div class='negro' data-valor='0'>Negro</div><div class='marron' data-valor='1'>Marrón</div><div class='rojo' data-valor='2'>Rojo</div><div class='naranja' data-valor='3'>Naranja</div><div class='amarillo' data-valor='4'>Amarillo</div><div class='verde' data-valor='5'>Verde</div><div class='azul' data-valor='6'>Azul</div><div class='violeta' data-valor='7'>Violeta</div><div class='gris' data-valor='8'>Gris</div><div class='blanco' data-valor='9'>Blanco</div></div>"; 
			}
			if(listaColor==2){
				contenidoHTML="<div data-color='"+listaColor+"' class='lista-color' id='lista-color"+listaColor+"'><div class='negro' data-valor='0'>Negro</div><div class='marron' data-valor='1'>Marrón</div><div class='rojo' data-valor='2'>Rojo</div><div class='naranja' data-valor='3'>Naranja</div><div class='amarillo' data-valor='4'>Amarillo</div><div class='verde' data-valor='5'>Verde</div><div class='azul' data-valor='6'>Azul</div><div class='violeta' data-valor='7'>Violeta</div><div class='gris' data-valor='8'>Gris</div><div class='blanco' data-valor='9'>Blanco</div></div>"; 
			}
			if(listaColor==3){
				contenidoHTML="<div data-color='"+listaColor+"' class='lista-color' id='lista-color"+listaColor+"'><div class='negro' data-valor='0'>Negro</div><div class='marron' data-valor='1'>Marrón</div><div class='rojo' data-valor='2'>Rojo</div><div class='naranja' data-valor='3'>Naranja</div><div class='amarillo' data-valor='4'>Amarillo</div><div class='verde' data-valor='5'>Verde</div><div class='azul' data-valor='6'>Azul</div><div class='violeta' data-valor='7'>Violeta</div><div class='gris' data-valor='8'>Gris</div><div class='blanco' data-valor='9'>Blanco</div><div class='dorado' data-valor='-1'>Dorado</div><div class='plateado' data-valor='-2'>Plateado</div></div>";
			}
			if(listaColor==4){
				contenidoHTML="<div data-color='"+listaColor+"' class='lista-color' id='lista-color"+listaColor+"'><div class='sincolor' data-valor='20'>Sin color</div><div class='marron' data-valor='1'>Marrón</div><div class='rojo' data-valor='2'>Rojo</div><div class='amarillo' data-valor='4'>Amarillo</div><div class='verde' data-valor='0.5'>Verde</div><div class='azul' data-valor='0.25'>Azul</div><div class='violeta' data-valor='0.10'>Violeta</div><div class='gris' data-valor='0.05'>Gris</div><div class='dorado' data-valor='5'>Dorado</div><div class='plateado' data-valor='10'>Plateado</div></div>";
			}
			$('#colores').html(contenidoHTML);
			$('#lista-color'+listaColor+' > div').attr('data-color',listaColor);
			$('.sincolor, .negro, .marron, .rojo, .naranja, .amarillo, .verde, .azul, .violeta, .gris, .blanco, .dorado, .plateado').click(clicDivColor);
		}

		function calcularValorResistencia(){
			var valor="";
			var valorMultiplicador=$('#color3').attr('data-valor');
			var multiplicador="";
			if(valorMultiplicador==0){
				multiplicador="";
				valor=$('#color1').attr('data-valor')+$('#color2').attr('data-valor')+multiplicador; //Obtiene el valor en Ohmios
				if(valor.charAt(0)=='0'){valor=valor.substring(1, valor.length);} //Elimina el primer cero si existe
				valor=valor+' Ω';
				valor=valor+' ± '+$('#color4').attr('data-valor')+'%'; //Asigna Tolerancia			
			}
			else if(valorMultiplicador>0){
				for(i=0; i<$('#color3').attr('data-valor'); i++){
					multiplicador=multiplicador+'0';
				}
				valor=$('#color1').attr('data-valor')+$('#color2').attr('data-valor')+multiplicador; //Obtiene el valor en Ohmios
				if(valor.charAt(0)=='0'){valor=valor.substring(1, valor.length);} //Elimina el primer cero si existe
				valor=generarValor(valor); //Si es posible pasa de Ω a kΩ o mΩ //Retorna el valor con unidad de medida
				valor=valor+' ± '+$('#color4').attr('data-valor')+'%'; //Asigna Tolerancia
			}
			else if(valorMultiplicador==-1){
				valor=$('#color1').attr('data-valor')+$('#color2').attr('data-valor');
				if(valor.charAt(0)=='0'){valor=valor.substring(1, valor.length);} //Elimina el primer cero
				valor=valor*Math.pow(10,-1);
				valor=Math.round(valor*100)/100;
				valor=valor+' Ω ± '+$('#color4').attr('data-valor')+'%';
			}
			else{ //valorMultiplicador=-2;
				valor=$('#color1').attr('data-valor')+$('#color2').attr('data-valor');
				if(valor.charAt(0)=='0'){valor=valor.substring(1, valor.length);} //Elimina el primer cero
				valor=valor*Math.pow(10,-2);
				valor=Math.round(valor*100)/100;
				valor=valor+' Ω ± '+$('#color4').attr('data-valor')+'%';
			}
				$('#valorResistencia').html(valor);
		}

		function clicDivColor(){
			$('#divResistenciasAlt').html('');
			var idDivColor="#color"+$(this).attr('data-color');
			var claseAAsignar=$(this).attr('class');
			var valor=$(this).attr('data-valor')
			$(idDivColor).removeClass().addClass('color').addClass(claseAAsignar).attr('data-valor',valor);
			calcularValorResistencia();
		}

		function generarValor(valor){ //Retorna el valor con unidad de medida
			if (valor.length<=3){valor=valor+" Ω"}
			else if(valor.length==4){valor=valor.charAt(0)+"."+valor.charAt(1)+' KΩ';}
			else if(valor.length==5){valor=valor.charAt(0)+valor.charAt(1)+' KΩ';}
			else if(valor.length==6){valor=valor.charAt(0)+valor.charAt(1)+'0 KΩ';}
			else if(valor.length==7){valor=valor.charAt(0)+"."+valor.charAt(1)+' MΩ';}
			else if(valor.length==8){valor=valor.charAt(0)+valor.charAt(1)+' MΩ';}
			else if(valor.length==9){valor=valor.charAt(0)+valor.charAt(1)+'0 MΩ';}
			else if(valor.length==10){valor=valor.charAt(0)+"."+valor.charAt(1)+' GΩ';}
			else if(valor.length==11){valor=valor.charAt(0)+valor.charAt(1)+' GΩ';}
			return valor;
		}

		function buscarResistencia(){
			$('#valorResistencia').html('');
			$('#colores').html('');
			$('#divResistenciasAlt').html('');
			if(!isNaN($('#txtValorResistencia').val())){//Si es número
				var color4=$('#selectTolerancia').val();
				var valor="";
				$('#color4').removeClass().addClass('color').addClass(color4).attr('data-valor',obtenerValorTolerancia(color4));
				if($('#selectUnidadMedida').val()=='Ω'){
					valor=$('#txtValorResistencia').val();
				}else if($('#selectUnidadMedida').val()=='KΩ'){
					valor=$('#txtValorResistencia').val()*Math.pow(10,3);
				}else if($('#selectUnidadMedida').val()=='MΩ'){
					valor=$('#txtValorResistencia').val()*Math.pow(10,6);
				}else if($('#selectUnidadMedida').val()=='GΩ'){
					valor=$('#txtValorResistencia').val()*Math.pow(10,9);
				}
				valor=Math.round(valor*100)/100; //Redonde el valor
				valor=valor.toString();
				/*Primero evaluamos si el tercer color es dorado o plateado, es decir si tenemos un valor decimal
				Probamos entonces lo siguiente: Que contenga un punto(.) dos digitos diferentes de cero(0).*/
				if(valor.indexOf('.')!=-1){//Si es diferente de -1 es por que si contiene puntos
					var numDifCeros=0;
					for(i=0; i<valor.length; i++){
						if(valor.charAt(i)!='0' && valor.charAt(i)!='.'){ //Si el caracter es un número diferente de cero y no es el punto.
							numDifCeros++; //Acomula cuantos número diferentes de cero hay
						}}
					if(numDifCeros>2){
						alert('Número inválido');
					}else{

						if(valor.charAt(0)!=0 && valor.charAt(2)!=0){ //Número de la siguiente manera: #1.#2
							color1=obtenerColor(valor.charAt(0));
							color2=obtenerColor(valor.charAt(2));
							$('#color1').removeClass().addClass('color').addClass(color1).attr('data-valor',valor.charAt(0));
							$('#color2').removeClass().addClass('color').addClass(color2).attr('data-valor',valor.charAt(2));
							$('#color3').removeClass().addClass('color').addClass('dorado').attr('data-valor',obtenerValorColor('dorado'));
						}

						if(valor.length>=4 && valor.charAt(0)=='0' && valor.charAt(3)!=0){ //Número de la siguiente manera: 0.#1#2
							color1=obtenerColor(valor.charAt(2));
							color2=obtenerColor(valor.charAt(3));
							$('#color1').removeClass().addClass('color').addClass(color1).attr('data-valor',valor.charAt(2));
							$('#color2').removeClass().addClass('color').addClass(color2).attr('data-valor',valor.charAt(3));
							$('#color3').removeClass().addClass('color').addClass('plateado').attr('data-valor',obtenerValorColor('plateado'));
						}

						if(valor.length==3 && valor.charAt(0)=='0' && valor.charAt(2)!=0){ //Número de la siguiente forma: 0.#
							color1=obtenerColor(valor.charAt(2));
							$('#color1').removeClass().addClass('color').addClass(color1).attr('data-valor',valor.charAt(2));
							$('#color2').removeClass().addClass('color').addClass('negro').attr('data-valor',obtenerValorColor('negro'));
							$('#color3').removeClass().addClass('color').addClass('plateado').attr('data-valor',obtenerValorColor('plateado'));
						}}
				}
				else if(valor.length==1){ //Si el valor solo es de un caracter **HAY DOS ALTERNATIVAS
					color1=obtenerColor(valor.charAt(0));
					$('#color1').removeClass().addClass('color').addClass(color1).attr('data-valor',valor.charAt(0));
					$('#color2').removeClass().addClass('color').addClass('negro').attr('data-valor',obtenerValorColor('negro'));
					$('#color3').removeClass().addClass('color').addClass('dorado').attr('data-valor',obtenerValorColor('dorado'));
					var contenidoHTML="";
					contenidoHTML='<a href="javascript:mostrarAlternativa(\''+color1+'\',\'negro\',\'dorado\')">Alternativa 1</a>';
					contenidoHTML=contenidoHTML+' | <a href="javascript:mostrarAlternativa(\'negro\',\''+color1+'\',\'negro\')">Alternativa 2</a>';
					$('#divResistenciasAlt').html(contenidoHTML);
				}
				else if(valor.length>=11){
					alert('No se puede hallar una resistencia con dicho valor.');
				}
				else{
					valor=valor.toString();
					valColor1=valor.charAt(0);
					color1=obtenerColor(valColor1);
					valColor2=valor.charAt(1);
					color2=obtenerColor(valColor2);
					valColor3=valor.length-2;
					color3=obtenerColor(valColor3);
					$('#color1').removeClass().addClass('color').addClass(color1).attr('data-valor',obtenerValorColor(color1));
					$('#color2').removeClass().addClass('color').addClass(color2).attr('data-valor',obtenerValorColor(color2));
					$('#color3').removeClass().addClass('color').addClass(color3).attr('data-valor',obtenerValorColor(color3));
					if(valor.length>=2 && valor.length<=10 && valor.charAt(1)==0){ //Si el número de de la forma: #00000000 tiene dos alternativas: negro=0 color y color(ceros) o color cero y color(ceros)
						var contenidoHTML="";
						contenidoHTML='<a href="javascript:mostrarAlternativa(\''+color1+'\',\''+color2+'\',\''+color3+'\')">Alternativa 1</a>';
						valColor3=valor.length-1; //El color tres cambia, poniendose un 0 mas en el valor tres.
						color3=obtenerColor(valColor3);
						contenidoHTML=contenidoHTML+' | <a href="javascript:mostrarAlternativa(\'negro\',\''+color1+'\',\''+color3+'\')">Alternativa 2</a>';
						$('#divResistenciasAlt').html(contenidoHTML);
					}
				}

			}else{
				alert("Ingrese un dato válido");	
			}
		}

		function obtenerColor(valor){//Mediante un valor se obtiene el color.
			var retorno="";
			if(valor==0){retorno='negro';}
			if(valor==1){retorno='marron';}
			if(valor==2){retorno='rojo';}
			if(valor==3){retorno='naranja';}
			if(valor==4){retorno='amarillo';}
			if(valor==5){retorno='verde';}
			if(valor==6){retorno='azul';}
			if(valor==7){retorno='violeta';}
			if(valor==8){retorno='gris';}
			if(valor==9){retorno='blanco';}
			return retorno;
		}

		function obtenerValorColor(color){//Mediante un color se obtiene el color de la banda de tolerancia
			var retorno=0;
			if(color=="negro"){retorno=0;}
			if(color=="marron"){retorno=1;}
			if(color=="rojo"){retorno=2;}
			if(color=="naranja"){retorno=3;}
			if(color=="amarillo"){retorno=4;}
			if(color=="verde"){retorno=5;}
			if(color=="azul"){retorno=6;}
			if(color=="violeta"){retorno=7;}
			if(color=="gris"){retorno=8;}
			if(color=="blanco"){retorno=9;}
			if(color=="dorado"){retorno=-1;}
			if(color=="plateado"){retorno=-2;}
			return retorno;
		}

		function obtenerValorTolerancia(color){//Mediante un color se obtiene el color de la banda de tolerancia
			var retorno=0;
			if(color=="marron"){retorno=1;}
			if(color=="rojo"){retorno=2;}
			if(color=="amarillo"){retorno=4;}
			if(color=="verde"){retorno=0.5;}
			if(color=="azul"){retorno=0.25;}
			if(color=="violeta"){retorno=0.1;}
			if(color=="gris"){retorno=0.05;}
			if(color=="dorado"){retorno=5;}
			if(color=="plateado"){retorno=10;}
			if(color=="sincolor"){retorno=20;}
			return retorno;
		}

		function mostrarAlternativa(color1, color2, color3){
			$('#color1').removeClass().addClass('color').addClass(color1).attr('data-valor',obtenerValorColor(color1));
			$('#color2').removeClass().addClass('color').addClass(color2).attr('data-valor',obtenerValorColor(color2));
			$('#color3').removeClass().addClass('color').addClass(color3).attr('data-valor',obtenerValorColor(color3));	
		}

