var db;
var dbCreated = window.localStorage.getItem("bancoOracoesCriado");
var eFavorito = false;

function carregarBanco() {
    db = window.openDatabase("Oracoes", "1.0", "Oracoes", 200000);
    if (dbCreated=="null")
        populateDB();    	//db.transaction(populateDB, transaction_error, populateDB_success);
}

function populateDB_success(){
    window.localStorage.setItem("bancoOracoesCriado", "1");
}

function transaction_error(tx, error) {
    alert("Erro ao criar o banco: " + error.message);
}

function exibirBotaoFavorito(favorito){

    if(favorito){
        $("#imgFavorito").html('<img src="img/estrela_on.png" class="favorito"/>');
    }
    else{
        $("#imgFavorito").html('<img src="img/estrela_off.png" class="favorito"/>');   
    }

    eFavorito = favorito;
}


function checarFavorito(item){

    db.transaction(function(tx) {
       tx.executeSql("SELECT COUNT(*) as total FROM oracoes WHERE id="+item, [],
          function(tx, result) {
             if(result.rows.item(0)["total"]>0){
                exibirBotaoFavorito(true);
             }
             else{
                exibirBotaoFavorito(false);
             }

          },
          function(tx, error){
             populateDB(); 
          }
       );
    });

}

function mudarFavorito(item){

    
    db.transaction(function(tx) {
    
       if(eFavorito){
         tx.executeSql("DELETE FROM oracoes WHERE id="+item,[],function(tx,error){},function(tx,error){alert(error.message)});
         exibirBotaoFavorito(false);
       }
       else{
         tx.executeSql("INSERT INTO oracoes (id,nome,texto) VALUES(?, ?, ?)",[item,tituloItem,textoItem],function(tx,error){},function(tx,error){alert(error.message)});
         exibirBotaoFavorito(true);
       }
        
    });
}

function carregarFavoritos(){
    db.transaction(function(tx) {
       tx.executeSql("SELECT * FROM oracoes ORDER BY nome", [],
          function(tx, result) {
          
            $('#lista li').remove();
            
            var total = result.rows.length;
            
            if(total==0){
                $("#semFavorito").show();
            }
            else{
                
                for (var i=0; i<total; i++) {
                
                    var oracao = result.rows.item(i);
                    
                    $('#lista').append('<li><a href="ver_item_favorito.html?id=' + oracao.id + '">' +
                    '<h4>' + oracao.nome + '</h4>' +
                    '</a></li>');
                }
            
            }
            
            $('#divCarregando').hide();
            $('#lista').listview('refresh');


          },
          function(tx, error){
             alert("Database Error favorites: " + error);
          }
       );
    });
}



function exibirItemFavorito(item){
    db.transaction(function(tx) {
       tx.executeSql("SELECT * FROM oracoes WHERE id="+item, [],
          function(tx, result) {
                   
            var total = result.rows.length;
            
            if(total==0){
                alert("Not found!");
            }
            else{
            
                //exibirBotaoFavorito(true);
            
                var oracao = result.rows.item(0);
                
                var html = "<h2>"+oracao.nome+"</h2>"+oracao.texto;
                
                $("#conteudo").html(html);
                
                
            }
            
            $('#divCarregando').hide();
     

          },
          function(tx, error){
             alert("Database Error favorites: " + error);
          }
       );
    });
}


function populateDB() {


    db.transaction(function(tx) {
    
    	var sql = 
		"CREATE TABLE IF NOT EXISTS oracoes ( "+
		"id INTEGER PRIMARY KEY, " +
		"nome VARCHAR(200), " +
		"texto TEXT)";
    
    
       tx.executeSql(sql, [],
          function(tx, result) {
                window.localStorage.setItem("bancoOracoesCriado", "1");
          },
          function(tx, error){
             alert("Erro criar banco!: " + error.message);
          }
       );
    });    


}
