var FormSamples = function () {
    

    return {
        //main function to initiate the module
        init: function () {

		$( ".just-number" ).keydown(function(event) {
			 // alert(event.keyCode);
			if ((event.keyCode < 45 || event.keyCode > 57)&& event.keyCode != 190 && event.keyCode != 8 && event.keyCode != 189)
			{
				return false;
			}
		});
		
		// Transmit Power
		var XmtPwrIn;
		var Pt_dBm;
		var Pt_mW;
		var Pt_W;
		// Signal Rates
		var Rb;
		var Rs;
		//Noise Temperature
		var NoiseTemp;
		var NF;
		var NF_dB;
		var No_dB;
        var Rs_kHz;
		var Pn;
		var Pn_dBm;
		var IR;
		var IR_dB;
		var Pi_abs;
		var Pi_dBm;
		var Pni;
		var Pni_dBm;
		//Sensitive
		var SensDat;
		var Sens_dBm;
		var Smin_dBm;
		var EbNoreq_dB;
		var SNRreq_dB;
		//Antenna
		var Gr_dBi;
		var Gt_dBi;
		var Other_dBi;
		var Gains;
		// Transmission Losses
		var Ltr_dB;
		// Parameters
		var freq_MHz;
		var TxAntHt;
		var RxAntHt;
		var HatCase;
		var HatAlp;
		var HatGam;
		var Dist;
		var intercep;
		var PropagationLoss;
		// Margin
		var sigL;
		var Rel;
		var Margin;
		var Mode;
		//Reception Losses
		var L1;
		var L2;
		var Losses;
		
		var Received_power;
		var Noise;
		var MedianSNR;
		var Processing;
		var MedianEbNo;
		var Required_EbNo;
		var Excess;
		var SURPLUS;
		var Desired_link_reliability;
		var Effective_link_reliability;
		var Distance_for_desired_reliability;
		
		function calculate(){
			transmit_power();
			rate_dialog();
			noise_dlg();
			send_dlg();
			ant_gain();
			transmission_loss();
			parameters();
			calc_margin();
			reception_losses();
		}
		
		function transmit_power(){
						
			if($("#Wselect").prop('checked')){				
			 var XmtPwrIn = parseFloat($('#XmtPwrIn').val());
					if ( XmtPwrIn <= 0){				
						 alert("Power must be greater than zero!");
					}
					else{				
						Pt_W = XmtPwrIn
						Pt_mW = Pt_W * 1000;
						Pt_dBm = (10 * (Math.log(Pt_mW)))/ Math.log(10);
					}
			}
			
			if($("#mWselect").prop('checked')){				
				XmtPwrIn = parseFloat($('#XmtPwrIn').val());
				if (XmtPwrIn <= 0){
					alert("Power must be greater than zero!");
	            }
				else{	
						Pt_mW = XmtPwrIn;
						Pt_W = Pt_mW / 1000;
						Pt_dBm = (10 * (Math.log(Pt_mW)))/ Math.log(10);
					}
			}
			
			if($("#dBmselect").prop('checked')){				
				XmtPwrIn = parseFloat($('#XmtPwrIn').val());				
				Pt_dBm = XmtPwrIn
				Pt_mW = Math.pow(10, (Pt_dBm / 10));
				Pt_W = Pt_mW / 1000;
			}
			
			$('#summ_transmit_power').html(Pt_dBm.toFixed(1) + ' dBm');
		}
		
		// Transmit Power
		$( "#transmit_power" ).click(function() {	
			calculate();
			alert("The result Transmit Power:\n " + Pt_W +" W\n" + Pt_mW +" mW\n" + Pt_dBm +" dBm");
		});
		
		function rate_dialog(){
			var BitRate = parseFloat($('#BitRate').val());
			var SymbolRate = parseFloat($('#SymbolRate').val());			
			if( BitRate <= 0 || SymbolRate <=0){	
				alert("Rates must be greater than zero!");
			}
			else{				
				Rb = BitRate;
				Rs = SymbolRate;
			}	
		}
		
		// Signal Rates
		$( "#RateDlg" ).click(function() {
			calculate();
			alert("The result is:\nRb(kHz):" + Rb +" Rb \nRs(kHz):" + Rs +" Rs   ");
		});
            
		function noise_dlg(){
			var NForTvalue = parseFloat($('#NForTvalue').val());
			
            if($('#SelTemp').prop('checked')){
                
                if(NForTvalue < 293){                    
                    alert("Temperature must be > 293 degrees Kelvin");
                    return;
                }
				NoiseTemp = NForTvalue;
				NF = NoiseTemp / 293;
				NF_dB = 10 * Math.log(NF) / Math.log(10);
			}
            
			if($('#SelNF').prop('checked')){
                
                if($('#absNFsel').prop('checked')){
                    
                    if(NForTvalue < 1){
                        alert("Noise factor must be >= 1");
                        return;
                    }
                    
                    NF = NForTvalue;
                    NF_dB = 10 * Math.log(NF) / Math.log(10);
                }
                
                if($('#dBNFSel').prop('checked')){
                    
                    if( NForTvalue < 0){
                        alert("Noise figure (dB) must be >= zero");
                        return;
                    }
                    
                    NF_dB = NForTvalue;
                    NF = Math.pow(10, NF_dB / 10);
                }
                
                NoiseTemp = NF * 293;
            }
            
            No_dB = -173.93 + NF_dB;
            Rs_kHz = Rs;
			Rb_kHz = Rb;
			Pn_dBm = No_dB + 30 + 10 * Math.log(Rs_kHz) / Math.log(10);
			Pn = Rs_kHz * 1000 * Math.pow(10, No_dB / 10);
			
			var InterfRatio = parseFloat($("#InterfRatio").val());
			if($('#absIRsel').prop('checked')){
				if (InterfRatio < 0) {
						alert("Interference factor must not be negative");
						return;
				}
				IR = InterfRatio;
				IR_dB = 10 * Math.log(IR) / Math.log(10);
			}
			if ($('#dBIRsel').prop('checked')){
				IR_dB = InterfRatio;
				IR = Math.pow(10, IR_dB / 10);
			}
			Pi_abs = IR * Pn;
			Pi_dBm = IR_dB + Pn_dBm;
			Pni = Pn + Pi_abs;
			Pni_dBm = 10 * Math.log(Pni) / Math.log(10);
		}
		
        // Noise Power
        $('#NoiseDlg').click(function(){
            calculate();
			alert("The result is:\nNoise temperature (°K):"+NoiseTemp+"\nNoise figure (dB):"+NF_dB+"\nNoise power (dBm):"+Pn_dBm+"\nInterference ratio (dB):"+IR+"\nIR_dB:"+IR_dB+"\nNo_dB:"+No_dB+"\nRs_kHz:"+Rs_kHz+"\nPn:"+Pn+"\nPi_abs:"+Pi_abs+"\nInterference power (dBm):"+Pi_dBm+"\nPni:"+Pni+"\nTotal noise power (dBm):"+Pni_dBm);
        });
         
		function send_dlg(){
			
			SensDat = parseFloat($('#SensDat').val());
			
			if($("#dBmSel").prop('checked')){
				Sens_dBm = SensDat;
				SNRreq_dB = Sens_dBm - Pn_dBm;
				EbNoreq_dB = SNRreq_dB + 10 * Math.log(Rs_kHz / Rb_kHz) / Math.log(10);
			}
			
			if($("#EbNoSel").prop('checked')){				
				EbNoreq_dB = SensDat;
				SNRreq_dB = EbNoreq_dB - 10 * Math.log(Rs_kHz / Rb_kHz) / Math.log(10);
				Sens_dBm = SNRreq_dB + Pn_dBm;			               
	        }	
			
			if($("#SNRsel").prop('checked')){				
				SNRreq_dB = SensDat;
				EbNoreq_dB = SNRreq_dB + 10 * Math.log(Rs_kHz / Rb_kHz) / Math.log(10);
				Sens_dBm = SNRreq_dB + Pn_dBm;
			}
			Smin_dBm = SNRreq_dB + Pni_dBm;
		}
		
		$( "#SensDlg" ).click(function() {
			calculate();
			alert("The result is\nRequired SNR (dB):" + SNRreq_dB +" dB \nRequired Eb/No (dB):" + EbNoreq_dB +" dB \nReceiver sensitivity (dBm):" + Sens_dBm +" dBm");
		});
		
		function ant_gain(){
			var GrValue = parseFloat($('#GrValue').val());
			var GtValue = parseFloat($('#GtValue').val());			
			Other_dBi = parseFloat($('#OtherValue').val());
			if($("#dBsel").prop('checked')){
				if($("#IsoSel").prop('checked') && GrValue.Value < 0 || $("#DipSel").prop('checked') && GrValue < -1.76){
					alert ("Receiver antenna gain must be at least 0.0 dBi (-1.76 dBd)");
					return;
				}
				if ($("#IsoSel").prop('checked') && GtValue.Value < 0 || $("#DipSel").prop('checked') && GtValue < -1.76){
					alert ("Transmitter antenna gain must be at least 0.0 dBi (-1.76 dBd)");
					return;
				}
				Gr_dBi = GrValue;
				Gt_dBi = GtValue;
				if ($("#DipSel").prop('checked')){
					Gr_dBi = Gr_dBi + 1.76;
					Gt_dBi = Gt_dBi + 1.76;
				}
			}
			if ($("#AbsSel").prop('checked')){
				if ($("#IsoSel").prop('checked') && GrValue < 1 || $("#DipSel").prop('checked') && GrValue < (2 / 3)){
					alert ("Receiver antenna gain must be at least 1.0 (2/3 relative to a dipole)");
					return;
				}
				if ($("#IsoSel").prop('checked') && GtValue < 1 || $("#DipSel").prop('checked') && GtValue < (2 / 3)){
					alert ("Transmitter antenna gain must be at least 1.0 (2/3 relative to a dipole)");
					return;
				}
				Gr_dBi = 10 * Math.log(GrValue) / Math.log(10);
				Gt_dBi = 10 * Math.log(GtValue) / Math.log(10);
				if ($("#DipSel").prop('checked')){
					Gr_dBi = Gr_dBi + 1.76;
					Gt_dBi = Gt_dBi + 1.76;
				}
			}
			
			Gains = Gr_dBi+Gt_dBi+Other_dBi;
			$('#Gains').html((Gains).toFixed(1) + ' dB');
		}
		
		// Antenna Gain
		$( "#AntGainOK" ).click(function() {
			calculate();
			alert("The result is\nGr (dBi):" + Gr_dBi +" \nGt (dBi):" + Gt_dBi +" \nOther:" + Other_dBi);
		});
		
		function transmission_loss(){
			Ltr_dB = parseFloat($('#XLossValue').val());
		}
		
		// Transmission Loss
		$( "#TransmissionLossOK" ).click(function() {
			calculate();
			alert("The result is\nTransmission Losses:" + Ltr_dB);
		});
		
		function parameters(){
			var Distkm = parseFloat($('#Distkm').val());
			var f_MHz = parseFloat($('#f_MHz').val());
			var XAntHt = parseFloat($('#XAntHt').val());
			var RAntHt = parseFloat($('#RAntHt').val());
			Dist = Distkm;
			freq_MHz = f_MHz;
			intercep = 32.45 + 20 * Math.log(freq_MHz) / Math.log(10);
			TxAntHt = XAntHt;
			HatAlp = 69.55 + 26.16 * Math.log(freq_MHz) / Math.log(10) - 13.82 * Math.log(TxAntHt) / Math.log(10);
			RxAntHt = RAntHt;
			HatGam = 4.49 - 0.655 * Math.log(TxAntHt) / Math.log(10);
			if ($("#LgCityOpt").prop('checked')){
				HatCase = "Large City";
				if (freq_MHz < 200){
					HatAlp = HatAlp - 8.29 * Math.pow(Math.log(1.54 * RxAntHt) / Math.log(10), 2) + 1.1;
				} else if (freq_MHz >= 400){
					HatAlp = HatAlp - 3.2 * Math.pow(Math.log(11.75 * RxAntHt) / Math.log(10), 2) + 4.97;
				}
			}
			if ($("#SmCityOpt").prop('checked')){
				HatCase = "Small City";
				HatAlp = HatAlp - (1.1 * Math.log(freq_MHz) / Math.log(10) - 0.7) * RxAntHt + (1.56 * Math.log(freq_MHz) / Math.log(10) - 0.8);
			}
			if ($("#SuburbOpt").prop('checked')){
				HatCase = "Suburban";
				HatAlp = HatAlp - 2 * Math.pow(Math.log(freq_MHz / 28) / Math.log(10), 2) - 5.4;
				HatAlp = HatAlp - (1.1 * Math.log(freq_MHz) / Math.log(10) - 0.7) * RxAntHt + (1.56 * Math.log(freq_MHz) / Math.log(10) - 0.8);
			}
			if ($("#OpenOpt").prop('checked')){
				HatCase = "Open";
				HatAlp = HatAlp - 4.78 * Math.pow(Math.log(freq_MHz) / Math.log(10), 2) + 18.33 * Math.log(freq_MHz) / Math.log(10) - 40.94;
				HatAlp = HatAlp - (1.1 * Math.log(freq_MHz) / Math.log(10) - 0.7) * RxAntHt + (1.56 * Math.log(freq_MHz) / Math.log(10) - 0.8);
			}
			
			PropagationLoss = HatAlp + 10 * HatGam * Math.log(Dist) / Math.log(10);
		}
		
		// Parameters
		$( "#ParametersOK" ).click(function() {
			calculate();
			alert("The result is\nEnvironment:"+HatCase+"\nIntercep:" + HatAlp +"\nPower law:"+HatGam+"\nPropagation Loss:"+PropagationLoss);
		});
		
		function calc_margin(){
			var temp;
			SigmaL = parseFloat($('#SigmaL').val());
			Percentage = parseFloat($('#Percentage').val());
			
			Mode = "shadowing only";
			sigL = SigmaL;
			if (sigL < 0){
				sigL = -sigL;
			}
			
			Rel = Percentage / 100;
			if (Rel > 0.5){
				temp = Math.sqrt(-2 * Math.log(1 - Rel));
			}
			if (Rel < 0.5){
				temp = Math.sqrt(-2 * Math.log(Rel));
			}
			var part1 = 2.515517 + 0.802853 * temp + 0.010328 * Math.pow(temp, 2);
			var part2 = 1 + 1.432788 * temp + 0.189269 * Math.pow(temp, 2) + 0.001308 * Math.pow(temp, 3);
			temp = temp - part1 / part2;
			if (Rel == 0.5) Margin = 0;
			if (Rel > 0.5) Margin = sigL * temp;
			if (Rel < 0.5) Margin = -sigL * temp;
			if ($("#Selfading").prop('checked')){
				Mode = "fading only";
				Margin = 10 * Math.log(-1 / Math.log(Rel)) / Math.log(10);
			}
			if ($("#Selcombined").prop('checked')){
				Mode = "shadowing and fading";
				Margin = Margin + sigL * (0.35 - 0.015 * sigL);
				Margin = Margin * Math.exp(Math.exp(-(sigL - 2) / 4));
			}
		}
		
		// Margins
		$( "#CalcMargButton" ).click(function() {
			calculate();
			alert("The result is\nFading mode:" + Mode + "\nStd. Deviation in dB, sL:"+sigL+"\nPercentage of time, X:"+Rel*100+"\nMargin in dB, M:"+Margin);
		});
		
		function reception_losses(){
			var Lrec = parseFloat($('#Lrec').val());
			var OtherLoss = parseFloat($('#OtherLoss').val());
			L1 = Lrec;
			L2 = OtherLoss;
			Losses = L1+L2+Ltr_dB+PropagationLoss;
			$('#Losses').html((Losses).toFixed(1) + ' dB');
			Received_power = Pt_dBm+Gains-Losses;
			
			$('#Received_power').html((Received_power).toFixed(1) + ' dBm');
			$('#Noise').html((Pni_dBm).toFixed(1) + ' dBm');
			MedianSNR = Pt_dBm+Gains-Losses-Pni_dBm;
			$('#Median_received_SNR').html((MedianSNR).toFixed(1) + ' dB');
			Processing_gain = 10*Math.log10(Rs_kHz/Rb_kHz);
			$('#Processing_gain').html((Processing_gain).toFixed(1) + ' dB');
			MedianEbNo = MedianSNR+Processing_gain;
			$('#Median_received_EbNo').html((MedianEbNo).toFixed(1) + ' dB');
			$('#Required_EbNo').html((EbNoreq_dB).toFixed(1) + ' dB');
			Excess = MedianEbNo-EbNoreq_dB;
			$('#Excess').html((Excess).toFixed(1) + ' dB');
			$('#Margin').html((Margin).toFixed(1) + ' dB');
			SURPLUS = Excess-Margin;
			$('#SURPLUS').html((SURPLUS).toFixed(1) + ' dB');
			Desired_link_reliability = Rel*100;
			$('#Desired').html((Desired_link_reliability).toFixed(1) + ' %');
			var C27 = Margin + SURPLUS;
			var C28 = C27 / sigL;
			var C29 = Math.abs(C28);
			var C30 = 1 / (1 + 0.33267 * C29);
			var C31 = 0.4361836 * C30 - 0.1201676 * Math.pow(C30, 2) + 0.937298 * Math.pow(C30, 3);
			var C32 = C31 * Math.exp(-0.5 * Math.pow(C29, 2))/ Math.sqrt(2 * Math.PI);
			var C33 = 0.5 + C28 * (1 - 2 * C32) / 2 / C29;
			var E27 = C27 * Math.exp(-3/sigL);
			var E28 = E27 / sigL;
			var E29 = Math.abs(E28);
			var E30 = 1 / (1 + 0.33267 * E29);
			var E31 = 0.4361836 * E30 - 0.1201676 * Math.pow(E30, 2) + 0.937298 * Math.pow(E30, 3);
			var E32 = E31 * Math.exp(-0.5 * Math.pow(E29, 2))/ Math.sqrt(2 * Math.PI);
			var E33 = (0.5 + E28 * (1 - 2 * E32) / 2 / E29) * Math.exp(-Math.exp(-Math.log(10) * (C27 + 6) / 10));
			var complement = 0;
			
			if (Mode == "shadowing only"){
				complement = C33;
			}
			else if (Mode == "fading only"){
				complement = Math.exp(-Math.exp(-Math.log(10) * C27 / 10));
			}
			else if (Mode == "shadowing and fading"){
				complement = E33;
			}
			
			Effective_link_reliability = 100 * complement;
			$('#Effective').html((Effective_link_reliability).toFixed(1) + ' %');
			
			$('#Specified').html(Dist.toFixed(3) + ' km');
			//alert(Dist);
			Distance_for_desired_reliability = Math.pow(10, (PropagationLoss + SURPLUS - HatAlp) / 10 / HatGam);
			$('#Distance').html((Distance_for_desired_reliability).toFixed(3) + ' km');
			
			$('#Mode').html(Mode);
			
			// $('#summary').click();
		}
		
		// Reception Losses
		$( "#ReceptionLossesOK" ).click(function() {
			calculate();
			alert("The result is\nImplementation losses in dB:" + L1+"\nScenario losses in dB:"+L2);
		});
		
        }

    };

}();