angular.module('rjr', ['ionic'])

.config(function($stateProvider, $urlRouterProvider, $compileProvider) {
  // Pour Firefox OS
  $compileProvider.aHrefSanitizationWhitelist(/^\s*(https?|ftp|mailto|app|tel|file):/);
  $compileProvider.imgSrcSanitizationWhitelist(/^\s*(https?|ftp|mailto|app|file):/);

  $urlRouterProvider.otherwise('/');

  $stateProvider.state('main', {
    url: '/',
    templateUrl: 'views/main.html'
  })
  .state('ctquoi', {
    url: '/ctquoi',
    templateUrl: 'views/ctquoi.html'
  })
  .state('about', {
    url: '/about',
    templateUrl: 'views/about.html'
  })
})

.controller("MainCtrl", ['$scope', '$ionicActionSheet', 'OnAir', 'AudioPlayer', 'Utils', 
  function($scope, $ionicActionSheet, RJROnAir, AudioPlayer, Utils) {
  // --- Attributs ---
  $scope.onair = { 
    artist: "Chargement...", 
    title: "", 
    cover: RJROnAir.noCover,
    start_time: 0
  };
  $scope.ctquoi = RJROnAir.getCTQuoi;
  $scope.timeTo24H = Utils.timeTo24H;
  $scope.audioVolume = 50;
  $scope.audioPlaying = AudioPlayer.isPlaying();
  $scope.audioLoading = AudioPlayer.isLoading();

  // --- Méthodes du scope ---
  $scope.audioToggle = function() {
    AudioPlayer.toggle();
  };

  $scope.volumeChanged = function(vol) {
    AudioPlayer.setVolume($scope.audioVolume);
  }

  $scope.streamSelect = function() {
    var streams = AudioPlayer.getStreamList();

    var sheetButtons = [];
    var selectedIndex = AudioPlayer.getSelectedStream();
    streams.forEach(function(value, index) {
      var textValue = value.description;
      if(index === selectedIndex) {
        textValue = '<b>'+textValue+'</b>';
      }

      sheetButtons.push({
        text: textValue
      });
    });

    $ionicActionSheet.show({
      titleText: 'Sélection du flux radio',
      buttons: sheetButtons,
      cancelText: 'Annuler',
      buttonClicked: function(index) {
        console.log('Selected stream : '+index);
        AudioPlayer.setStream(index);
        AudioPlayer.stop();
        setTimeout(function() {
          AudioPlayer.play();
        }, 500);

        return true;
      }
    });
  }

  // --- Initialisation ---
  // Callback pour le refresh auto
  RJROnAir.setCallback(function(data) {
    $scope.onair = data;
  });
}])

.controller('CTQuoiCtrl', ['$scope', 'OnAir', 'Utils', function($scope, RJROnAir, Utils) {
  $scope.timeTo24H = Utils.timeTo24H;
  $scope.ctquoi = RJROnAir.getCTQuoi;
}])
