angular.module('rjr')

.factory('OnAir', ['$http', '$interval', function($http, $interval) {
	var baseUrl = "http://www.rjrradio.fr";

	var onairUrl = baseUrl + "/titrage/onair.json";
	var ctquoiUrl = baseUrl + "/titrage/playlist.json";

	var noCover = "img/nocd.png";

	var nowPlaying = {
		artist: "",
		title: "",
		start_time: 0
	};
	var CTQuoi = {};

	var updateCallback = function() {}

	function fetchNowPlaying() {
		$http.get(onairUrl).success(function(data) {
			if(data.start_time > nowPlaying.start_time) {
				if(data.cover == null) {
      				data.cover = noCover;
    			}

    			if(data.type != 'Music') {
    				data.title = 'Emission';
    				data.artist = '';
    			}

    			if(nowPlaying.start_time != 0) {
      				CTQuoi.splice(0, 0, nowPlaying); // Ajout du morceau précédent dans le CTQuoi
      				CTQuoi.pop(); // Ejection du plus vieil élément du CTQuoi
    			}

				nowPlaying = data;
				updateCallback(nowPlaying);
			}
		});
		return true;
	}

	function fetchCTQuoi() {
		$http.get(ctquoiUrl).success(function(data) {
			data = data.reverse();
			data.splice(0, 1);
			
			angular.forEach(data, function(value, key) {
      			if(value.cover == null) {
        			value.cover = noCover;
      			}

      			if(value.type != 'Music') {
      				value.title = 'Emission';
      				value.artist = '';
      			}
    		});

			CTQuoi = data;
		});
		return true;
	}

	function init() {
		fetchNowPlaying();
		fetchCTQuoi();
	}

	function refresh() {
		fetchNowPlaying();
	}

	var getNowPlaying = function() {
		return nowPlaying;
	}

	var getCTQuoi = function() {
		return CTQuoi;
	}

	var setCallback = function(cb) {
		updateCallback = cb;
	}

	init();
	$interval(function(){
		refresh();
	}, 2000);
	
	return {
		getNowPlaying: getNowPlaying,
		getCTQuoi: getCTQuoi,
		setCallback: setCallback,
		noCover: noCover
	};
}]);
