$(document).ready(function() {
  $('#formButtonAdd').bind('click',function() {
    taxAdd();
  });
  
  storageLoad();
    
  mainDataDefault();
  mainTaxDelete();
  mainSaveToStorage();
  
  // ui interactions
  
  $('.uiOverflow').bind('click',function(event) {
    navHashSet('navOverflow');
    event.stopPropagation();
  });

  $('#overflowMenu').bind('click',function(event) {
    event.stopPropagation();
  });

  $(document).bind('click',function() {
    if ($('#overflowMenu').is(':visible')) {
      navHashRemove();
    }
  });

  $('.uiCalculate').bind('click',function(event) {
    navHashSet('navCalculate');
  });
  
  $('.uiAbout').bind('click',function(event) {
    navHashSet('navAbout');
  });
  
  navHash();
});

$(window).bind('hashchange',function() {  
  navHash();
});

String.prototype.htmlSafe=function () {
  return $("<div/>").text(this).html();
}

function mainDataDefault() {
  $('input[data-default],textarea[data-default]').each(function() {
    if (!$(this).val()) {
      $(this).val($(this).attr('data-default'));
    }
  }).focus(function() {
    if ($(this).val()==$(this).attr('data-default')) {
      $(this).val('');
    }
  }).blur(function() {
    if ($(this).val()=='') {
      $(this).val($(this).attr('data-default'));
    }
  });
}

function mainTaxDelete() {
  $('.taxDelete').bind('click',function() {
    $(this).closest('.formTable').remove();
    storageSave();
  });
}

function mainSaveToStorage() {
  $('#formMain input').bind('change',function () {
    storageSave();
  });  
}

function storageSave() {
  localStorage.trip=$('#formMain').serializeJSON();
}

function storageLoad() {
  if (localStorage.trip) {
    var trip=JSON.parse(localStorage.trip);
    for (var i in trip) {
      if (typeof(trip[i])=='string') {
        $('#formMain input[name='+i+']').val(trip[i]);
      }
    }
    for (i in trip.tax) {
      taxAdd(trip.tax[i].name,trip.tax[i].cost);
    }
  }
}

function taxAdd(name,cost) {
  var o=$(
    '<div class="formWidgets formTable">'+
      '<div>'+
        '<input type="text" name="tax[][name]" class="formInput" maxlength="50" data-default="Tax name"'+(name!==undefined?' value="'+String(name).htmlSafe()+'"':'')+'>'+
      '</div>'+
      '<div>'+
        '<input type="text" name="tax[][cost]" class="formInput" maxlength="10" data-default="Cost"'+(cost!==undefined?' value="'+String(cost).htmlSafe()+'"':'')+'>'+
      '</div>'+
      '<div>'+
        '<i class="taxDelete">&#xf00d;</i>'+
      '</div>'+
    '</div>'
  );
  o.appendTo($('#formTaxes'));
  
  mainDataDefault();
  mainTaxDelete();
  mainSaveToStorage();
}

function overflowShow() {
  $('#overflowMenu').show();
}

function overflowHide() {
  $('#overflowMenu').hide();
}

function navHashSet(h) {
  if (window.location.hash.substr(1)=='navOverflow') {
    history.replaceState('',document.title,window.location.pathname+window.location.search+'#'+h);
    navHash();
  } else {
    window.location.hash=h;
  }
}

function navHashRemove() {
  history.go(-1);
}

function navHash() {
  switch(window.location.hash.substr(1)) {
    case 'navOverflow':
      overflowShow();
      break;
    case 'navCalculate':
      overflowHide();
      uiCalculate();
      break;
    case 'navAbout':
      overflowHide();
      uiAbout();
      break;
    case '':
      overflowHide();
      dialogClose();
      break;
  }
}

function dialogOpen(html) {
  $(
    '<div class="dialog" id="dialog">'+
      '<div>'+
        html+
      '</div>'+
    '</div>'
  ).appendTo($('body'));
}

function dialogClose() {
  $('#dialog').remove();
}

function uiAbout() {
  dialogOpen(
    '<div class="dialogTitle">Road Trip Calculator</div>'+
    '<div class="dialogNormal">&copy; 2015 Boancă Șerban</div>'+
    '<div class="dialogNormal">Support future development,<br>consider making a donation:</div>'+
    '<div class="dialogNormal">'+
    
    '<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_blank">'+
    '<input type="hidden" name="cmd" value="_s-xclick">'+
    '<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----">'+
    '<input type="image" src="images/paypal.png" border="0" name="submit" alt="Donate" class="dialogPayPal">'+
    '</form>'+
    
    '</div>'+
    '<button class="dialogButton" onclick="navHashRemove();">Ok</button>',
    'navCalculate'
  );
}

function uiCalculate() {  
  var error=false,
      fields=['km','passengers','fuelConsumption','fuelPrice'],
      values={},
      total=0;
  
  var trip=$('#formMain').serializeObject();
  
  for (var i in fields) {
    if (!trip[fields[i]].match(/^[0-9\.\-]+$/)) {
      error=true;
    } else {
      trip[fields[i]]=parseFloat(trip[fields[i]]);
    }
  }
  
  for (i in trip.tax) {
    if (!trip.tax[i].cost.match(/^[0-9\.\-]+$/)) {
      error=true;
    } else {
      total+=parseFloat(trip.tax[i].cost);      
    }
  }

  if (!error) {
    total+=trip.km*trip.fuelConsumption/100*trip.fuelPrice;
    total=Math.round(total/trip.passengers*100)/100;
    dialogOpen(
      '<div class="dialogTitle">'+total+'</div>'+
      '<div class="dialogNormal">per passenger</div>'+
      '<button class="dialogButton" onclick="navHashRemove();">Ok</button>',
      'navCalculate'
    );
  } else {
    dialogOpen(
      '<div class="dialogTitle">Incomplete</div>'+
      '<div class="dialogNormal">You must fill all the fields</div>'+
      '<button class="dialogButton" onclick="navHashRemove();">Ok</button>',
      'navCalculate'
    );
  }
}