var $hxClasses = $hxClasses || {},$estr = function() { return js.Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function inherit() {}; inherit.prototype = from; var proto = new inherit();
	for (var name in fields) proto[name] = fields[name];
	return proto;
}
var EReg = $hxClasses["EReg"] = function(r,opt) {
	opt = opt.split("u").join("");
	this.r = new RegExp(r,opt);
};
EReg.__name__ = ["EReg"];
EReg.prototype = {
	customReplace: function(s,f) {
		var buf = new StringBuf();
		while(true) {
			if(!this.match(s)) break;
			buf.b += Std.string(this.matchedLeft());
			buf.b += Std.string(f(this));
			s = this.matchedRight();
		}
		buf.b += Std.string(s);
		return buf.b;
	}
	,replace: function(s,by) {
		return s.replace(this.r,by);
	}
	,split: function(s) {
		var d = "#__delim__#";
		return s.replace(this.r,d).split(d);
	}
	,matchedPos: function() {
		if(this.r.m == null) throw "No string matched";
		return { pos : this.r.m.index, len : this.r.m[0].length};
	}
	,matchedRight: function() {
		if(this.r.m == null) throw "No string matched";
		var sz = this.r.m.index + this.r.m[0].length;
		return this.r.s.substr(sz,this.r.s.length - sz);
	}
	,matchedLeft: function() {
		if(this.r.m == null) throw "No string matched";
		return this.r.s.substr(0,this.r.m.index);
	}
	,matched: function(n) {
		return this.r.m != null && n >= 0 && n < this.r.m.length?this.r.m[n]:(function($this) {
			var $r;
			throw "EReg::matched";
			return $r;
		}(this));
	}
	,match: function(s) {
		if(this.r.global) this.r.lastIndex = 0;
		this.r.m = this.r.exec(s);
		this.r.s = s;
		return this.r.m != null;
	}
	,r: null
	,__class__: EReg
}
var Helper = $hxClasses["Helper"] = function() { }
Helper.__name__ = ["Helper"];
Helper.getDistance = function(p1,p2) {
	var distX = p1.x - p2.x;
	var distY = p1.y - p2.y;
	var dist = Math.sqrt(distX * distX + distY * distY);
	return dist;
}
Helper.average = function(arr) {
	var sum = 0;
	var _g = 0;
	while(_g < arr.length) {
		var i = arr[_g];
		++_g;
		sum += i;
	}
	return sum / arr.length;
}
var HxOverrides = $hxClasses["HxOverrides"] = function() { }
HxOverrides.__name__ = ["HxOverrides"];
HxOverrides.dateStr = function(date) {
	var m = date.getMonth() + 1;
	var d = date.getDate();
	var h = date.getHours();
	var mi = date.getMinutes();
	var s = date.getSeconds();
	return date.getFullYear() + "-" + (m < 10?"0" + m:"" + m) + "-" + (d < 10?"0" + d:"" + d) + " " + (h < 10?"0" + h:"" + h) + ":" + (mi < 10?"0" + mi:"" + mi) + ":" + (s < 10?"0" + s:"" + s);
}
HxOverrides.strDate = function(s) {
	switch(s.length) {
	case 8:
		var k = s.split(":");
		var d = new Date();
		d.setTime(0);
		d.setUTCHours(k[0]);
		d.setUTCMinutes(k[1]);
		d.setUTCSeconds(k[2]);
		return d;
	case 10:
		var k = s.split("-");
		return new Date(k[0],k[1] - 1,k[2],0,0,0);
	case 19:
		var k = s.split(" ");
		var y = k[0].split("-");
		var t = k[1].split(":");
		return new Date(y[0],y[1] - 1,y[2],t[0],t[1],t[2]);
	default:
		throw "Invalid date format : " + s;
	}
}
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) return undefined;
	return x;
}
HxOverrides.substr = function(s,pos,len) {
	if(pos != null && pos != 0 && len != null && len < 0) return "";
	if(len == null) len = s.length;
	if(pos < 0) {
		pos = s.length + pos;
		if(pos < 0) pos = 0;
	} else if(len < 0) len = s.length + len - pos;
	return s.substr(pos,len);
}
HxOverrides.remove = function(a,obj) {
	var i = 0;
	var l = a.length;
	while(i < l) {
		if(a[i] == obj) {
			a.splice(i,1);
			return true;
		}
		i++;
	}
	return false;
}
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
}
var IntIter = $hxClasses["IntIter"] = function(min,max) {
	this.min = min;
	this.max = max;
};
IntIter.__name__ = ["IntIter"];
IntIter.prototype = {
	next: function() {
		return this.min++;
	}
	,hasNext: function() {
		return this.min < this.max;
	}
	,max: null
	,min: null
	,__class__: IntIter
}
var Lambda = $hxClasses["Lambda"] = function() { }
Lambda.__name__ = ["Lambda"];
Lambda.array = function(it) {
	var a = new Array();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var i = $it0.next();
		a.push(i);
	}
	return a;
}
Lambda.list = function(it) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var i = $it0.next();
		l.add(i);
	}
	return l;
}
Lambda.map = function(it,f) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		l.add(f(x));
	}
	return l;
}
Lambda.mapi = function(it,f) {
	var l = new List();
	var i = 0;
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		l.add(f(i++,x));
	}
	return l;
}
Lambda.has = function(it,elt,cmp) {
	if(cmp == null) {
		var $it0 = $iterator(it)();
		while( $it0.hasNext() ) {
			var x = $it0.next();
			if(x == elt) return true;
		}
	} else {
		var $it1 = $iterator(it)();
		while( $it1.hasNext() ) {
			var x = $it1.next();
			if(cmp(x,elt)) return true;
		}
	}
	return false;
}
Lambda.exists = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(f(x)) return true;
	}
	return false;
}
Lambda.foreach = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(!f(x)) return false;
	}
	return true;
}
Lambda.iter = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		f(x);
	}
}
Lambda.filter = function(it,f) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(f(x)) l.add(x);
	}
	return l;
}
Lambda.fold = function(it,f,first) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		first = f(x,first);
	}
	return first;
}
Lambda.count = function(it,pred) {
	var n = 0;
	if(pred == null) {
		var $it0 = $iterator(it)();
		while( $it0.hasNext() ) {
			var _ = $it0.next();
			n++;
		}
	} else {
		var $it1 = $iterator(it)();
		while( $it1.hasNext() ) {
			var x = $it1.next();
			if(pred(x)) n++;
		}
	}
	return n;
}
Lambda.empty = function(it) {
	return !$iterator(it)().hasNext();
}
Lambda.indexOf = function(it,v) {
	var i = 0;
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var v2 = $it0.next();
		if(v == v2) return i;
		i++;
	}
	return -1;
}
Lambda.concat = function(a,b) {
	var l = new List();
	var $it0 = $iterator(a)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		l.add(x);
	}
	var $it1 = $iterator(b)();
	while( $it1.hasNext() ) {
		var x = $it1.next();
		l.add(x);
	}
	return l;
}
var List = $hxClasses["List"] = function() {
	this.length = 0;
};
List.__name__ = ["List"];
List.prototype = {
	map: function(f) {
		var b = new List();
		var l = this.h;
		while(l != null) {
			var v = l[0];
			l = l[1];
			b.add(f(v));
		}
		return b;
	}
	,filter: function(f) {
		var l2 = new List();
		var l = this.h;
		while(l != null) {
			var v = l[0];
			l = l[1];
			if(f(v)) l2.add(v);
		}
		return l2;
	}
	,join: function(sep) {
		var s = new StringBuf();
		var first = true;
		var l = this.h;
		while(l != null) {
			if(first) first = false; else s.b += Std.string(sep);
			s.b += Std.string(l[0]);
			l = l[1];
		}
		return s.b;
	}
	,toString: function() {
		var s = new StringBuf();
		var first = true;
		var l = this.h;
		s.b += Std.string("{");
		while(l != null) {
			if(first) first = false; else s.b += Std.string(", ");
			s.b += Std.string(Std.string(l[0]));
			l = l[1];
		}
		s.b += Std.string("}");
		return s.b;
	}
	,iterator: function() {
		return { h : this.h, hasNext : function() {
			return this.h != null;
		}, next : function() {
			if(this.h == null) return null;
			var x = this.h[0];
			this.h = this.h[1];
			return x;
		}};
	}
	,remove: function(v) {
		var prev = null;
		var l = this.h;
		while(l != null) {
			if(l[0] == v) {
				if(prev == null) this.h = l[1]; else prev[1] = l[1];
				if(this.q == l) this.q = prev;
				this.length--;
				return true;
			}
			prev = l;
			l = l[1];
		}
		return false;
	}
	,clear: function() {
		this.h = null;
		this.q = null;
		this.length = 0;
	}
	,isEmpty: function() {
		return this.h == null;
	}
	,pop: function() {
		if(this.h == null) return null;
		var x = this.h[0];
		this.h = this.h[1];
		if(this.h == null) this.q = null;
		this.length--;
		return x;
	}
	,last: function() {
		return this.q == null?null:this.q[0];
	}
	,first: function() {
		return this.h == null?null:this.h[0];
	}
	,push: function(item) {
		var x = [item,this.h];
		this.h = x;
		if(this.q == null) this.q = x;
		this.length++;
	}
	,add: function(item) {
		var x = [item];
		if(this.h == null) this.h = x; else this.q[1] = x;
		this.q = x;
		this.length++;
	}
	,length: null
	,q: null
	,h: null
	,__class__: List
}
var Reflect = $hxClasses["Reflect"] = function() { }
Reflect.__name__ = ["Reflect"];
Reflect.hasField = function(o,field) {
	return Object.prototype.hasOwnProperty.call(o,field);
}
Reflect.field = function(o,field) {
	var v = null;
	try {
		v = o[field];
	} catch( e ) {
	}
	return v;
}
Reflect.setField = function(o,field,value) {
	o[field] = value;
}
Reflect.getProperty = function(o,field) {
	var tmp;
	return o == null?null:o.__properties__ && (tmp = o.__properties__["get_" + field])?o[tmp]():o[field];
}
Reflect.setProperty = function(o,field,value) {
	var tmp;
	if(o.__properties__ && (tmp = o.__properties__["set_" + field])) o[tmp](value); else o[field] = value;
}
Reflect.callMethod = function(o,func,args) {
	return func.apply(o,args);
}
Reflect.fields = function(o) {
	var a = [];
	if(o != null) {
		var hasOwnProperty = Object.prototype.hasOwnProperty;
		for( var f in o ) {
		if(hasOwnProperty.call(o,f)) a.push(f);
		}
	}
	return a;
}
Reflect.isFunction = function(f) {
	return typeof(f) == "function" && !(f.__name__ || f.__ename__);
}
Reflect.compare = function(a,b) {
	return a == b?0:a > b?1:-1;
}
Reflect.compareMethods = function(f1,f2) {
	if(f1 == f2) return true;
	if(!Reflect.isFunction(f1) || !Reflect.isFunction(f2)) return false;
	return f1.scope == f2.scope && f1.method == f2.method && f1.method != null;
}
Reflect.isObject = function(v) {
	if(v == null) return false;
	var t = typeof(v);
	return t == "string" || t == "object" && !v.__enum__ || t == "function" && (v.__name__ || v.__ename__);
}
Reflect.deleteField = function(o,f) {
	if(!Reflect.hasField(o,f)) return false;
	delete(o[f]);
	return true;
}
Reflect.copy = function(o) {
	var o2 = { };
	var _g = 0, _g1 = Reflect.fields(o);
	while(_g < _g1.length) {
		var f = _g1[_g];
		++_g;
		o2[f] = Reflect.field(o,f);
	}
	return o2;
}
Reflect.makeVarArgs = function(f) {
	return function() {
		var a = Array.prototype.slice.call(arguments);
		return f(a);
	};
}
var Std = $hxClasses["Std"] = function() { }
Std.__name__ = ["Std"];
Std["is"] = function(v,t) {
	return js.Boot.__instanceof(v,t);
}
Std.string = function(s) {
	return js.Boot.__string_rec(s,"");
}
Std["int"] = function(x) {
	return x | 0;
}
Std.parseInt = function(x) {
	var v = parseInt(x,10);
	if(v == 0 && (HxOverrides.cca(x,1) == 120 || HxOverrides.cca(x,1) == 88)) v = parseInt(x);
	if(isNaN(v)) return null;
	return v;
}
Std.parseFloat = function(x) {
	return parseFloat(x);
}
Std.random = function(x) {
	return Math.floor(Math.random() * x);
}
var StringBuf = $hxClasses["StringBuf"] = function() {
	this.b = "";
};
StringBuf.__name__ = ["StringBuf"];
StringBuf.prototype = {
	toString: function() {
		return this.b;
	}
	,addSub: function(s,pos,len) {
		this.b += HxOverrides.substr(s,pos,len);
	}
	,addChar: function(c) {
		this.b += String.fromCharCode(c);
	}
	,add: function(x) {
		this.b += Std.string(x);
	}
	,b: null
	,__class__: StringBuf
}
var StringTools = $hxClasses["StringTools"] = function() { }
StringTools.__name__ = ["StringTools"];
StringTools.urlEncode = function(s) {
	return encodeURIComponent(s);
}
StringTools.urlDecode = function(s) {
	return decodeURIComponent(s.split("+").join(" "));
}
StringTools.htmlEscape = function(s) {
	return s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
}
StringTools.htmlUnescape = function(s) {
	return s.split("&gt;").join(">").split("&lt;").join("<").split("&amp;").join("&");
}
StringTools.startsWith = function(s,start) {
	return s.length >= start.length && HxOverrides.substr(s,0,start.length) == start;
}
StringTools.endsWith = function(s,end) {
	var elen = end.length;
	var slen = s.length;
	return slen >= elen && HxOverrides.substr(s,slen - elen,elen) == end;
}
StringTools.isSpace = function(s,pos) {
	var c = HxOverrides.cca(s,pos);
	return c >= 9 && c <= 13 || c == 32;
}
StringTools.ltrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,r)) r++;
	if(r > 0) return HxOverrides.substr(s,r,l - r); else return s;
}
StringTools.rtrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,l - r - 1)) r++;
	if(r > 0) return HxOverrides.substr(s,0,l - r); else return s;
}
StringTools.trim = function(s) {
	return StringTools.ltrim(StringTools.rtrim(s));
}
StringTools.rpad = function(s,c,l) {
	var sl = s.length;
	var cl = c.length;
	while(sl < l) if(l - sl < cl) {
		s += HxOverrides.substr(c,0,l - sl);
		sl = l;
	} else {
		s += c;
		sl += cl;
	}
	return s;
}
StringTools.lpad = function(s,c,l) {
	var ns = "";
	var sl = s.length;
	if(sl >= l) return s;
	var cl = c.length;
	while(sl < l) if(l - sl < cl) {
		ns += HxOverrides.substr(c,0,l - sl);
		sl = l;
	} else {
		ns += c;
		sl += cl;
	}
	return ns + s;
}
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
}
StringTools.hex = function(n,digits) {
	var s = "";
	var hexChars = "0123456789ABCDEF";
	do {
		s = hexChars.charAt(n & 15) + s;
		n >>>= 4;
	} while(n > 0);
	if(digits != null) while(s.length < digits) s = "0" + s;
	return s;
}
StringTools.fastCodeAt = function(s,index) {
	return s.charCodeAt(index);
}
StringTools.isEOF = function(c) {
	return c != c;
}
var ValueType = $hxClasses["ValueType"] = { __ename__ : ["ValueType"], __constructs__ : ["TNull","TInt","TFloat","TBool","TObject","TFunction","TClass","TEnum","TUnknown"] }
ValueType.TNull = ["TNull",0];
ValueType.TNull.toString = $estr;
ValueType.TNull.__enum__ = ValueType;
ValueType.TInt = ["TInt",1];
ValueType.TInt.toString = $estr;
ValueType.TInt.__enum__ = ValueType;
ValueType.TFloat = ["TFloat",2];
ValueType.TFloat.toString = $estr;
ValueType.TFloat.__enum__ = ValueType;
ValueType.TBool = ["TBool",3];
ValueType.TBool.toString = $estr;
ValueType.TBool.__enum__ = ValueType;
ValueType.TObject = ["TObject",4];
ValueType.TObject.toString = $estr;
ValueType.TObject.__enum__ = ValueType;
ValueType.TFunction = ["TFunction",5];
ValueType.TFunction.toString = $estr;
ValueType.TFunction.__enum__ = ValueType;
ValueType.TClass = function(c) { var $x = ["TClass",6,c]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; }
ValueType.TEnum = function(e) { var $x = ["TEnum",7,e]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; }
ValueType.TUnknown = ["TUnknown",8];
ValueType.TUnknown.toString = $estr;
ValueType.TUnknown.__enum__ = ValueType;
var Type = $hxClasses["Type"] = function() { }
Type.__name__ = ["Type"];
Type.getClass = function(o) {
	if(o == null) return null;
	return o.__class__;
}
Type.getEnum = function(o) {
	if(o == null) return null;
	return o.__enum__;
}
Type.getSuperClass = function(c) {
	return c.__super__;
}
Type.getClassName = function(c) {
	var a = c.__name__;
	return a.join(".");
}
Type.getEnumName = function(e) {
	var a = e.__ename__;
	return a.join(".");
}
Type.resolveClass = function(name) {
	var cl = $hxClasses[name];
	if(cl == null || !cl.__name__) return null;
	return cl;
}
Type.resolveEnum = function(name) {
	var e = $hxClasses[name];
	if(e == null || !e.__ename__) return null;
	return e;
}
Type.createInstance = function(cl,args) {
	switch(args.length) {
	case 0:
		return new cl();
	case 1:
		return new cl(args[0]);
	case 2:
		return new cl(args[0],args[1]);
	case 3:
		return new cl(args[0],args[1],args[2]);
	case 4:
		return new cl(args[0],args[1],args[2],args[3]);
	case 5:
		return new cl(args[0],args[1],args[2],args[3],args[4]);
	case 6:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5]);
	case 7:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6]);
	case 8:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7]);
	default:
		throw "Too many arguments";
	}
	return null;
}
Type.createEmptyInstance = function(cl) {
	function empty() {}; empty.prototype = cl.prototype;
	return new empty();
}
Type.createEnum = function(e,constr,params) {
	var f = Reflect.field(e,constr);
	if(f == null) throw "No such constructor " + constr;
	if(Reflect.isFunction(f)) {
		if(params == null) throw "Constructor " + constr + " need parameters";
		return f.apply(e,params);
	}
	if(params != null && params.length != 0) throw "Constructor " + constr + " does not need parameters";
	return f;
}
Type.createEnumIndex = function(e,index,params) {
	var c = e.__constructs__[index];
	if(c == null) throw index + " is not a valid enum constructor index";
	return Type.createEnum(e,c,params);
}
Type.getInstanceFields = function(c) {
	var a = [];
	for(var i in c.prototype) a.push(i);
	HxOverrides.remove(a,"__class__");
	HxOverrides.remove(a,"__properties__");
	return a;
}
Type.getClassFields = function(c) {
	var a = Reflect.fields(c);
	HxOverrides.remove(a,"__name__");
	HxOverrides.remove(a,"__interfaces__");
	HxOverrides.remove(a,"__properties__");
	HxOverrides.remove(a,"__super__");
	HxOverrides.remove(a,"prototype");
	return a;
}
Type.getEnumConstructs = function(e) {
	var a = e.__constructs__;
	return a.slice();
}
Type["typeof"] = function(v) {
	switch(typeof(v)) {
	case "boolean":
		return ValueType.TBool;
	case "string":
		return ValueType.TClass(String);
	case "number":
		if(Math.ceil(v) == v % 2147483648.0) return ValueType.TInt;
		return ValueType.TFloat;
	case "object":
		if(v == null) return ValueType.TNull;
		var e = v.__enum__;
		if(e != null) return ValueType.TEnum(e);
		var c = v.__class__;
		if(c != null) return ValueType.TClass(c);
		return ValueType.TObject;
	case "function":
		if(v.__name__ || v.__ename__) return ValueType.TObject;
		return ValueType.TFunction;
	case "undefined":
		return ValueType.TNull;
	default:
		return ValueType.TUnknown;
	}
}
Type.enumEq = function(a,b) {
	if(a == b) return true;
	try {
		if(a[0] != b[0]) return false;
		var _g1 = 2, _g = a.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(!Type.enumEq(a[i],b[i])) return false;
		}
		var e = a.__enum__;
		if(e != b.__enum__ || e == null) return false;
	} catch( e ) {
		return false;
	}
	return true;
}
Type.enumConstructor = function(e) {
	return e[0];
}
Type.enumParameters = function(e) {
	return e.slice(2);
}
Type.enumIndex = function(e) {
	return e[1];
}
Type.allEnums = function(e) {
	var all = [];
	var cst = e.__constructs__;
	var _g = 0;
	while(_g < cst.length) {
		var c = cst[_g];
		++_g;
		var v = Reflect.field(e,c);
		if(!Reflect.isFunction(v)) all.push(v);
	}
	return all;
}
var co = co || {}
if(!co.doubleduck) co.doubleduck = {}
co.doubleduck.BaseAssets = $hxClasses["co.doubleduck.BaseAssets"] = function() {
};
co.doubleduck.BaseAssets.__name__ = ["co","doubleduck","BaseAssets"];
co.doubleduck.BaseAssets._localizedAssets = null;
co.doubleduck.BaseAssets.loader = function() {
	if(co.doubleduck.BaseAssets._loader == null) {
		co.doubleduck.BaseAssets._loader = new createjs.LoadQueue(true);
		co.doubleduck.BaseAssets._loader.installPlugin(createjs.LoadQueue.SOUND);
		co.doubleduck.BaseAssets._loader.onFileLoad = co.doubleduck.BaseAssets.handleFileLoaded;
		co.doubleduck.BaseAssets._loader.onError = co.doubleduck.BaseAssets.handleLoadError;
		co.doubleduck.BaseAssets._loader.setMaxConnections(10);
	}
	return co.doubleduck.BaseAssets._loader;
}
co.doubleduck.BaseAssets.loadAndCall = function(uri,callbackFunc) {
	co.doubleduck.BaseAssets.loader().loadFile(uri);
	co.doubleduck.BaseAssets._loadCallbacks[uri] = callbackFunc;
}
co.doubleduck.BaseAssets.finishLoading = function(manifest,sounds) {
	if(co.doubleduck.SoundManager.available) {
		var _g1 = 0, _g = sounds.length;
		while(_g1 < _g) {
			var currSound = _g1++;
			manifest.push(sounds[currSound] + co.doubleduck.SoundManager.EXTENSION);
			co.doubleduck.SoundManager.initSound(sounds[currSound]);
		}
	}
	if(co.doubleduck.BaseAssets._useLocalStorage) co.doubleduck.BaseAssets.loadFromLocalStorage(manifest);
	if(manifest.length == 0) {
		if(co.doubleduck.BaseAssets.onLoadAll != null) co.doubleduck.BaseAssets.onLoadAll();
	}
	if(co.doubleduck.BaseGame.isLocalized && co.doubleduck.BaseAssets._localizedAssets != null) {
		var _g1 = 0, _g = manifest.length;
		while(_g1 < _g) {
			var itemIndex = _g1++;
			var currItem = manifest[itemIndex];
			currItem = co.doubleduck.BaseAssets.getLocalisedImage(currItem);
			manifest[itemIndex] = currItem;
		}
	}
	co.doubleduck.BaseAssets.loader().onProgress = co.doubleduck.BaseAssets.handleProgress;
	co.doubleduck.BaseAssets.loader().onFileLoad = co.doubleduck.BaseAssets.manifestFileLoad;
	co.doubleduck.BaseAssets.loader().loadManifest(manifest);
	co.doubleduck.BaseAssets.loader().load();
}
co.doubleduck.BaseAssets.loadAll = function(manifest,sounds) {
	manifest[manifest.length] = "images/duckling/orientation_error_port.png";
	manifest[manifest.length] = "images/duckling/orientation_error_land.png";
	manifest[manifest.length] = "images/duckling/page_marker.png";
}
co.doubleduck.BaseAssets.setLocalizedAssets = function(assets) {
	co.doubleduck.BaseAssets._localizedAssets = assets;
}
co.doubleduck.BaseAssets.audioLoaded = function(event) {
	co.doubleduck.BaseAssets._cacheData[event.item.src] = event;
}
co.doubleduck.BaseAssets.manifestFileLoad = function(event) {
	if(co.doubleduck.BaseAssets._useLocalStorage && event != null) {
		var utils = new ddjsutils();
		try {
			var fileName = event.item.src;
			if(HxOverrides.substr(fileName,fileName.length - 3,null) == "jpg") return;
			co.doubleduck.BasePersistence.setValue(event.item.src,utils.getBase64Image(event.result));
		} catch( err ) {
		}
	}
}
co.doubleduck.BaseAssets.loadFromLocalStorage = function(manifest) {
	var entriesToRemove = new Array();
	var _g1 = 0, _g = manifest.length;
	while(_g1 < _g) {
		var i = _g1++;
		var entry = manifest[i];
		var value = co.doubleduck.BasePersistence.getValue(entry);
		if(value != null) {
			var bmp = new createjs.Bitmap("data:image/png;base64," + value);
			co.doubleduck.BaseAssets._cacheData[entry] = bmp.image;
			entriesToRemove.push(manifest[i]);
		}
	}
	var _g1 = 0, _g = entriesToRemove.length;
	while(_g1 < _g) {
		var j = _g1++;
		HxOverrides.remove(manifest,entriesToRemove[j]);
	}
}
co.doubleduck.BaseAssets.handleProgress = function(event) {
	co.doubleduck.BaseAssets.loaded = event.loaded;
	if(event.loaded == event.total) {
		co.doubleduck.BaseAssets.loader().onProgress = null;
		co.doubleduck.BaseAssets.onLoadAll();
	}
}
co.doubleduck.BaseAssets.handleLoadError = function(event) {
}
co.doubleduck.BaseAssets.handleFileLoaded = function(event) {
	if(event != null) {
		co.doubleduck.BaseAssets._cacheData[event.item.src] = event.result;
		var callbackFunc = Reflect.field(co.doubleduck.BaseAssets._loadCallbacks,event.item.src);
		if(callbackFunc != null) callbackFunc();
	}
}
co.doubleduck.BaseAssets.getAsset = function(uri) {
	var cache = Reflect.field(co.doubleduck.BaseAssets._cacheData,uri);
	if(cache == null) {
		if(co.doubleduck.BaseAssets.loader().getResult(uri) != null) {
			cache = co.doubleduck.BaseAssets.loader().getResult(uri);
			co.doubleduck.BaseAssets._cacheData[uri] = cache;
		}
	}
	return cache;
}
co.doubleduck.BaseAssets.getLocalisedImage = function(image) {
	var currItem = image;
	if(co.doubleduck.BaseAssets._localizedAssets != null && Lambda.indexOf(co.doubleduck.BaseAssets._localizedAssets,currItem) != -1) {
		var delim = ".png";
		var delimIndex = currItem.indexOf(delim);
		var localisedItem = HxOverrides.substr(currItem,0,delimIndex);
		localisedItem += "-" + co.doubleduck.BaseGame.activeLocale + ".png";
		return localisedItem;
	}
	return currItem;
}
co.doubleduck.BaseAssets.getRawImage = function(uri) {
	uri = co.doubleduck.BaseAssets.getLocalisedImage(uri);
	var cache = co.doubleduck.BaseAssets.getAsset(uri);
	if(cache == null) {
		var bmp = new createjs.Bitmap(uri);
		co.doubleduck.BaseAssets._cacheData[uri] = bmp.image;
		cache = bmp.image;
		null;
	}
	return cache;
}
co.doubleduck.BaseAssets.getImage = function(uri,mouseEnabled) {
	if(mouseEnabled == null) mouseEnabled = false;
	var result = new createjs.Bitmap(co.doubleduck.BaseAssets.getRawImage(uri));
	result.mouseEnabled = mouseEnabled;
	return result;
}
co.doubleduck.BaseAssets.prototype = {
	__class__: co.doubleduck.BaseAssets
}
co.doubleduck.Assets = $hxClasses["co.doubleduck.Assets"] = function() {
	co.doubleduck.BaseAssets.call(this);
};
co.doubleduck.Assets.__name__ = ["co","doubleduck","Assets"];
co.doubleduck.Assets.loadAll = function() {
	var manifest = new Array();
	var sounds = new Array();
	sounds.push("sound/button");
	sounds.push("sound/casino_ambience");
	sounds.push("sound/chip_place");
	sounds.push("sound/chip_remove");
	sounds.push("sound/chip_select");
	sounds.push("sound/chip_win_big");
	sounds.push("sound/chip_win_small");
	sounds.push("sound/get_chips");
	sounds.push("sound/menu_music");
	sounds.push("sound/spin_end");
	var _g1 = 1, _g = co.doubleduck.DataLoader.getCasinosCount();
	while(_g1 < _g) {
		var i = _g1++;
		sounds.push("sound/theme_spin" + i);
	}
	sounds.push("sound/unlock_new_area");
	co.doubleduck.BaseAssets.loadAll(manifest,sounds);
	var localisedAssets = [];
	manifest.push("images/splash/logo.png");
	manifest.push("images/splash/tap.png");
	localisedAssets.push("images/splash/tap.png");
	manifest.push("images/general/hud/fame.png");
	manifest.push("images/general/hud/hud.png");
	manifest.push("images/session/lvl_up.png");
	manifest.push("images/general/hud/lvl_badge.png");
	var _g1 = 0, _g = co.doubleduck.DataLoader.getCasinosCount();
	while(_g1 < _g) {
		var i = _g1++;
		manifest.push("images/general/hud/lvl_font/" + (i + 1) + ".png");
	}
	localisedAssets = localisedAssets.concat(["images/session/lvl_up.png","images/session/no_cash.png","images/session/spin.png","images/session/spin_glow.png"]);
	manifest.push("images/menu/bg.jpg");
	manifest.push("images/menu/drops.png");
	manifest.push("images/menu/ground.jpg");
	manifest.push("images/menu/play_locked.png");
	manifest.push("images/menu/help.png");
	manifest.push("images/menu/sound.png");
	manifest.push("images/menu/right_arr.png");
	localisedAssets.push("images/menu/play_locked.png");
	var _g1 = 0, _g = co.doubleduck.DataLoader.getCasinosCount();
	while(_g1 < _g) {
		var i = _g1++;
		manifest.push("images/menu/play" + (i + 1) + ".png");
		manifest.push("images/menu/casino" + (i + 1) + ".png");
		manifest.push("images/menu/unlock" + (i + 1) + ".png");
		localisedAssets.push("images/menu/play" + (i + 1) + ".png");
	}
	manifest.push("images/menu/chips_bar1.png");
	manifest.push("images/menu/chips_bar2.png");
	manifest.push("images/menu/get_coins1.png");
	manifest.push("images/menu/get_coins2.png");
	manifest.push("images/menu/glow.png");
	manifest.push("images/menu/help_frame.png");
	manifest.push("images/menu/next.png");
	manifest.push("images/menu/gotit.png");
	var _g = 1;
	while(_g < 5) {
		var i = _g++;
		manifest.push("images/menu/help" + i + ".png");
		localisedAssets.push("images/menu/help" + i + ".png");
	}
	localisedAssets = localisedAssets.concat(["images/menu/chips_bar2.png","images/menu/get_coins1.png","images/menu/get_coins2.png","images/menu/gotit.png","images/menu/next.png"]);
	manifest.push("images/session/ball.png");
	manifest.push("images/session/return_button.png");
	manifest.push("images/session/lobby_button.png");
	manifest.push("images/session/win.png");
	manifest.push("images/session/spin.png");
	manifest.push("images/session/spin_glow.png");
	var _g1 = 0, _g = co.doubleduck.DataLoader.getCasinosCount();
	while(_g1 < _g) {
		var i = _g1++;
		manifest.push("images/session/casinos/" + (i + 1) + "/bet_table.png");
		manifest.push("images/session/casinos/" + (i + 1) + "/base.png");
		manifest.push("images/session/casinos/" + (i + 1) + "/nmbrs.png");
		manifest.push("images/session/casinos/" + (i + 1) + "/handles_shdw.png");
		manifest.push("images/session/casinos/" + (i + 1) + "/handles.png");
		manifest.push("images/session/casinos/" + (i + 1) + "/top.png");
		manifest.push("images/session/casinos/" + (i + 1) + "/chips_small.png");
		manifest.push("images/session/casinos/" + (i + 1) + "/chips_big.png");
		manifest.push("images/session/casinos/" + (i + 1) + "/bg.jpg");
	}
	var _g = 0;
	while(_g < 10) {
		var $int = _g++;
		manifest.push("images/session/wins/" + $int + ".png");
	}
	manifest.push("images/session/wins/comma.png");
	manifest.push("images/session/wins/win.png");
	manifest.push("images/session/wins/mega_win.png");
	localisedAssets = localisedAssets.concat(["images/session/wins/mega_win.png","images/session/wins/win.png"]);
	co.doubleduck.BaseAssets.setLocalizedAssets(localisedAssets);
	co.doubleduck.BaseAssets.finishLoading(manifest,sounds);
}
co.doubleduck.Assets.__super__ = co.doubleduck.BaseAssets;
co.doubleduck.Assets.prototype = $extend(co.doubleduck.BaseAssets.prototype,{
	__class__: co.doubleduck.Assets
});
co.doubleduck.BaseGame = $hxClasses["co.doubleduck.BaseGame"] = function(stage) {
	this._waitingToStart = false;
	this._orientError = null;
	this._prevWinSize = new createjs.Rectangle(0,0,1,1);
	if(co.doubleduck.BaseGame._wantLandscape) {
		co.doubleduck.BaseGame.MAX_HEIGHT = 320;
		co.doubleduck.BaseGame.MAX_WIDTH = 570;
	} else {
		co.doubleduck.BaseGame.MAX_HEIGHT = 570;
		co.doubleduck.BaseGame.MAX_WIDTH = 320;
	}
	if(co.doubleduck.BaseGame.DEBUG) co.doubleduck.BasePersistence.clearAll();
	var isGS3Stock = /Android 4.0.4/.test(navigator.userAgent);
	isGS3Stock = isGS3Stock && /GT-I9300/.test(navigator.userAgent);
	isGS3Stock = isGS3Stock && !/Chrome/.test(navigator.userAgent);
	if(isGS3Stock) {
		var loc = window.location.href;
		if(loc.lastIndexOf("index.html") != -1) loc = HxOverrides.substr(loc,0,loc.lastIndexOf("index.html"));
		loc += "error.html";
		window.location.href=loc;
		return;
	}
	co.doubleduck.Persistence.initGameData();
	co.doubleduck.BaseGame._stage = stage;
	co.doubleduck.BaseGame._stage.onTick = $bind(this,this.handleStageTick);
	co.doubleduck.BaseGame._viewport = new createjs.Rectangle(0,0,1,1);
	co.doubleduck.BaseGame.hammer = new Hammer(js.Lib.document.getElementById("stageCanvas"));
	viewporter.preventPageScroll = true;
	viewporter.change($bind(this,this.handleViewportChanged));
	if(viewporter.ACTIVE) {
		viewporter.preventPageScroll = true;
		viewporter.change($bind(this,this.handleViewportChanged));
		if(co.doubleduck.BaseGame._wantLandscape != viewporter.isLandscape()) {
			if(co.doubleduck.BaseGame._wantLandscape) co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.ORIENT_LAND_URI,$bind(this,this.waitForOrientation)); else co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.ORIENT_PORT_URI,$bind(this,this.waitForOrientation));
		} else co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOGO_URI,$bind(this,this.loadBarFill));
	} else co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOGO_URI,$bind(this,this.loadBarFill));
};
co.doubleduck.BaseGame.__name__ = ["co","doubleduck","BaseGame"];
co.doubleduck.BaseGame._stage = null;
co.doubleduck.BaseGame._wantLandscape = null;
co.doubleduck.BaseGame.MAX_HEIGHT = null;
co.doubleduck.BaseGame.MAX_WIDTH = null;
co.doubleduck.BaseGame.activeLocale = null;
co.doubleduck.BaseGame.availableLocales = null;
co.doubleduck.BaseGame.defaultLocale = null;
co.doubleduck.BaseGame.hammer = null;
co.doubleduck.BaseGame.getViewport = function() {
	return co.doubleduck.BaseGame._viewport;
}
co.doubleduck.BaseGame.getScreenSize = function() {
	if(co.doubleduck.BaseGame._wantLandscape) return new createjs.Rectangle(0,0,Math.floor(co.doubleduck.BaseGame._viewport.width / co.doubleduck.BaseGame._scale),co.doubleduck.BaseGame.MAX_HEIGHT); else return new createjs.Rectangle(0,0,co.doubleduck.BaseGame.MAX_WIDTH,Math.floor(co.doubleduck.BaseGame._viewport.height / co.doubleduck.BaseGame._scale));
}
co.doubleduck.BaseGame.getScale = function() {
	return co.doubleduck.BaseGame._scale;
}
co.doubleduck.BaseGame.getStage = function() {
	return co.doubleduck.BaseGame._stage;
}
co.doubleduck.BaseGame.prototype = {
	setScale: function() {
		var fixedVal = co.doubleduck.BaseGame._viewport.width;
		var varVal = co.doubleduck.BaseGame._viewport.height;
		var idealFixed = co.doubleduck.BaseGame.MAX_WIDTH;
		var idealVar = co.doubleduck.BaseGame.MAX_HEIGHT;
		if(co.doubleduck.BaseGame._wantLandscape) {
			fixedVal = co.doubleduck.BaseGame._viewport.height;
			varVal = co.doubleduck.BaseGame._viewport.width;
			idealFixed = co.doubleduck.BaseGame.MAX_HEIGHT;
			idealVar = co.doubleduck.BaseGame.MAX_WIDTH;
		}
		var regScale = varVal / idealVar;
		if(fixedVal >= varVal) co.doubleduck.BaseGame._scale = regScale; else if(idealFixed * regScale < fixedVal) co.doubleduck.BaseGame._scale = fixedVal / idealFixed; else co.doubleduck.BaseGame._scale = regScale;
	}
	,handleViewportChanged: function() {
		if(co.doubleduck.BaseGame._wantLandscape != viewporter.isLandscape()) {
			if(this._orientError == null) {
				var err = co.doubleduck.BaseGame.ORIENT_PORT_URI;
				if(co.doubleduck.BaseGame._wantLandscape) err = co.doubleduck.BaseGame.ORIENT_LAND_URI;
				this._orientError = co.doubleduck.BaseAssets.getImage(err);
				this._orientError.regX = this._orientError.image.width / 2;
				this._orientError.regY = this._orientError.image.height / 2;
				this._orientError.x = co.doubleduck.BaseGame._viewport.height / 2;
				this._orientError.y = co.doubleduck.BaseGame._viewport.width / 2;
				co.doubleduck.BaseGame._stage.addChildAt(this._orientError,co.doubleduck.BaseGame._stage.getNumChildren());
				co.doubleduck.BaseGame._stage.update();
			}
		} else if(this._orientError != null) {
			co.doubleduck.BaseGame._stage.removeChild(this._orientError);
			this._orientError = null;
			if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame._stage.update();
			if(this._waitingToStart) {
				this._waitingToStart = false;
				co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOGO_URI,$bind(this,this.loadBarFill));
			}
		}
	}
	,focused: function() {
		co.doubleduck.SoundManager.unmute();
	}
	,blured: function(e) {
		co.doubleduck.SoundManager.mute();
	}
	,handleResize: function(e) {
		var isFirefox = /Firefox/.test(navigator.userAgent);
		var isAndroid = /Android/.test(navigator.userAgent);
		var screenW = js.Lib.window.innerWidth;
		var screenH = js.Lib.window.innerHeight;
		co.doubleduck.BaseGame._stage.canvas.width = screenW;
		co.doubleduck.BaseGame._stage.canvas.height = screenH;
		var shouldResize = co.doubleduck.BaseGame._wantLandscape == viewporter.isLandscape() || !viewporter.ACTIVE;
		if(shouldResize) {
			if(isFirefox) {
				screenH = Math.floor(co.doubleduck.Main.getFFHeight());
				var ffEstimate = Math.ceil((js.Lib.window.screen.height - 110) * (screenW / js.Lib.window.screen.width));
				if(!isAndroid) ffEstimate = Math.ceil(js.Lib.window.screen.height * (screenW / js.Lib.window.screen.width));
				if(ffEstimate < screenH) screenH = Math.floor(ffEstimate);
			}
			var wrongSize = screenH < screenW;
			if(co.doubleduck.BaseGame._wantLandscape) wrongSize = screenH > screenW;
			if(!viewporter.ACTIVE || !wrongSize) {
				co.doubleduck.BaseGame._viewport.width = screenW;
				co.doubleduck.BaseGame._viewport.height = screenH;
				this.setScale();
			}
			if(this._orientError != null && isFirefox) this.handleViewportChanged();
		} else if(isFirefox) this.handleViewportChanged();
		if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame._stage.update();
	}
	,handleBackToMenu: function() {
		this._session.destroy();
		co.doubleduck.BaseGame._stage.removeChild(this._session);
		this._session = null;
		this._menu = new co.doubleduck.Menu();
		co.doubleduck.BaseGame._stage.addChildAt(this._menu,0);
		this._menu.onPlayClick = $bind(this,this.handlePlayClick);
	}
	,handleRestart: function(properties) {
		this._session.destroy();
		co.doubleduck.BaseGame._stage.removeChild(this._session);
		this._session = null;
		this.startSession(properties);
	}
	,handleSessionEnd: function() {
	}
	,handlePlayClick: function(properties) {
		co.doubleduck.BaseGame._stage.removeChild(this._menu);
		this.startSession(properties);
		this._menu.destroy();
		this._menu = null;
	}
	,startSession: function(properties) {
		this._session = new co.doubleduck.Session(properties);
		this._session.onBackToMenu = $bind(this,this.handleBackToMenu);
		this._session.onRestart = $bind(this,this.handleRestart);
		this._session.onSessionEnd = $bind(this,this.handleSessionEnd);
		co.doubleduck.BaseGame._stage.addChild(this._session);
	}
	,showMenu: function() {
		this._menu = new co.doubleduck.Menu();
		co.doubleduck.BaseGame._stage.addChildAt(this._menu,0);
		this._menu.onPlayClick = $bind(this,this.handlePlayClick);
	}
	,alphaFade: function(fadeElement) {
		if(fadeElement != null && js.Boot.__instanceof(fadeElement,createjs.Bitmap)) this._fadedText = fadeElement; else if(this._fadedText == null) return;
		if(this._fadedText.alpha == 0) createjs.Tween.get(this._fadedText).to({ alpha : 1},750).call($bind(this,this.alphaFade)); else if(this._fadedText.alpha == 1) createjs.Tween.get(this._fadedText).to({ alpha : 0},1500).call($bind(this,this.alphaFade));
	}
	,showGameSplash: function() {
	}
	,splashEnded: function() {
		js.Lib.document.body.bgColor = "#000000";
		co.doubleduck.BaseGame._stage.removeChild(this._splash);
		this._splash = null;
		js.Lib.window.onresize = $bind(this,this.handleResize);
		this.handleResize(null);
		this.showGameSplash();
	}
	,handleDoneLoading: function() {
		createjs.Tween.get(this._splash).wait(200).to({ alpha : 0},800).call($bind(this,this.splashEnded));
		co.doubleduck.BaseGame._stage.removeChild(this._loadingBar);
		co.doubleduck.BaseGame._stage.removeChild(this._loadingStroke);
	}
	,updateLoading: function() {
		if(co.doubleduck.BaseAssets.loaded != 1) {
			this._loadingBar.visible = true;
			var percent = co.doubleduck.BaseAssets.loaded;
			var barMask = new createjs.Shape();
			barMask.graphics.beginFill("#00000000");
			barMask.graphics.drawRect(this._loadingBar.x - this._loadingBar.image.width / 2,this._loadingBar.y,this._loadingBar.image.width * percent | 0,this._loadingBar.image.height);
			barMask.graphics.endFill();
			this._loadingBar.mask = barMask;
			co.doubleduck.Utils.waitAndCall(this,10,$bind(this,this.updateLoading));
		}
	}
	,exitFocus: function() {
		var hidden = document.mozHidden;
		if(hidden) co.doubleduck.SoundManager.mute(false); else if(!co.doubleduck.SoundManager.getPersistedMute()) co.doubleduck.SoundManager.unmute(false);
	}
	,showSplash: function() {
		if(viewporter.ACTIVE) js.Lib.document.body.bgColor = "#00A99D"; else js.Lib.document.body.bgColor = "#D94D00";
		this._splash = co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.LOGO_URI);
		this._splash.regX = this._splash.image.width / 2;
		this._splash.x = js.Lib.window.innerWidth / 2;
		if(co.doubleduck.BaseGame._wantLandscape) this._splash.y = 20; else this._splash.y = 90;
		co.doubleduck.BaseGame._stage.addChild(this._splash);
		this._loadingStroke = co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.LOAD_STROKE_URI);
		this._loadingStroke.regX = this._loadingStroke.image.width / 2;
		co.doubleduck.BaseGame._stage.addChildAt(this._loadingStroke,0);
		this._loadingBar = co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.LOAD_FILL_URI);
		this._loadingBar.regX = this._loadingBar.image.width / 2;
		co.doubleduck.BaseGame._stage.addChildAt(this._loadingBar,1);
		this._loadingBar.x = js.Lib.window.innerWidth / 2;
		this._loadingBar.y = this._splash.y + 192;
		this._loadingStroke.x = this._loadingBar.x;
		this._loadingStroke.y = this._loadingBar.y;
		this._loadingBar.visible = false;
		this.updateLoading();
		co.doubleduck.BaseGame._stage.canvas.width = js.Lib.window.innerWidth;
		co.doubleduck.BaseGame._stage.canvas.height = js.Lib.window.innerHeight;
		co.doubleduck.BaseAssets.onLoadAll = $bind(this,this.handleDoneLoading);
		co.doubleduck.Assets.loadAll();
	}
	,loadLocale: function() {
		if(co.doubleduck.BaseGame.isLocalized) {
			var lang = navigator.language;
			lang = HxOverrides.substr(lang.toLowerCase(),0,2);
			if(co.doubleduck.BaseGame.availableLocales != null && co.doubleduck.BaseGame.availableLocales.length > 0) {
				if(Lambda.indexOf(co.doubleduck.BaseGame.availableLocales,lang) != -1) {
					co.doubleduck.BaseGame.activeLocale = lang;
					this.showSplash();
					return;
				} else {
					co.doubleduck.BaseGame.activeLocale = co.doubleduck.BaseGame.defaultLocale;
					this.showSplash();
					return;
				}
			} else {
				co.doubleduck.BaseGame.activeLocale = co.doubleduck.BaseGame.defaultLocale;
				if(co.doubleduck.BaseGame.defaultLocale == null) throw "DDException: default locale not set";
			}
		}
		this.showSplash();
	}
	,waitForOrientation: function() {
		this._waitingToStart = true;
		if(this._orientError == null) {
			this._orientError = this.getErrorImage();
			this._orientError.regX = this._orientError.image.width / 2;
			this._orientError.regY = this._orientError.image.height / 2;
			this._orientError.x = js.Lib.window.innerWidth / 2;
			this._orientError.y = js.Lib.window.innerHeight / 2;
			co.doubleduck.BaseGame._stage.addChildAt(this._orientError,co.doubleduck.BaseGame._stage.getNumChildren());
		}
	}
	,getErrorImage: function() {
		if(co.doubleduck.BaseGame._wantLandscape) return co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.ORIENT_LAND_URI); else return co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.ORIENT_PORT_URI);
	}
	,loadBarStroke: function() {
		co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOAD_STROKE_URI,$bind(this,this.loadLocale));
	}
	,loadBarFill: function() {
		co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOAD_FILL_URI,$bind(this,this.loadBarStroke));
	}
	,handleStageTick: function() {
		if(js.Lib.window.innerWidth != this._prevWinSize.width || js.Lib.window.innerHeight != this._prevWinSize.height) {
			this._prevWinSize.width = js.Lib.window.innerWidth;
			this._prevWinSize.height = js.Lib.window.innerHeight;
			this.handleResize(null);
		}
	}
	,_prevWinSize: null
	,_fadedText: null
	,_loadingStroke: null
	,_loadingBar: null
	,_waitingToStart: null
	,_orientError: null
	,_session: null
	,_menu: null
	,_splash: null
	,__class__: co.doubleduck.BaseGame
}
co.doubleduck.BaseMenu = $hxClasses["co.doubleduck.BaseMenu"] = function() {
	createjs.Container.call(this);
};
co.doubleduck.BaseMenu.__name__ = ["co","doubleduck","BaseMenu"];
co.doubleduck.BaseMenu.__super__ = createjs.Container;
co.doubleduck.BaseMenu.prototype = $extend(createjs.Container.prototype,{
	destroy: function() {
		this.onPlayClick = null;
	}
	,onPlayClick: null
	,__class__: co.doubleduck.BaseMenu
});
co.doubleduck.BasePersistence = $hxClasses["co.doubleduck.BasePersistence"] = function() { }
co.doubleduck.BasePersistence.__name__ = ["co","doubleduck","BasePersistence"];
co.doubleduck.BasePersistence.localStorageSupported = function() {
	var result = null;
	try {
		localStorage.setItem("test","test");
		localStorage.removeItem("test");
		result = true;
	} catch( e ) {
		result = false;
	}
	return result;
}
co.doubleduck.BasePersistence.getValue = function(key) {
	if(!co.doubleduck.BasePersistence.available) return "0";
	var val = localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key];
	return val;
}
co.doubleduck.BasePersistence.setValue = function(key,value) {
	if(!co.doubleduck.BasePersistence.available) return;
	localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key] = value;
}
co.doubleduck.BasePersistence.clearAll = function() {
	if(!co.doubleduck.BasePersistence.available) return;
	localStorage.clear();
}
co.doubleduck.BasePersistence.initVar = function(initedVar,defaultVal) {
	if(defaultVal == null) defaultVal = "0";
	var value = co.doubleduck.BasePersistence.getValue(initedVar);
	if(value == null) try {
		co.doubleduck.BasePersistence.setValue(initedVar,defaultVal);
	} catch( e ) {
		co.doubleduck.BasePersistence.available = false;
	}
}
co.doubleduck.BasePersistence.getDynamicValue = function(key) {
	if(!co.doubleduck.BasePersistence.available) return { };
	var val = localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key];
	return val;
}
co.doubleduck.BasePersistence.setDynamicValue = function(key,value) {
	if(!co.doubleduck.BasePersistence.available) return;
	localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key] = value;
}
co.doubleduck.BasePersistence.initDynamicVar = function(initedVar,defaultVal) {
	var value = co.doubleduck.BasePersistence.getDynamicValue(initedVar);
	if(value == null) try {
		co.doubleduck.BasePersistence.setDynamicValue(initedVar,defaultVal);
	} catch( e ) {
		co.doubleduck.BasePersistence.available = false;
	}
}
co.doubleduck.BasePersistence.printAll = function() {
	var ls = localStorage;
	var localStorageLength = ls.length;
	var _g = 0;
	while(_g < localStorageLength) {
		var entry = _g++;
		null;
	}
}
co.doubleduck.BaseSession = $hxClasses["co.doubleduck.BaseSession"] = function() {
	createjs.Container.call(this);
};
co.doubleduck.BaseSession.__name__ = ["co","doubleduck","BaseSession"];
co.doubleduck.BaseSession.__super__ = createjs.Container;
co.doubleduck.BaseSession.prototype = $extend(createjs.Container.prototype,{
	destroy: function() {
		createjs.Ticker.removeListener(this);
		this.onRestart = null;
		this.onBackToMenu = null;
		this.onSessionEnd = null;
		this.onNextLevel = null;
	}
	,sessionEnded: function() {
		if(this.onSessionEnd != null) {
			createjs.Ticker.setPaused(false);
			this.onSessionEnd();
		}
	}
	,handleReplayClick: function(properties) {
		if(this.onRestart != null) {
			createjs.Ticker.setPaused(false);
			this.onRestart(properties);
		}
	}
	,handleMenuClick: function() {
		if(this.onBackToMenu != null) {
			createjs.Ticker.setPaused(false);
			this.onBackToMenu();
		}
	}
	,_replayBtn: null
	,_menuBtn: null
	,onNextLevel: null
	,onBackToMenu: null
	,onSessionEnd: null
	,onRestart: null
	,__class__: co.doubleduck.BaseSession
});
co.doubleduck.BetValue = $hxClasses["co.doubleduck.BetValue"] = { __ename__ : ["co","doubleduck","BetValue"], __constructs__ : ["ZERO","ONE","TWO","THREE","FOUR","FIVE","SIX","SEVEN","EIGHT","NINE","TEN","ELEVEN","TWELVE","THIRTEEN","FOURTEEN","FIFTEEN","SIXTEEN","SEVENTEEN","EIGHTEEN","NINETEEN","TWENTY","TWENTY_ONE","TWENTY_TWO","TWENTY_THREE","TWENTY_FOUR","TWENTY_FIVE","TWENTY_SIX","TWENTY_SEVEN","TWENTY_EIGHT","TWENTY_NINE","THIRTY","THIRTY_ONE","THIRTY_TWO","THIRTY_THREE","THIRTY_FOUR","THIRTY_FIVE","THIRTY_SIX","ONE_TO_EIGHTEEN","NINETEEN_TO_THIRTY_SIX","EVEN","ODD","FIRST_TWELVE","SECOND_TWELVE","THIRD_TWELVE","FIRST_COL","SECOND_COL","THIRD_COL","RED","BLACK"] }
co.doubleduck.BetValue.ZERO = ["ZERO",0];
co.doubleduck.BetValue.ZERO.toString = $estr;
co.doubleduck.BetValue.ZERO.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.ONE = ["ONE",1];
co.doubleduck.BetValue.ONE.toString = $estr;
co.doubleduck.BetValue.ONE.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.TWO = ["TWO",2];
co.doubleduck.BetValue.TWO.toString = $estr;
co.doubleduck.BetValue.TWO.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.THREE = ["THREE",3];
co.doubleduck.BetValue.THREE.toString = $estr;
co.doubleduck.BetValue.THREE.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.FOUR = ["FOUR",4];
co.doubleduck.BetValue.FOUR.toString = $estr;
co.doubleduck.BetValue.FOUR.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.FIVE = ["FIVE",5];
co.doubleduck.BetValue.FIVE.toString = $estr;
co.doubleduck.BetValue.FIVE.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.SIX = ["SIX",6];
co.doubleduck.BetValue.SIX.toString = $estr;
co.doubleduck.BetValue.SIX.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.SEVEN = ["SEVEN",7];
co.doubleduck.BetValue.SEVEN.toString = $estr;
co.doubleduck.BetValue.SEVEN.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.EIGHT = ["EIGHT",8];
co.doubleduck.BetValue.EIGHT.toString = $estr;
co.doubleduck.BetValue.EIGHT.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.NINE = ["NINE",9];
co.doubleduck.BetValue.NINE.toString = $estr;
co.doubleduck.BetValue.NINE.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.TEN = ["TEN",10];
co.doubleduck.BetValue.TEN.toString = $estr;
co.doubleduck.BetValue.TEN.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.ELEVEN = ["ELEVEN",11];
co.doubleduck.BetValue.ELEVEN.toString = $estr;
co.doubleduck.BetValue.ELEVEN.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.TWELVE = ["TWELVE",12];
co.doubleduck.BetValue.TWELVE.toString = $estr;
co.doubleduck.BetValue.TWELVE.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.THIRTEEN = ["THIRTEEN",13];
co.doubleduck.BetValue.THIRTEEN.toString = $estr;
co.doubleduck.BetValue.THIRTEEN.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.FOURTEEN = ["FOURTEEN",14];
co.doubleduck.BetValue.FOURTEEN.toString = $estr;
co.doubleduck.BetValue.FOURTEEN.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.FIFTEEN = ["FIFTEEN",15];
co.doubleduck.BetValue.FIFTEEN.toString = $estr;
co.doubleduck.BetValue.FIFTEEN.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.SIXTEEN = ["SIXTEEN",16];
co.doubleduck.BetValue.SIXTEEN.toString = $estr;
co.doubleduck.BetValue.SIXTEEN.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.SEVENTEEN = ["SEVENTEEN",17];
co.doubleduck.BetValue.SEVENTEEN.toString = $estr;
co.doubleduck.BetValue.SEVENTEEN.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.EIGHTEEN = ["EIGHTEEN",18];
co.doubleduck.BetValue.EIGHTEEN.toString = $estr;
co.doubleduck.BetValue.EIGHTEEN.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.NINETEEN = ["NINETEEN",19];
co.doubleduck.BetValue.NINETEEN.toString = $estr;
co.doubleduck.BetValue.NINETEEN.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.TWENTY = ["TWENTY",20];
co.doubleduck.BetValue.TWENTY.toString = $estr;
co.doubleduck.BetValue.TWENTY.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.TWENTY_ONE = ["TWENTY_ONE",21];
co.doubleduck.BetValue.TWENTY_ONE.toString = $estr;
co.doubleduck.BetValue.TWENTY_ONE.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.TWENTY_TWO = ["TWENTY_TWO",22];
co.doubleduck.BetValue.TWENTY_TWO.toString = $estr;
co.doubleduck.BetValue.TWENTY_TWO.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.TWENTY_THREE = ["TWENTY_THREE",23];
co.doubleduck.BetValue.TWENTY_THREE.toString = $estr;
co.doubleduck.BetValue.TWENTY_THREE.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.TWENTY_FOUR = ["TWENTY_FOUR",24];
co.doubleduck.BetValue.TWENTY_FOUR.toString = $estr;
co.doubleduck.BetValue.TWENTY_FOUR.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.TWENTY_FIVE = ["TWENTY_FIVE",25];
co.doubleduck.BetValue.TWENTY_FIVE.toString = $estr;
co.doubleduck.BetValue.TWENTY_FIVE.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.TWENTY_SIX = ["TWENTY_SIX",26];
co.doubleduck.BetValue.TWENTY_SIX.toString = $estr;
co.doubleduck.BetValue.TWENTY_SIX.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.TWENTY_SEVEN = ["TWENTY_SEVEN",27];
co.doubleduck.BetValue.TWENTY_SEVEN.toString = $estr;
co.doubleduck.BetValue.TWENTY_SEVEN.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.TWENTY_EIGHT = ["TWENTY_EIGHT",28];
co.doubleduck.BetValue.TWENTY_EIGHT.toString = $estr;
co.doubleduck.BetValue.TWENTY_EIGHT.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.TWENTY_NINE = ["TWENTY_NINE",29];
co.doubleduck.BetValue.TWENTY_NINE.toString = $estr;
co.doubleduck.BetValue.TWENTY_NINE.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.THIRTY = ["THIRTY",30];
co.doubleduck.BetValue.THIRTY.toString = $estr;
co.doubleduck.BetValue.THIRTY.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.THIRTY_ONE = ["THIRTY_ONE",31];
co.doubleduck.BetValue.THIRTY_ONE.toString = $estr;
co.doubleduck.BetValue.THIRTY_ONE.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.THIRTY_TWO = ["THIRTY_TWO",32];
co.doubleduck.BetValue.THIRTY_TWO.toString = $estr;
co.doubleduck.BetValue.THIRTY_TWO.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.THIRTY_THREE = ["THIRTY_THREE",33];
co.doubleduck.BetValue.THIRTY_THREE.toString = $estr;
co.doubleduck.BetValue.THIRTY_THREE.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.THIRTY_FOUR = ["THIRTY_FOUR",34];
co.doubleduck.BetValue.THIRTY_FOUR.toString = $estr;
co.doubleduck.BetValue.THIRTY_FOUR.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.THIRTY_FIVE = ["THIRTY_FIVE",35];
co.doubleduck.BetValue.THIRTY_FIVE.toString = $estr;
co.doubleduck.BetValue.THIRTY_FIVE.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.THIRTY_SIX = ["THIRTY_SIX",36];
co.doubleduck.BetValue.THIRTY_SIX.toString = $estr;
co.doubleduck.BetValue.THIRTY_SIX.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.ONE_TO_EIGHTEEN = ["ONE_TO_EIGHTEEN",37];
co.doubleduck.BetValue.ONE_TO_EIGHTEEN.toString = $estr;
co.doubleduck.BetValue.ONE_TO_EIGHTEEN.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.NINETEEN_TO_THIRTY_SIX = ["NINETEEN_TO_THIRTY_SIX",38];
co.doubleduck.BetValue.NINETEEN_TO_THIRTY_SIX.toString = $estr;
co.doubleduck.BetValue.NINETEEN_TO_THIRTY_SIX.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.EVEN = ["EVEN",39];
co.doubleduck.BetValue.EVEN.toString = $estr;
co.doubleduck.BetValue.EVEN.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.ODD = ["ODD",40];
co.doubleduck.BetValue.ODD.toString = $estr;
co.doubleduck.BetValue.ODD.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.FIRST_TWELVE = ["FIRST_TWELVE",41];
co.doubleduck.BetValue.FIRST_TWELVE.toString = $estr;
co.doubleduck.BetValue.FIRST_TWELVE.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.SECOND_TWELVE = ["SECOND_TWELVE",42];
co.doubleduck.BetValue.SECOND_TWELVE.toString = $estr;
co.doubleduck.BetValue.SECOND_TWELVE.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.THIRD_TWELVE = ["THIRD_TWELVE",43];
co.doubleduck.BetValue.THIRD_TWELVE.toString = $estr;
co.doubleduck.BetValue.THIRD_TWELVE.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.FIRST_COL = ["FIRST_COL",44];
co.doubleduck.BetValue.FIRST_COL.toString = $estr;
co.doubleduck.BetValue.FIRST_COL.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.SECOND_COL = ["SECOND_COL",45];
co.doubleduck.BetValue.SECOND_COL.toString = $estr;
co.doubleduck.BetValue.SECOND_COL.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.THIRD_COL = ["THIRD_COL",46];
co.doubleduck.BetValue.THIRD_COL.toString = $estr;
co.doubleduck.BetValue.THIRD_COL.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.RED = ["RED",47];
co.doubleduck.BetValue.RED.toString = $estr;
co.doubleduck.BetValue.RED.__enum__ = co.doubleduck.BetValue;
co.doubleduck.BetValue.BLACK = ["BLACK",48];
co.doubleduck.BetValue.BLACK.toString = $estr;
co.doubleduck.BetValue.BLACK.__enum__ = co.doubleduck.BetValue;
co.doubleduck.Bet = $hxClasses["co.doubleduck.Bet"] = function(val) {
	createjs.Shape.call(this);
	this._ratio = co.doubleduck.Bet.getRatioByVal(val);
	this._betAmount = 0;
	this.populateNumArr(val);
};
co.doubleduck.Bet.__name__ = ["co","doubleduck","Bet"];
co.doubleduck.Bet.intToBetValue = function($int) {
	if($int > 36 || $int < 0) return null;
	return co.doubleduck.Bet.numRef[$int];
}
co.doubleduck.Bet.betValueToInt = function(val) {
	return Lambda.indexOf(co.doubleduck.Bet.numRef,val);
}
co.doubleduck.Bet.getCorrespondingColor = function(num) {
	var colorArr = [null];
	var isRed = true;
	var _g1 = 1, _g = co.doubleduck.Session.numOrder.length;
	while(_g1 < _g) {
		var i = _g1++;
		if(isRed) colorArr.push(co.doubleduck.BetValue.RED); else colorArr.push(co.doubleduck.BetValue.BLACK);
		isRed = !isRed;
	}
	return colorArr[Lambda.indexOf(co.doubleduck.Session.numOrder,num)];
}
co.doubleduck.Bet.getRatioByVal = function(val) {
	var dozenRatioBets = [co.doubleduck.BetValue.FIRST_COL,co.doubleduck.BetValue.SECOND_COL,co.doubleduck.BetValue.SECOND_COL,co.doubleduck.BetValue.THIRD_COL,co.doubleduck.BetValue.FIRST_TWELVE,co.doubleduck.BetValue.SECOND_TWELVE,co.doubleduck.BetValue.THIRD_TWELVE];
	if(Lambda.indexOf(co.doubleduck.Bet.numRef,val) != -1) return 36; else if(Lambda.indexOf(dozenRatioBets,val) != -1) return 3; else return 2;
}
co.doubleduck.Bet.getBetByNumber = function(num) {
	return new co.doubleduck.Bet(co.doubleduck.Bet.intToBetValue(num));
}
co.doubleduck.Bet.__super__ = createjs.Shape;
co.doubleduck.Bet.prototype = $extend(createjs.Shape.prototype,{
	populateNumArr: function(val) {
		this._valArr = new Array();
		if(val == co.doubleduck.BetValue.EVEN) {
			var _g1 = 1, _g = co.doubleduck.Bet.numRef.length;
			while(_g1 < _g) {
				var i = _g1++;
				if(i % 2 == 0) this._valArr.push(co.doubleduck.Bet.intToBetValue(i));
			}
		} else if(val == co.doubleduck.BetValue.ODD) {
			var _g1 = 1, _g = co.doubleduck.Bet.numRef.length;
			while(_g1 < _g) {
				var i = _g1++;
				if(i % 2 != 0) this._valArr.push(co.doubleduck.Bet.intToBetValue(i));
			}
		} else if(val == co.doubleduck.BetValue.ONE_TO_EIGHTEEN) {
			var _g = 1;
			while(_g < 19) {
				var i = _g++;
				this._valArr.push(co.doubleduck.Bet.intToBetValue(i));
			}
		} else if(val == co.doubleduck.BetValue.NINETEEN_TO_THIRTY_SIX) {
			var _g = 19;
			while(_g < 37) {
				var i = _g++;
				this._valArr.push(co.doubleduck.Bet.intToBetValue(i));
			}
		} else if(val == co.doubleduck.BetValue.FIRST_TWELVE) {
			var _g = 1;
			while(_g < 13) {
				var i = _g++;
				this._valArr.push(co.doubleduck.Bet.intToBetValue(i));
			}
		} else if(val == co.doubleduck.BetValue.SECOND_TWELVE) {
			var _g = 13;
			while(_g < 25) {
				var i = _g++;
				this._valArr.push(co.doubleduck.Bet.intToBetValue(i));
			}
		} else if(val == co.doubleduck.BetValue.THIRD_TWELVE) {
			var _g = 25;
			while(_g < 37) {
				var i = _g++;
				this._valArr.push(co.doubleduck.Bet.intToBetValue(i));
			}
		} else if(val == co.doubleduck.BetValue.FIRST_COL) {
			var count = 1;
			var _g1 = 1, _g = co.doubleduck.Bet.numRef.length;
			while(_g1 < _g) {
				var i = _g1++;
				if(count == 1) this._valArr.push(co.doubleduck.Bet.intToBetValue(i));
				count++;
				if(count > 3) count = 1;
			}
		} else if(val == co.doubleduck.BetValue.SECOND_COL) {
			var count = 1;
			var _g1 = 1, _g = co.doubleduck.Bet.numRef.length;
			while(_g1 < _g) {
				var i = _g1++;
				if(count == 2) this._valArr.push(co.doubleduck.Bet.intToBetValue(i));
				count++;
				if(count > 3) count = 1;
			}
		} else if(val == co.doubleduck.BetValue.THIRD_COL) {
			var count = 1;
			var _g1 = 1, _g = co.doubleduck.Bet.numRef.length;
			while(_g1 < _g) {
				var i = _g1++;
				if(count == 3) this._valArr.push(co.doubleduck.Bet.intToBetValue(i));
				count++;
				if(count > 3) count = 1;
			}
		} else if(val == co.doubleduck.BetValue.BLACK) {
			var _g1 = 1, _g = co.doubleduck.Bet.numRef.length;
			while(_g1 < _g) {
				var i = _g1++;
				if(co.doubleduck.Bet.getCorrespondingColor(i) == co.doubleduck.BetValue.BLACK) this._valArr.push(co.doubleduck.Bet.intToBetValue(i));
			}
		} else if(val == co.doubleduck.BetValue.RED) {
			var _g1 = 1, _g = co.doubleduck.Bet.numRef.length;
			while(_g1 < _g) {
				var i = _g1++;
				if(co.doubleduck.Bet.getCorrespondingColor(i) == co.doubleduck.BetValue.RED) this._valArr.push(co.doubleduck.Bet.intToBetValue(i));
			}
		} else this._valArr.push(val);
	}
	,payOff: function() {
		return this._betAmount * this._ratio;
	}
	,clearBet: function() {
		this._betAmount = 0;
	}
	,placeBet: function(amount) {
		this._betAmount = amount;
	}
	,matches: function(num) {
		if(Lambda.indexOf(this._valArr,co.doubleduck.Bet.intToBetValue(num)) != -1) return true;
		return false;
	}
	,getBetAmount: function() {
		return this._betAmount;
	}
	,getValue: function() {
		return this._valArr;
	}
	,getRatio: function() {
		return this._ratio;
	}
	,getWidth: function() {
		return this._width;
	}
	,getHeight: function() {
		return this._height;
	}
	,handleClick: function() {
		if(this.onBetClick != null) this.onBetClick(this);
	}
	,drawInvisibleButton: function(width,height) {
		this._height = height;
		this._width = width;
		this.graphics.beginFill("#FFFFFF");
		this.graphics.drawRect(0,0,width,height);
		this.graphics.endFill();
		this.alpha = 0.01;
		this.onClick = $bind(this,this.handleClick);
	}
	,onBetClick: null
	,_height: null
	,_width: null
	,_betAmount: null
	,_valArr: null
	,_ratio: null
	,__class__: co.doubleduck.Bet
});
co.doubleduck.BetTable = $hxClasses["co.doubleduck.BetTable"] = function(casinoId) {
	createjs.Container.call(this);
	this._bets = [];
	this._table = co.doubleduck.BaseAssets.getImage("images/session/casinos/" + casinoId + "/bet_table.png");
	this._table.x = 0;
	this._table.y = 0;
	this.addChild(this._table);
	this.regY = this._table.image.height;
	this.createButtons();
};
co.doubleduck.BetTable.__name__ = ["co","doubleduck","BetTable"];
co.doubleduck.BetTable.__super__ = createjs.Container;
co.doubleduck.BetTable.prototype = $extend(createjs.Container.prototype,{
	handleBetClick: function(target) {
		if(this.onTableClick != null) this.onTableClick(target);
	}
	,createButtons: function() {
		var baseHeight = this._table.image.height / 14;
		var baseWidth = this._table.image.width / 5;
		var singleCount = 0;
		var specialCount = 0;
		var orderSpecialBets = [co.doubleduck.BetValue.ONE_TO_EIGHTEEN,co.doubleduck.BetValue.FIRST_TWELVE,co.doubleduck.BetValue.EVEN,co.doubleduck.BetValue.RED,co.doubleduck.BetValue.SECOND_TWELVE,co.doubleduck.BetValue.BLACK,co.doubleduck.BetValue.ODD,co.doubleduck.BetValue.THIRD_TWELVE,co.doubleduck.BetValue.NINETEEN_TO_THIRTY_SIX,co.doubleduck.BetValue.FIRST_COL,co.doubleduck.BetValue.SECOND_COL,co.doubleduck.BetValue.THIRD_COL];
		var _g1 = 0, _g = co.doubleduck.BetTable.tableLayout.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(co.doubleduck.BetTable.tableLayout[i][0] != 0) {
				var newBet;
				if(co.doubleduck.BetTable.tableLayout[i][0] == 1 && co.doubleduck.BetTable.tableLayout[i][1] == 1 && singleCount <= 36) {
					newBet = co.doubleduck.Bet.getBetByNumber(singleCount);
					singleCount++;
				} else {
					newBet = new co.doubleduck.Bet(orderSpecialBets[specialCount]);
					specialCount++;
					newBet.placeBet(specialCount);
				}
				newBet.drawInvisibleButton(baseWidth * co.doubleduck.BetTable.tableLayout[i][0],baseHeight * co.doubleduck.BetTable.tableLayout[i][1]);
				this.addChild(newBet);
				newBet.x = i % 5 * baseWidth;
				newBet.y = Math.floor(i / 5) * baseHeight;
				this._bets.push(newBet);
				newBet.onBetClick = $bind(this,this.handleBetClick);
			}
		}
	}
	,clearBets: function() {
		var _g = 0, _g1 = this._bets;
		while(_g < _g1.length) {
			var bet = _g1[_g];
			++_g;
			bet.clearBet();
		}
	}
	,_bets: null
	,_table: null
	,onTableClick: null
	,__class__: co.doubleduck.BetTable
});
co.doubleduck.LabeledContainer = $hxClasses["co.doubleduck.LabeledContainer"] = function(bmp) {
	createjs.Container.call(this);
	this._bitmap = bmp;
	if(this._bitmap != null) {
		if(js.Boot.__instanceof(this._bitmap,createjs.Bitmap)) {
			this._bmp = this._bitmap;
			this.image = this._bmp.image;
		} else if(js.Boot.__instanceof(this._bitmap,createjs.BitmapAnimation)) {
			this.anim = this._bitmap;
			this.image = { width : this.anim.spriteSheet._frameWidth, height : this.anim.spriteSheet._frameHeight};
		}
	}
};
co.doubleduck.LabeledContainer.__name__ = ["co","doubleduck","LabeledContainer"];
co.doubleduck.LabeledContainer.__super__ = createjs.Container;
co.doubleduck.LabeledContainer.prototype = $extend(createjs.Container.prototype,{
	getLabel: function() {
		return this._label;
	}
	,addBitmap: function() {
		this.addChild(this._bitmap);
	}
	,addCenteredBitmap: function() {
		this._bitmap.regX = this.image.width / 2;
		this._bitmap.regY = this.image.height / 2;
		this._bitmap.x = this.image.width / 2;
		this._bitmap.y = this.image.height / 2;
		this.addChild(this._bitmap);
	}
	,addBitmapLabel: function(label,fontType,padding,centered) {
		if(centered == null) centered = true;
		if(padding == null) padding = 0;
		if(fontType == null) fontType = "";
		if(this._bitmapText != null) this.removeChild(this._bitmapText);
		var fontHelper = new co.doubleduck.FontHelper(fontType);
		this._bitmapText = fontHelper.getNumber(Std.parseInt(label),1,true,null,padding,centered);
		if(this.image != null) {
			this._bitmapText.x = this.image.width / 2;
			this._bitmapText.y = this.image.height / 2;
		}
		this._label = label;
		this.addChild(this._bitmapText);
	}
	,scaleBitmapFont: function(scale) {
		this._bitmapText.scaleX = this._bitmapText.scaleY = scale;
	}
	,shiftLabel: function(shiftX,shiftY) {
		this._bitmapText.x *= shiftX;
		this._bitmapText.y *= shiftY;
	}
	,setBitmapLabelY: function(ly) {
		this._bitmapText.y = ly;
	}
	,setBitmapLabelX: function(lx) {
		this._bitmapText.x = lx;
	}
	,getBitmapLabelWidth: function() {
		var maxWidth = 0;
		var _g1 = 0, _g = this._bitmapText.getNumChildren();
		while(_g1 < _g) {
			var digit = _g1++;
			var currentDigit = js.Boot.__cast(this._bitmapText.getChildAt(digit) , createjs.Bitmap);
			var endsAt = currentDigit.x + currentDigit.image.width;
			if(endsAt > maxWidth) maxWidth = endsAt;
		}
		return maxWidth;
	}
	,setLabelY: function(ly) {
		this._text.y = ly;
	}
	,setLabelX: function(lx) {
		this._text.x = lx;
	}
	,addLabel: function(label,color) {
		if(color == null) color = "#000000";
		if(this._text != null) this.removeChild(this._text);
		this._label = label;
		this._text = new createjs.Text(label,"bold 22px Arial",color);
		this._text.regY = this._text.getMeasuredHeight() / 2;
		this._text.textAlign = "center";
		if(this._bitmap != null) {
			this._text.x = this._bitmap.x;
			this._text.y = this._bitmap.y;
		}
		this.addChild(this._text);
	}
	,changeText: function(txt) {
	}
	,_bitmapText: null
	,_text: null
	,_bmp: null
	,_bitmap: null
	,_label: null
	,anim: null
	,image: null
	,__class__: co.doubleduck.LabeledContainer
});
co.doubleduck.Button = $hxClasses["co.doubleduck.Button"] = function(bmp,pauseAffected,clickType,clickSound) {
	if(clickType == null) clickType = 2;
	if(pauseAffected == null) pauseAffected = true;
	this._lastClickTime = 0;
	co.doubleduck.LabeledContainer.call(this,bmp);
	if(clickSound == null && co.doubleduck.Button._defaultSound != null) this._clickSound = co.doubleduck.Button._defaultSound; else this._clickSound = clickSound;
	this._bitmap.mouseEnabled = true;
	this._clickType = clickType;
	this._pauseAffected = pauseAffected;
	if(clickType == co.doubleduck.Button.CLICK_TYPE_TOGGLE) {
		var initObject = { };
		var size = this.image.width / 2;
		initObject.images = [this.image];
		initObject.frames = { width : size, height : this.image.height, regX : size / 2, regY : this.image.height / 2};
		this._states = new createjs.BitmapAnimation(new createjs.SpriteSheet(initObject));
		this._states.gotoAndStop(0);
		this.onClick = $bind(this,this.handleToggle);
		this.addChild(this._states);
	} else this.addCenteredBitmap();
	this.onPress = $bind(this,this.handlePress);
};
co.doubleduck.Button.__name__ = ["co","doubleduck","Button"];
co.doubleduck.Button.setDefaultSound = function(sound) {
	co.doubleduck.Button._defaultSound = sound;
}
co.doubleduck.Button.__super__ = co.doubleduck.LabeledContainer;
co.doubleduck.Button.prototype = $extend(co.doubleduck.LabeledContainer.prototype,{
	handleEndPressTint: function() {
		co.doubleduck.Utils.tintBitmap(this._bmp,1,1,1,1);
		if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame.getStage().update();
	}
	,setToggle: function(flag) {
		if(flag) this._states.gotoAndStop(0); else this._states.gotoAndStop(1);
	}
	,handleToggle: function(e) {
		if(this.onToggle == null) return;
		if(this._lastClickPos == null) this._lastClickPos = new createjs.Point(0,0);
		if((this._lastClickPos.x < e.stageX + 1 || this._lastClickPos.x > e.stageX + 1) && (this._lastClickPos.y < e.stageY + 1 || this._lastClickPos.y > e.stageY + 1)) {
			var now = createjs.Ticker.getTime(true);
			if(now < this._lastClickTime + 500) return;
		}
		this._lastClickPos.x = e.stageX;
		this._lastClickPos.y = e.stageY;
		this._lastClickTime = createjs.Ticker.getTime(true);
		this._states.gotoAndStop(1 - this._states.currentFrame);
		this.onToggle();
	}
	,handlePress: function(event) {
		if(createjs.Ticker.getPaused() && this._pauseAffected) return;
		if(this._clickType == co.doubleduck.Button.CLICK_TYPE_HOLD) {
			if(this.onHoldStart != null) {
				this.onHoldStart();
				event.onMouseUp = this.onHoldFinish;
			}
		}
		if(this.onClick != null) {
			if(this._clickSound != null) co.doubleduck.SoundManager.playEffect(this._clickSound);
			switch(this._clickType) {
			case co.doubleduck.Button.CLICK_TYPE_TINT:
				if(this._bmp != null) {
					co.doubleduck.Utils.tintBitmap(this._bmp,0.55,0.55,0.55,1);
					var tween = createjs.Tween.get(this._bmp);
					tween.ignoreGlobalPause = true;
					tween.wait(200).call($bind(this,this.handleEndPressTint));
					if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame.getStage().update();
				}
				break;
			case co.doubleduck.Button.CLICK_TYPE_JUICY:
				this._juiceTween = createjs.Tween.get(this._bitmap);
				this._juiceTween.ignoreGlobalPause = true;
				var startScaleX = this._bitmap.scaleX;
				var startScaleY = this._bitmap.scaleY;
				this._bitmap.scaleX = startScaleX * 1.25;
				this._bitmap.scaleY = startScaleY * 0.75;
				this._juiceTween.to({ scaleX : startScaleX, scaleY : startScaleY},500,createjs.Ease.elasticOut);
				break;
			case co.doubleduck.Button.CLICK_TYPE_SCALE:
				this._juiceTween = createjs.Tween.get(this._bitmap);
				this._juiceTween.ignoreGlobalPause = true;
				var startScaleX = this._bitmap.scaleX;
				var startScaleY = this._bitmap.scaleY;
				this._bitmap.scaleX = startScaleX * 1.18;
				this._bitmap.scaleY = startScaleY * 1.18;
				this._juiceTween.to({ scaleX : startScaleX, scaleY : startScaleY},200,createjs.Ease.elasticOut);
				break;
			case co.doubleduck.Button.CLICK_TYPE_TOGGLE:
				break;
			case co.doubleduck.Button.CLICK_TYPE_NONE:
				break;
			case co.doubleduck.Button.CLICK_TYPE_HOLD:
				throw "Use onHoldStart with CLICK_TYPE_HOLD, not onClick";
				break;
			}
		}
	}
	,setNoSound: function() {
		this._clickSound = null;
	}
	,_lastClickPos: null
	,_lastClickTime: null
	,_clickSound: null
	,_juiceTween: null
	,_clickType: null
	,_pauseAffected: null
	,_states: null
	,onHoldFinish: null
	,onHoldStart: null
	,onToggle: null
	,__class__: co.doubleduck.Button
});
co.doubleduck.Chip = $hxClasses["co.doubleduck.Chip"] = function(spriteSheet) {
	createjs.Container.call(this);
	this.image = new createjs.BitmapAnimation(spriteSheet);
	this.addChild(this.image);
	this.image.regX = spriteSheet._frameWidth / 2;
	this.image.regY = spriteSheet._frameHeight / 2;
};
co.doubleduck.Chip.__name__ = ["co","doubleduck","Chip"];
co.doubleduck.Chip.__super__ = createjs.Container;
co.doubleduck.Chip.prototype = $extend(createjs.Container.prototype,{
	halfFlip: function(duration) {
		createjs.Tween.get(this.image).to({ scaleY : -0.5},duration,createjs.Ease.sineIn);
	}
	,flip: function(flips,duration) {
		while(flips > 0) {
			flips--;
			createjs.Tween.get(this.image).to({ scaleY : -1},duration / 2,createjs.Ease.sineIn).to({ scaleY : 1},duration / 2,createjs.Ease.sineOut).call($bind(this,this.flip),[flips,duration]);
		}
	}
	,getValue: function() {
		return this._value;
	}
	,setValue: function(val) {
		if(this._value == null) this._value == val;
	}
	,image: null
	,_value: null
	,__class__: co.doubleduck.Chip
});
co.doubleduck.ChipPack = $hxClasses["co.doubleduck.ChipPack"] = function(casinoId) {
	var imageUrl = "images/session/casinos/" + casinoId + "/chips_small.png";
	var image = co.doubleduck.BaseAssets.getImage(imageUrl).image;
	var w = image.width;
	var h = image.height;
	var chipSize;
	if(w > h) chipSize = h; else chipSize = w;
	var data = { images : [imageUrl], frames : { width : chipSize, height : chipSize}};
	this._chipsSpritesheet = new createjs.SpriteSheet(data);
	this._values = co.doubleduck.DataLoader.getCasinoById(casinoId).bets;
};
co.doubleduck.ChipPack.__name__ = ["co","doubleduck","ChipPack"];
co.doubleduck.ChipPack.prototype = {
	getChip: function(value) {
		var index = Lambda.indexOf(this._values,value);
		var ret = new co.doubleduck.Chip(this._chipsSpritesheet);
		ret.image.gotoAndStop(index);
		ret.setValue(this._values[index]);
		return ret;
	}
	,_values: null
	,_chipsSpritesheet: null
	,__class__: co.doubleduck.ChipPack
}
co.doubleduck.DataLoader = $hxClasses["co.doubleduck.DataLoader"] = function() { }
co.doubleduck.DataLoader.__name__ = ["co","doubleduck","DataLoader"];
co.doubleduck.DataLoader.getCasinosCount = function() {
	return co.doubleduck.DataLoader.getAllCasinos().length;
}
co.doubleduck.DataLoader.getCoinsWait = function() {
	return 300;
}
co.doubleduck.DataLoader.getAllCasinos = function() {
	return new GameplayDB().getAllCasinos();
}
co.doubleduck.DataLoader.getCasinoById = function(id) {
	var casinos = co.doubleduck.DataLoader.getAllCasinos();
	var _g = 0;
	while(_g < casinos.length) {
		var casino = casinos[_g];
		++_g;
		if((casino.id | 0) == id) return casino;
	}
	return null;
}
co.doubleduck.Dropper = $hxClasses["co.doubleduck.Dropper"] = function() {
	createjs.Container.call(this);
	this._spawnHeight = co.doubleduck.BaseGame.getViewport().y - 100;
	this._killHeight = co.doubleduck.BaseGame.getViewport().height + 100;
	var img = co.doubleduck.BaseAssets.getRawImage("images/menu/drops.png");
	var initObject = { };
	initObject.images = [img];
	initObject.frames = { width : co.doubleduck.Dropper.DROPLET_SIZE, height : co.doubleduck.Dropper.DROPLET_SIZE, regX : co.doubleduck.Dropper.DROPLET_SIZE / 2, regY : co.doubleduck.Dropper.DROPLET_SIZE / 2};
	initObject.animations = { };
	var _g1 = 0, _g = co.doubleduck.Dropper.DROPLET_COUNT;
	while(_g1 < _g) {
		var i = _g1++;
		initObject.animations[co.doubleduck.Dropper.PREFIX + i] = { frames : i, frequency : 20};
	}
	co.doubleduck.Dropper._sheet = new createjs.SpriteSheet(initObject);
};
co.doubleduck.Dropper.__name__ = ["co","doubleduck","Dropper"];
co.doubleduck.Dropper._sheet = null;
co.doubleduck.Dropper.__super__ = createjs.Container;
co.doubleduck.Dropper.prototype = $extend(createjs.Container.prototype,{
	handleDropletDead: function(e) {
		if(this.getChildIndex(e.target) != -1) this.removeChild(e.target);
	}
	,getRandDroplet: function() {
		var droplet;
		droplet = new createjs.BitmapAnimation(co.doubleduck.Dropper._sheet);
		droplet.scaleX = droplet.scaleY = co.doubleduck.BaseGame.getScale();
		droplet.gotoAndStop(co.doubleduck.Dropper.PREFIX + Std.random(co.doubleduck.Dropper.DROPLET_COUNT));
		return droplet;
	}
	,fireBurst: function(amount,timeInterval) {
		var interTime = Math.floor(timeInterval / amount);
		var _g = 0;
		while(_g < amount) {
			var i = _g++;
			var currDroplet = this.getRandDroplet();
			var distance = Math.random() * 0.5 + 0.25;
			currDroplet.y = this._spawnHeight;
			currDroplet.x = Math.random() * co.doubleduck.BaseGame.getViewport().width;
			currDroplet.scaleX *= 1 - distance;
			currDroplet.scaleY *= 1 - distance;
			createjs.Tween.get(currDroplet).wait(i * interTime).to({ y : this._killHeight},co.doubleduck.Dropper.DROP_TIME * distance).call($bind(this,this.handleDropletDead));
			this.addChild(currDroplet);
		}
	}
	,_killHeight: null
	,_spawnHeight: null
	,_droplets: null
	,__class__: co.doubleduck.Dropper
});
co.doubleduck.FontHelper = $hxClasses["co.doubleduck.FontHelper"] = function(type) {
	this._fontType = type;
};
co.doubleduck.FontHelper.__name__ = ["co","doubleduck","FontHelper"];
co.doubleduck.FontHelper.prototype = {
	getNumber: function(num,scale,forceContainer,dims,padding,centered) {
		if(centered == null) centered = true;
		if(padding == null) padding = 0;
		if(forceContainer == null) forceContainer = false;
		if(scale == null) scale = 1;
		if(num >= 0 && num < 10) {
			var result = new createjs.Container();
			var bmp = this.getDigit(num);
			bmp.scaleX = bmp.scaleY = scale;
			result.addChild(bmp);
			if(centered) {
				result.regX = bmp.image.width / 2;
				result.regY = bmp.image.height / 2;
			}
			if(forceContainer) {
				if(dims != null) {
					dims.width = bmp.image.width;
					dims.height = bmp.image.height;
				}
				return result;
			} else return bmp;
		} else {
			var result = new createjs.Container();
			var numString = "" + num;
			var digits = new Array();
			var totalWidth = 0;
			digits[digits.length] = this.getDigit(Std.parseInt(HxOverrides.substr(numString,0,1)));
			digits[0].scaleX = digits[0].scaleY = scale;
			result.addChild(digits[0]);
			totalWidth += digits[0].image.width * scale;
			if(numString.length == 4 || numString.length == 7) {
				this._lastComma = this.getComma();
				this._lastComma.scaleX = this._lastComma.scaleY = scale;
				this._lastComma.x = digits[0].x + digits[0].image.width + padding;
				result.addChild(this._lastComma);
				totalWidth += this._lastComma.image.width * scale;
			}
			var _g1 = 1, _g = numString.length;
			while(_g1 < _g) {
				var i = _g1++;
				var index = digits.length;
				digits[index] = this.getDigit(Std.parseInt(HxOverrides.substr(numString,i,1)));
				if(numString.length - i == 3 || numString.length - i == 6) digits[index].x = this._lastComma.x + this._lastComma.image.width + padding; else digits[index].x = digits[index - 1].x + digits[index - 1].image.width + padding;
				digits[index].scaleX = digits[index].scaleY = scale;
				result.addChild(digits[index]);
				totalWidth += digits[index].image.width * scale + padding;
				if(numString.length - i == 4 || numString.length - i == 7) {
					this._lastComma = this.getComma();
					this._lastComma.scaleX = this._lastComma.scaleY = scale;
					this._lastComma.x = digits[index].x + digits[index].image.width + padding;
					result.addChild(this._lastComma);
					totalWidth += this._lastComma.image.width * scale + padding;
				}
			}
			if(centered) {
				result.regX = totalWidth / 2;
				result.regY = digits[0].image.height / 2;
			}
			if(dims != null) {
				dims.width = totalWidth;
				dims.height = digits[0].image.height;
			}
			return result;
		}
	}
	,getDigit: function(digit) {
		var digit1 = co.doubleduck.BaseAssets.getImage(this._fontType + digit + ".png");
		return digit1;
	}
	,getComma: function() {
		return co.doubleduck.BaseAssets.getImage(this._fontType + "comma.png");
	}
	,_fontType: null
	,_lastComma: null
	,__class__: co.doubleduck.FontHelper
}
co.doubleduck.Game = $hxClasses["co.doubleduck.Game"] = function(stage) {
	co.doubleduck.BaseGame._wantLandscape = false;
	co.doubleduck.BaseGame.isLocalized = true;
	co.doubleduck.BaseGame.defaultLocale = "es";
	co.doubleduck.BaseGame.availableLocales = ["es"];
	co.doubleduck.BaseGame.call(this,stage);
};
co.doubleduck.Game.__name__ = ["co","doubleduck","Game"];
co.doubleduck.Game.__super__ = co.doubleduck.BaseGame;
co.doubleduck.Game.prototype = $extend(co.doubleduck.BaseGame.prototype,{
	fadeOutDone: function() {
		co.doubleduck.BaseGame._stage.removeChild(this._splashBG);
		createjs.Tween.removeTweens(this._splashWheel);
		co.doubleduck.BaseGame._stage.removeChild(this._splashWheel);
		createjs.Tween.removeTweens(this._splashLogo);
		co.doubleduck.BaseGame._stage.removeChild(this._splashLogo);
		createjs.Tween.removeTweens(this._splashTap2Play);
		co.doubleduck.BaseGame._stage.removeChild(this._splashTap2Play);
		this.showMenu();
	}
	,handleBGTap: function() {
		this._splashBG.onClick = null;
		this._splashBG.mouseEnabled = false;
		co.doubleduck.Transition.transitionOut($bind(this,this.fadeOutDone));
	}
	,fadeInDone: function() {
		this._splashBG.mouseEnabled = true;
		this._splashBG.onClick = $bind(this,this.handleBGTap);
	}
	,showGameSplash: function() {
		co.doubleduck.Button.setDefaultSound("sound/button");
		co.doubleduck.BaseGame.prototype.showGameSplash.call(this);
		this._splashBG = co.doubleduck.Utils.getCenteredImage("images/session/casinos/1/bg.jpg",true);
		this._splashBG.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._splashBG.y = co.doubleduck.BaseGame.getViewport().height / 2;
		co.doubleduck.BaseGame._stage.addChild(this._splashBG);
		this._splashWheel = new co.doubleduck.RouletteWheel(1);
		this._splashWheel.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._splashWheel.y = -co.doubleduck.BaseGame.getViewport().height / 2;
		co.doubleduck.BaseGame._stage.addChild(this._splashWheel);
		this._splashLogo = co.doubleduck.Utils.getCenteredImage("images/splash/logo.png",true);
		this._splashLogo.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._splashLogo.y = co.doubleduck.BaseGame.getViewport().height * 0.22;
		this._splashLogo.alpha = 0;
		co.doubleduck.BaseGame._stage.addChild(this._splashLogo);
		this._splashTap2Play = co.doubleduck.Utils.getCenteredImage("images/splash/tap.png",true);
		this._splashTap2Play.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._splashTap2Play.y = co.doubleduck.BaseGame.getViewport().height * 0.5;
		this._splashTap2Play.alpha = 0;
		co.doubleduck.BaseGame._stage.addChild(this._splashTap2Play);
		this._splashWheel.splashSpin();
		createjs.Tween.get(this._splashWheel).to({ y : co.doubleduck.BaseGame.getViewport().height},1800,createjs.Ease.sineOut);
		createjs.Tween.get(this._splashLogo).wait(1200).to({ alpha : 1},600);
		createjs.Tween.get(this._splashTap2Play).wait(1600).call($bind(this,this.fadeInDone)).call($bind(this,this.alphaFade),[this._splashTap2Play]);
		co.doubleduck.BaseGame._stage.addChild(co.doubleduck.Transition.getInstance());
		co.doubleduck.Transition.transitionIn();
	}
	,_splashTap2Play: null
	,_splashLogo: null
	,_splashWheel: null
	,_splashBG: null
	,__class__: co.doubleduck.Game
});
co.doubleduck.HUD = $hxClasses["co.doubleduck.HUD"] = function() {
	createjs.Container.call(this);
	this._container = co.doubleduck.BaseAssets.getImage("images/general/hud/hud.png",true);
	this.addChild(this._container);
	this._progBar = co.doubleduck.BaseAssets.getImage("images/general/hud/fame.png");
	this.addChild(this._progBar);
	this._progMask = new createjs.Shape();
	this._progMask.graphics.beginFill("#dd0000");
	this._progMask.graphics.drawRect(0,0,this._container.image.width * 0.575,this._container.image.height);
	this._progMask.graphics.endFill();
	this._progMask.x = this._container.image.width * 0.23;
	this._progBar.mask = this._progMask;
	this._badge = co.doubleduck.BaseAssets.getImage("images/general/hud/lvl_badge.png");
	this._badge.x = this._container.image.width * 0.8;
	this._badge.y = this._container.image.height * 0.543;
	this.addChild(this._badge);
};
co.doubleduck.HUD.__name__ = ["co","doubleduck","HUD"];
co.doubleduck.HUD.__super__ = createjs.Container;
co.doubleduck.HUD.prototype = $extend(createjs.Container.prototype,{
	updateLevel: function() {
		var level = this.getLevel();
		this._currLevel = level;
		if(this._level != null) {
			this.removeChild(this._level);
			this._level = null;
		}
		this._level = co.doubleduck.Utils.getCenteredImage("images/general/hud/lvl_font/" + level + ".png");
		this._level.x = this._badge.x + this._badge.image.width / 2;
		this._level.y = this._badge.y + this._badge.image.height / 2 - 2;
		this.addChild(this._level);
	}
	,flash: function(cb) {
		createjs.Tween.get(this._progBar).wait(500).to({ alpha : 0},300).wait(100).to({ alpha : 1},50).wait(50).to({ alpha : 0},200).wait(50).to({ alpha : 1},200).wait(500).call(cb);
	}
	,updateMoney: function() {
		if(this._moneyDisplay != null) {
			this.removeChild(this._moneyDisplay);
			this._moneyDisplay = null;
		}
		var dims = new createjs.Rectangle(0,0,0,0);
		this._moneyDisplay = new createjs.Text("" + co.doubleduck.Persistence.getPlayerMoney(),"13px Arial","#FFFFFF");
		this._moneyDisplay.textAlign = "center";
		this._moneyDisplay.x = this._container.image.width * 0.58;
		this._moneyDisplay.y = this._container.image.height * 0.12;
		this.addChild(this._moneyDisplay);
	}
	,getHeight: function() {
		return this._container.image.height;
	}
	,getWidth: function() {
		return this._container.image.width;
	}
	,getLevel: function() {
		var xp = co.doubleduck.Persistence.getPlayerRep();
		var allLevels = co.doubleduck.DataLoader.getAllCasinos();
		var _g1 = 0, _g = allLevels.length;
		while(_g1 < _g) {
			var currLevel = _g1++;
			if((allLevels[currLevel].repToUnlock | 0) > xp) return allLevels[currLevel - 1].id | 0;
		}
		return allLevels[allLevels.length - 1].id | 0;
	}
	,getLevelProgression: function() {
		var currLevel = co.doubleduck.DataLoader.getCasinoById(this.getLevel());
		var nextLevel = co.doubleduck.DataLoader.getCasinoById(this.getLevel() + 1);
		if(nextLevel == null) return 1;
		var all = (nextLevel.repToUnlock | 0) - (currLevel.repToUnlock | 0);
		var delta = co.doubleduck.Persistence.getPlayerRep() - (currLevel.repToUnlock | 0);
		return delta / all;
	}
	,levelUpEnd: function() {
		this._progMask.scaleX = 0.01;
		createjs.Tween.get(this._level).to({ alpha : 0},100);
		createjs.Tween.get(this._badge).to({ scaleY : 0.01},200).to({ scaleY : 1},200).call($bind(this,this.updateLevel)).call($bind(this,this.updateReputation));
	}
	,handleLevelUp: function() {
		createjs.Tween.get(this._progMask).to({ scaleX : 1},200).wait(100).call($bind(this,this.flash),[$bind(this,this.levelUpEnd)]);
		var notice = co.doubleduck.Utils.getCenteredImage("images/session/lvl_up.png",false);
		notice.x = this._container.image.width / 2;
		notice.y = this._container.image.height * 1.12;
		notice.alpha = 0;
		this.addChild(notice);
		createjs.Tween.get(notice).wait(800).call(co.doubleduck.SoundManager.playEffect,["sound/unlock_new_area"]).to({ alpha : 1},200).to({ alpha : 0},200).to({ alpha : 1},600).wait(1300).to({ alpha : 0},500).call($bind(this,this.removeChild),[notice]);
	}
	,updateReputation: function(tween) {
		if(tween == null) tween = true;
		if(this._currLevel < this.getLevel() && tween) {
			this.handleLevelUp();
			return;
		}
		var rep = this.getLevelProgression();
		if(tween) {
			createjs.Tween.removeTweens(this._progMask);
			createjs.Tween.get(this._progMask).to({ scaleX : rep + 0.01},500);
		} else this._progMask.scaleX = rep + 0.01;
	}
	,updateAll: function() {
		this.updateReputation(false);
		this.updateMoney();
		this.updateLevel();
	}
	,_currLevel: null
	,_level: null
	,_moneyDisplay: null
	,_badge: null
	,_progMask: null
	,_progBar: null
	,_container: null
	,__class__: co.doubleduck.HUD
});
co.doubleduck.Main = $hxClasses["co.doubleduck.Main"] = function() { }
co.doubleduck.Main.__name__ = ["co","doubleduck","Main"];
co.doubleduck.Main._stage = null;
co.doubleduck.Main._game = null;
co.doubleduck.Main._ffHeight = null;
co.doubleduck.Main.main = function() {
	co.doubleduck.Main.testFFHeight();
	createjs.Ticker.useRAF = true;
	createjs.Ticker.setFPS(60);
	co.doubleduck.Main._stage = new createjs.Stage(js.Lib.document.getElementById("stageCanvas"));
	co.doubleduck.Main._game = new co.doubleduck.Game(co.doubleduck.Main._stage);
	createjs.Ticker.addListener(co.doubleduck.Main._stage);
	createjs.Touch.enable(co.doubleduck.Main._stage,true,false);
}
co.doubleduck.Main.testFFHeight = function() {
	var isAplicable = /Firefox/.test(navigator.userAgent);
	if(isAplicable && viewporter.ACTIVE) co.doubleduck.Main._ffHeight = js.Lib.window.innerHeight;
}
co.doubleduck.Main.getFFHeight = function() {
	return co.doubleduck.Main._ffHeight;
}
co.doubleduck.Menu = $hxClasses["co.doubleduck.Menu"] = function() {
	this._isSweeping = false;
	co.doubleduck.BaseMenu.call(this);
	this._casinoArray = new Array();
	this._locksArray = new Array();
	this._background = co.doubleduck.BaseAssets.getImage("images/menu/bg.jpg");
	this._background.scaleX = this._background.scaleY = co.doubleduck.BaseGame.getScale();
	this._background.regX = this._background.image.width / 2;
	this._background.regY = this._background.image.height / 2;
	this._background.x = co.doubleduck.BaseGame.getViewport().width / 2;
	this._background.y = co.doubleduck.BaseGame.getViewport().height / 2;
	this.addChild(this._background);
	this._selectRight = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/right_arr.png"));
	this._selectRight.scaleX = this._selectRight.scaleY = co.doubleduck.BaseGame.getScale();
	this._selectRight.regX = this._selectRight.image.width;
	this._selectRight.regY = this._selectRight.image.height / 2;
	this._selectLeft = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/right_arr.png"));
	this._selectLeft.scaleX = this._selectLeft.scaleY = co.doubleduck.BaseGame.getScale();
	this._selectLeft.scaleX *= -1;
	this._selectLeft.regX = this._selectLeft.image.width;
	this._selectLeft.regY = this._selectLeft.image.height / 2;
	this._selectRight.x = co.doubleduck.BaseGame.getViewport().width - 10;
	this._selectRight.y = co.doubleduck.BaseGame.getViewport().height * 0.5;
	this._selectLeft.x = 10;
	this._selectLeft.y = this._selectRight.y;
	this._selectRight.onClick = $bind(this,this.handleNextSlot);
	this._selectLeft.onClick = $bind(this,this.handlePrevSlot);
	this._casinoRow = new createjs.Container();
	this._casinoRow.x = co.doubleduck.BaseGame.getViewport().width * 0.5;
	this.addChild(this._casinoRow);
	this._chosenCasinoId = 0;
	var _g1 = 0, _g = co.doubleduck.DataLoader.getCasinosCount();
	while(_g1 < _g) {
		var i = _g1++;
		this.loadCasinoImage(i);
	}
	this._buttonsLayer = new createjs.Container();
	var casinoToTarget = this.getLevel() - 1;
	if(co.doubleduck.Session.lastCasinoId != -1) casinoToTarget = co.doubleduck.Session.lastCasinoId - 1;
	this.targetCasino(casinoToTarget,true);
	this.addChild(this._selectLeft);
	this.addChild(this._selectRight);
	this._ground = co.doubleduck.BaseAssets.getImage("images/menu/ground.jpg");
	this._ground.scaleX = this._ground.scaleY = co.doubleduck.BaseGame.getScale();
	this._ground.regX = this._ground.image.width / 2;
	this._ground.regY = this._ground.image.height;
	this._ground.x = co.doubleduck.BaseGame.getViewport().width / 2;
	this._ground.y = co.doubleduck.BaseGame.getViewport().height;
	this._casinoRow.y = this._ground.y - (this._ground.image.height - 1) * co.doubleduck.BaseGame.getScale();
	this.addChild(this._ground);
	this._hud = new co.doubleduck.HUD();
	this._hud.scaleX = this._hud.scaleY = co.doubleduck.BaseGame.getScale();
	this._hud.regX = this._hud.getWidth();
	this._hud.x = co.doubleduck.BaseGame.getViewport().width - 10 * co.doubleduck.BaseGame.getScale();
	this._hud.updateAll();
	this.addChild(this._hud);
	this._helpBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/help.png"));
	this._helpBtn.scaleX = this._helpBtn.scaleY = co.doubleduck.BaseGame.getScale();
	this._helpBtn.regX = 0;
	this._helpBtn.regY = this._helpBtn.image.height / 2;
	this._helpBtn.x = -co.doubleduck.BaseGame.getViewport().width * 0.45;
	this._helpBtn.y = 10 * co.doubleduck.BaseGame.getScale();
	this._helpBtn.onClick = $bind(this,this.showHelpMenu);
	this._buttonsLayer.addChild(this._helpBtn);
	if(co.doubleduck.SoundManager.available) {
		this._muteButton = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/sound.png"),true,co.doubleduck.Button.CLICK_TYPE_TOGGLE);
		this._muteButton.scaleX = this._muteButton.scaleY = co.doubleduck.BaseGame.getScale();
		this._muteButton.x = this._helpBtn.x + this._helpBtn.image.width * co.doubleduck.BaseGame.getScale() * 1.6;
		this._muteButton.y = this._helpBtn.y;
		this._muteButton.setToggle(!co.doubleduck.SoundManager.isMuted());
		this._muteButton.onToggle = co.doubleduck.SoundManager.toggleMute;
		this._buttonsLayer.addChild(this._muteButton);
	}
	this._buttonsLayer.x = co.doubleduck.BaseGame.getViewport().width / 2;
	this._buttonsLayer.y = co.doubleduck.BaseGame.getViewport().height * 0.88;
	this.addChild(this._buttonsLayer);
	this._dropper = new co.doubleduck.Dropper();
	this.addChild(this._dropper);
	this._uiOverlay = new createjs.Shape();
	this._uiOverlay.graphics.beginFill("#000000");
	this._uiOverlay.graphics.drawRect(-30,-30,co.doubleduck.BaseGame.getViewport().width + 60,co.doubleduck.BaseGame.getViewport().height + 60);
	this._uiOverlay.graphics.endFill();
	this._uiOverlay.alpha = 0;
	this.addChild(this._uiOverlay);
	this.updateCoinCollect();
	this._helpScreen = new co.doubleduck.PagedHelp("images/menu/help_frame.png","images/menu/next.png","images/menu/gotit.png",["images/menu/help1.png","images/menu/help2.png","images/menu/help3.png","images/menu/help4.png"]);
	this._helpScreen.x = co.doubleduck.BaseGame.getViewport().width / 2;
	this._helpScreen.y = co.doubleduck.BaseGame.getViewport().height * 0.45;
	this._helpScreen.scaleX = this._helpScreen.scaleY = co.doubleduck.BaseGame.getScale();
	this._helpScreen.alpha = 0;
	this._helpScreen.onGotIt = $bind(this,this.closeHelp);
	this._helpScreen.setMarkersPos(5);
	this._helpScreen.setButtonsPos(0.8,0.9);
	this.addChild(this._helpScreen);
	co.doubleduck.BaseGame.hammer.onswipe = $bind(this,this.handleSwipe);
	this._bgMusic = co.doubleduck.SoundManager.playMusic("sound/menu_music");
	this.addChild(co.doubleduck.Transition.getInstance());
	co.doubleduck.Transition.transitionIn();
};
co.doubleduck.Menu.__name__ = ["co","doubleduck","Menu"];
co.doubleduck.Menu.__super__ = co.doubleduck.BaseMenu;
co.doubleduck.Menu.prototype = $extend(co.doubleduck.BaseMenu.prototype,{
	switchToSession: function() {
		var params = { };
		params.level = this._chosenCasinoId + 1;
		if(this.onPlayClick != null) this.onPlayClick(params);
	}
	,handlePlaySession: function(e) {
		if(this._uiOverlay.alpha > 0) return;
		if(this._locksArray[this._chosenCasinoId] == false) {
			co.doubleduck.BaseGame.hammer.onswipe = null;
			this._playButton.onClick = null;
			e.target.onClick = null;
			co.doubleduck.Transition.transitionOut($bind(this,this.switchToSession));
		}
	}
	,handleGetCoins: function() {
		var money = co.doubleduck.Persistence.getPlayerMoney() + 1000;
		co.doubleduck.Persistence.setPlayerMoney(money);
		this._hud.updateMoney();
		var now = new Date().getTime();
		co.doubleduck.Persistence.setCoinTime(now);
		co.doubleduck.SoundManager.playEffect("sound/get_chips");
		this.removeChild(this._getCoinsBtn);
		this._getCoinsBtn = null;
		this.removeChild(this._getCoinsLight);
		createjs.Tween.removeTweens(this._getCoinsLight);
		this._getCoinsLight = null;
		this.removeChild(this._getCoinsNow);
		this._getCoinsNow = null;
		this.showNextCoinIn();
		this._dropper.fireBurst(30,600);
	}
	,glowSpin: function() {
		if(this._getCoinsLight == null) return;
		this._getCoinsLight.rotation = 0;
		createjs.Tween.get(this._getCoinsLight).to({ rotation : 360},3000).call($bind(this,this.glowSpin));
	}
	,showGetCoinsButton: function() {
		this._getCoinsBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/get_coins2.png"));
		this._getCoinsBtn.regX = 0;
		this._getCoinsBtn.x = 10 * co.doubleduck.BaseGame.getScale();
		this._getCoinsBtn.scaleX = this._getCoinsBtn.scaleY = co.doubleduck.BaseGame.getScale();
		this._getCoinsBtn.onClick = $bind(this,this.handleGetCoins);
		if(this._uiOverlay.alpha != 0) this._getCoinsBtn.mouseEnabled = false;
		this.addChildAt(this._getCoinsBtn,this.getChildIndex(this._dropper));
		this._getCoinsLight = co.doubleduck.Utils.getCenteredImage("images/menu/glow.png",true);
		this._getCoinsLight.x = this._getCoinsBtn.x + this._getCoinsBtn.image.width * 0.5 * co.doubleduck.BaseGame.getScale();
		this._getCoinsLight.y = 24 * co.doubleduck.BaseGame.getScale();
		this._getCoinsLight.alpha = 0;
		createjs.Tween.get(this._getCoinsLight).to({ alpha : 1},500);
		this.addChildAt(this._getCoinsLight,this.getChildIndex(this._dropper));
		this.glowSpin();
		this._getCoinsNow = co.doubleduck.Utils.getCenteredImage("images/menu/chips_bar2.png",true);
		this._getCoinsNow.x = this._getCoinsLight.x;
		this._getCoinsNow.regY = 0;
		this.addChildAt(this._getCoinsNow,this.getChildIndex(this._dropper));
	}
	,coinTimer: function() {
		var now = new Date().getTime();
		var interval = co.doubleduck.DataLoader.getCoinsWait();
		var nextCoinTime = (co.doubleduck.Persistence.getCoinTime() + interval * 1000 - now | 0) / 1000 | 0;
		if(nextCoinTime > 0) {
			var mins = nextCoinTime / 60 | 0;
			var secs = nextCoinTime % 60;
			var minString = "" + mins;
			var secString = "" + secs;
			if(mins < 10) minString = "0" + mins;
			if(secs < 10) secString = "0" + secs;
			this._coinsIn.text = minString + ":" + secString;
			this._getCoinsMask.scaleX = co.doubleduck.BaseGame.getScale() * 0.85 * ((interval - nextCoinTime) / interval) + 0.01;
			co.doubleduck.Utils.waitAndCall(this,1000,$bind(this,this.coinTimer));
		} else {
			this.removeChild(this._getCoinsStroke);
			this.removeChild(this._getCoinsFill);
			this.removeChild(this._coinsIn);
			this._coinsIn = null;
			this._getCoinsStroke = null;
			this._getCoinsMask = null;
			this._getCoinsFill = null;
			this.showGetCoinsButton();
		}
	}
	,showNextCoinIn: function() {
		this._getCoinsStroke = co.doubleduck.BaseAssets.getImage("images/menu/get_coins1.png");
		this._getCoinsStroke.regX = this._getCoinsStroke.image.width / 2;
		this._getCoinsStroke.scaleX = this._getCoinsStroke.scaleY = co.doubleduck.BaseGame.getScale();
		this.addChildAt(this._getCoinsStroke,this.getChildIndex(this._dropper));
		this._getCoinsStroke.x = (10 + this._getCoinsStroke.image.width / 2) * co.doubleduck.BaseGame.getScale();
		this._getCoinsStroke.y = 0;
		this._getCoinsFill = co.doubleduck.BaseAssets.getImage("images/menu/chips_bar1.png");
		this._getCoinsFill.regX = this._getCoinsFill.image.width / 2;
		this._getCoinsFill.scaleX = this._getCoinsFill.scaleY = co.doubleduck.BaseGame.getScale();
		this.addChildAt(this._getCoinsFill,this.getChildIndex(this._dropper));
		this._getCoinsFill.x = this._getCoinsStroke.x;
		this._getCoinsMask = new createjs.Shape();
		this._getCoinsMask.graphics.beginFill("#ff0000");
		this._getCoinsMask.graphics.drawRect(0,0,this._getCoinsFill.image.width,this._getCoinsFill.image.height);
		this._getCoinsMask.graphics.endFill();
		this._getCoinsMask.scaleX = this._getCoinsMask.scaleY = co.doubleduck.BaseGame.getScale();
		this._getCoinsMask.x = this._getCoinsStroke.x - this._getCoinsStroke.image.width * 0.42 * co.doubleduck.BaseGame.getScale();
		this._getCoinsFill.mask = this._getCoinsMask;
		var px = 10 * co.doubleduck.BaseGame.getScale();
		this._coinsIn = new createjs.Text("","" + px + "px Helvetica, Arial, sans-serif","#dddddd");
		this._coinsIn.textAlign = "center";
		this._coinsIn.regY = this._coinsIn.getMeasuredHeight() / 2;
		this._coinsIn.y = 26 * co.doubleduck.BaseGame.getScale();
		this._coinsIn.x = this._getCoinsFill.x;
		this.addChildAt(this._coinsIn,this.getChildIndex(this._dropper));
		this.coinTimer();
	}
	,updateCoinCollect: function() {
		var now = new Date().getTime();
		var interval = co.doubleduck.DataLoader.getCoinsWait();
		var nextCoinTime = co.doubleduck.Persistence.getCoinTime() + interval * 1000 - now | 0;
		if(nextCoinTime > 0) this.showNextCoinIn(); else this.showGetCoinsButton();
	}
	,setArrowsVisibility: function() {
		if(this._chosenCasinoId > 0) this._selectLeft.visible = true; else this._selectLeft.visible = false;
		if(this._chosenCasinoId + 1 < co.doubleduck.DataLoader.getCasinosCount()) this._selectRight.visible = true; else this._selectRight.visible = false;
	}
	,handlePrevSlot: function() {
		if(this._chosenCasinoId > 0) this.targetCasino(this._chosenCasinoId - 1);
		this.setArrowsVisibility();
	}
	,handleNextSlot: function() {
		if(this._chosenCasinoId + 1 < co.doubleduck.DataLoader.getCasinosCount()) this.targetCasino(this._chosenCasinoId + 1);
		this.setArrowsVisibility();
	}
	,destroy: function() {
		co.doubleduck.BaseMenu.prototype.destroy.call(this);
		if(this._bgMusic != null) this._bgMusic.stop();
		if(this._isSweeping) this.onTick = null;
	}
	,handleTick: function(elapsed) {
		if(this._casinoRow.x == this._targetPos) {
			this.onTick = null;
			this._isSweeping = false;
			return;
		}
		var delta = co.doubleduck.Menu.SCROLL_EASE * elapsed;
		delta = Math.min(delta,0.2);
		delta *= this._targetPos - this._casinoRow.x;
		this._casinoRow.x += delta;
		if(Math.abs(delta) < 0.1) {
			this._casinoArray[this._chosenCasinoId].onClick = $bind(this,this.handlePlaySession);
			this._casinoRow.x = this._targetPos;
			this.onTick = null;
			this._isSweeping = false;
		}
	}
	,targetCasino: function(id,force) {
		if(force == null) force = false;
		this._casinoArray[this._chosenCasinoId].onClick = null;
		this._chosenCasinoId = id;
		this._targetPos = co.doubleduck.BaseGame.getViewport().width / 2 - this._casinoArray[id].x;
		if(this._playButton != null) {
			this._playButton.onClick = null;
			this._buttonsLayer.removeChild(this._playButton);
			this._playButton = null;
		}
		if(this._locksArray[this._chosenCasinoId]) this._playButton = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/play_locked.png")); else {
			this._playButton = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/play" + (this._chosenCasinoId + 1) + ".png"));
			this._playButton.onClick = $bind(this,this.handlePlaySession);
		}
		this._playButton.scaleX = this._playButton.scaleY = co.doubleduck.BaseGame.getScale();
		this._playButton.regX = this._playButton.image.width;
		this._playButton.regY = this._playButton.image.height / 2;
		this._playButton.x = co.doubleduck.BaseGame.getViewport().width * 0.51;
		this._buttonsLayer.addChild(this._playButton);
		this.setArrowsVisibility();
		if(force) {
			this._isSweeping = false;
			this._casinoRow.x = this._targetPos;
			this._casinoArray[this._chosenCasinoId].onClick = $bind(this,this.handlePlaySession);
		} else {
			this._isSweeping = true;
			this.onTick = $bind(this,this.handleTick);
		}
	}
	,loadCasinoImage: function(id) {
		var uriImage;
		if(this.getLevel() < id + 1) {
			this._locksArray[id] = true;
			uriImage = "images/menu/casino" + (id + 1) + ".png";
		} else {
			this._locksArray[id] = false;
			uriImage = "images/menu/unlock" + (id + 1) + ".png";
		}
		this._casinoArray[id] = co.doubleduck.BaseAssets.getImage(uriImage,true);
		this._casinoArray[id].regX = this._casinoArray[id].image.width / 2;
		this._casinoArray[id].regY = this._casinoArray[id].image.height;
		this._casinoArray[id].scaleX = this._casinoArray[id].scaleY = co.doubleduck.BaseGame.getScale();
		this._casinoArray[id].x = id * co.doubleduck.BaseGame.getViewport().width;
		this._casinoArray[id].y = 0;
		this._casinoRow.addChild(this._casinoArray[id]);
	}
	,handleSwipe: function(event) {
		if(event.direction == "left") this.handleNextSlot(); else if(event.direction == "right") this.handlePrevSlot();
	}
	,getLevel: function() {
		var xp = co.doubleduck.Persistence.getPlayerRep();
		var allLevels = co.doubleduck.DataLoader.getAllCasinos();
		var _g1 = 0, _g = allLevels.length;
		while(_g1 < _g) {
			var currLevel = _g1++;
			if((allLevels[currLevel].repToUnlock | 0) > xp) return allLevels[currLevel - 1].id | 0;
		}
		return allLevels[allLevels.length - 1].id | 0;
	}
	,getLevelProgression: function() {
		var currLevel = co.doubleduck.DataLoader.getCasinoById(this.getLevel());
		var nextLevel = co.doubleduck.DataLoader.getCasinoById(this.getLevel() + 1);
		if(nextLevel == null) return 1;
		var all = (nextLevel.repToUnlock | 0) - (currLevel.repToUnlock | 0);
		var delta = co.doubleduck.Persistence.getPlayerRep() - (currLevel.repToUnlock | 0);
		return delta / all;
	}
	,removeEase: function(t) {
		if(t <= 0) return 0; else if(t >= 1) return 1;
		return 1.4 * t * t - 0.4 * t;
	}
	,handleDailySpin: function() {
	}
	,getTodayDate: function() {
		var newDate = new Date();
		var dateName = newDate.getDate() + '/' + (newDate.getMonth() + 1) + '/' + newDate.getFullYear();
		return dateName;
	}
	,toggleOverlay: function(flag) {
		var targetAlpha = 0;
		if(flag) targetAlpha = 0.65;
		createjs.Tween.removeTweens(this._uiOverlay);
		createjs.Tween.get(this._uiOverlay).to({ alpha : targetAlpha},300);
		if(this._muteButton != null) this._muteButton.mouseEnabled = !flag;
		this._buttonsLayer.mouseEnabled = !flag;
		if(this._getCoinsBtn != null) this._getCoinsBtn.mouseEnabled = !flag;
		if(flag) {
			this._helpBtn.onClick = null;
			this._selectRight.visible = this._selectLeft.visible = false;
		} else {
			this._helpBtn.onClick = $bind(this,this.showHelpMenu);
			this.setArrowsVisibility();
		}
	}
	,closeHelp: function() {
		this.toggleOverlay(false);
		createjs.Tween.removeTweens(this._helpScreen);
		createjs.Tween.removeTweens(this._helpBtn);
		createjs.Tween.get(this._helpScreen).to({ alpha : 0},600);
		this._helpBtn.alpha = 1;
	}
	,showHelpMenu: function() {
		this._helpScreen.rewindPages();
		this.toggleOverlay(true);
		createjs.Tween.get(this._helpScreen).to({ alpha : 1},1000,createjs.Ease.sineOut);
		createjs.Tween.get(this._helpBtn).to({ alpha : 0},1000,createjs.Ease.sineOut);
		this._helpScreen.visible = true;
	}
	,_getChipBtn: null
	,_helpScreen: null
	,_uiOverlay: null
	,_dropper: null
	,_casinoRow: null
	,_targetPos: null
	,_isSweeping: null
	,_buttonsLayer: null
	,_getCoinsLight: null
	,_getCoinsNow: null
	,_getCoinsMask: null
	,_coinsIn: null
	,_getCoinsStroke: null
	,_getCoinsFill: null
	,_getCoinsBtn: null
	,_helpBtn: null
	,_hud: null
	,_bgMusic: null
	,_muteButton: null
	,_playLocked: null
	,_playButton: null
	,_ground: null
	,_selectLeft: null
	,_selectRight: null
	,_chosenCasinoId: null
	,_locksArray: null
	,_casinoArray: null
	,_background: null
	,__class__: co.doubleduck.Menu
});
co.doubleduck.PagedHelp = $hxClasses["co.doubleduck.PagedHelp"] = function(backUri,nextBtnUri,gotItBtnUri,pages) {
	createjs.Container.call(this);
	this._background = co.doubleduck.BaseAssets.getImage(backUri);
	this.addChild(this._background);
	this.regX = this._background.image.width / 2;
	this.regY = this._background.image.height / 2;
	this._contentLayer = new createjs.Container();
	if(pages.length > 0) {
		var _g1 = 0, _g = pages.length;
		while(_g1 < _g) {
			var i = _g1++;
			this.addPage(pages[i],i);
		}
		this.addChild(this._contentLayer);
		this._pagesCount = pages.length;
		this._mask = new createjs.Shape();
		this._mask.graphics.beginFill("#000000");
		this._mask.graphics.drawRect(20,20,this._background.image.width - 40,this._background.image.height - 40);
		this._mask.graphics.endFill();
		this._contentLayer.mask = this._mask;
	} else this._pagesCount = 0;
	if(nextBtnUri != null && nextBtnUri != "") {
		this._nextBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage(nextBtnUri),true,co.doubleduck.Button.CLICK_TYPE_SCALE);
		this._nextBtn.regX = this._nextBtn.image.width / 2;
		this._nextBtn.regY = this._nextBtn.image.height / 2;
		this._nextBtn.onClick = $bind(this,this.handleNextClick);
		this.addChild(this._nextBtn);
	}
	this._gotItBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage(gotItBtnUri),true,co.doubleduck.Button.CLICK_TYPE_SCALE);
	this._gotItBtn.regX = this._gotItBtn.image.width / 2;
	this._gotItBtn.regY = this._gotItBtn.image.height / 2;
	this._gotItBtn.onClick = $bind(this,this.handleGotItClick);
	this.addChild(this._gotItBtn);
	this.setButtonsPos();
	this._currPage = 0;
	this.enableSwipe();
	this.addPageMarkers();
	this.setButtonsVis();
};
co.doubleduck.PagedHelp.__name__ = ["co","doubleduck","PagedHelp"];
co.doubleduck.PagedHelp.__super__ = createjs.Container;
co.doubleduck.PagedHelp.prototype = $extend(createjs.Container.prototype,{
	createPageMarker: function() {
		var img = co.doubleduck.BaseAssets.getRawImage("images/duckling/page_marker.png");
		var initObject = { };
		initObject.images = [img];
		initObject.frames = { width : 16, height : 18};
		initObject.animations = { };
		initObject.animations.idle = { frames : 0, frequency : 20};
		initObject.animations.active = { frames : 1, frequency : 20};
		var pageMarker = new createjs.BitmapAnimation(new createjs.SpriteSheet(initObject));
		pageMarker.gotoAndStop("idle");
		return pageMarker;
	}
	,handleNextClick: function() {
		this._currPage++;
		if(this._currPage >= this._pagesCount) {
			this._currPage = this._pagesCount - 1;
			return;
		}
		this._pageMarkers[this._currPage - 1].gotoAndStop("idle");
		this._pageMarkers[this._currPage].gotoAndStop("active");
		createjs.Tween.get(this._contentLayer).to({ x : -1 * this._background.image.width * this._currPage},200,createjs.Ease.sineOut);
		this.setButtonsVis();
	}
	,handlePrevClick: function() {
		this._currPage--;
		if(this._currPage < 0) {
			this._currPage = 0;
			return;
		}
		this._pageMarkers[this._currPage + 1].gotoAndStop("idle");
		this._pageMarkers[this._currPage].gotoAndStop("active");
		createjs.Tween.get(this._contentLayer).to({ x : -1 * this._background.image.width * this._currPage},200,createjs.Ease.sineOut);
		this.setButtonsVis();
	}
	,setButtonsVis: function() {
		if(this._pagesCount == 0) {
			this._gotItBtn.visible = true;
			return;
		}
		if(this._currPage == this._pagesCount - 1) {
			this._gotItBtn.visible = true;
			this._nextBtn.visible = false;
		} else {
			this._gotItBtn.visible = false;
			this._nextBtn.visible = true;
		}
	}
	,handleSwipe: function(event) {
		if(event.direction == "left") this.handleNextClick(); else if(event.direction == "right") this.handlePrevClick();
	}
	,handleGotItClick: function() {
		if(this.onGotIt != null) this.onGotIt();
	}
	,addPageMarkers: function() {
		if(this._pagesCount == 0) return;
		this._pageMarkers = new Array();
		var totalWidth = 0;
		this._markersLayer = new createjs.Container();
		var _g1 = 0, _g = this._pagesCount;
		while(_g1 < _g) {
			var currPage = _g1++;
			var pageMarker = this.createPageMarker();
			this._pageMarkers.push(pageMarker);
			if(currPage != 0) {
				pageMarker.x = this._pageMarkers[currPage - 1].x + this._pageMarkers[currPage - 1].spriteSheet._frameWidth + 5;
				totalWidth += 5;
			}
			totalWidth += pageMarker.spriteSheet._frameWidth;
			this._markersLayer.addChild(pageMarker);
		}
		this._markersLayer.y = this._background.image.height * 0.80;
		this._markersLayer.x = this._background.image.width / 2;
		this._markersLayer.regX = totalWidth / 2;
		this.addChild(this._markersLayer);
		this._pageMarkers[0].gotoAndStop("active");
	}
	,addPage: function(pageUri,index) {
		var page = co.doubleduck.BaseAssets.getImage(pageUri);
		page.x += this._background.image.width * index;
		this._contentLayer.addChild(page);
	}
	,goToPage: function(page) {
		this._pageMarkers[this._currPage].gotoAndStop("idle");
		this._currPage = page;
		this._pageMarkers[this._currPage].gotoAndStop("active");
		this._contentLayer.x = -1 * this._background.image.width * this._currPage;
		this.setButtonsVis();
	}
	,changeContentMask: function(topPad,bottomPad,leftPad,rightPad) {
		this._mask.graphics.clear();
		this._mask.graphics.beginFill("#000000");
		this._mask.graphics.drawRect(leftPad,topPad,this._background.image.width - (rightPad + leftPad),this._background.image.height - (bottomPad + topPad));
		this._mask.graphics.endFill();
	}
	,rewindPages: function() {
		this.goToPage(0);
	}
	,enableSwipe: function() {
		co.doubleduck.BaseGame.hammer.onswipe = $bind(this,this.handleSwipe);
	}
	,setMarkersPos: function(percentY,percentX) {
		if(percentX == null) percentX = 0.5;
		this._markersLayer.y = this._background.image.height * percentY;
		this._markersLayer.x = this._background.image.width * percentX;
	}
	,setButtonsPos: function(percentX,percentY) {
		if(percentY == null) percentY = 0.5;
		if(percentX == null) percentX = 0.5;
		if(this._nextBtn != null) {
			this._nextBtn.x = this._background.image.width * percentX;
			this._nextBtn.y = this._background.image.height * percentY;
		}
		this._gotItBtn.x = this._background.image.width * percentX;
		this._gotItBtn.y = this._background.image.height * percentY;
	}
	,_currPage: null
	,_pagesCount: null
	,_gotItBtn: null
	,_nextBtn: null
	,_pageMarkers: null
	,_markersLayer: null
	,_mask: null
	,_contentLayer: null
	,_background: null
	,onGotIt: null
	,__class__: co.doubleduck.PagedHelp
});
co.doubleduck.Persistence = $hxClasses["co.doubleduck.Persistence"] = function() { }
co.doubleduck.Persistence.__name__ = ["co","doubleduck","Persistence"];
co.doubleduck.Persistence.initGameData = function() {
	co.doubleduck.BasePersistence.GAME_PREFIX = "RLT_";
	if(!co.doubleduck.BasePersistence.available) return;
	co.doubleduck.BasePersistence.initVar("reputation");
	co.doubleduck.BasePersistence.initVar("moneyCount","1000");
}
co.doubleduck.Persistence.getPlayerMoney = function() {
	return Std.parseInt(co.doubleduck.BasePersistence.getValue("moneyCount"));
}
co.doubleduck.Persistence.setPlayerMoney = function(amount) {
	co.doubleduck.BasePersistence.setValue("moneyCount","" + amount);
}
co.doubleduck.Persistence.getPlayerRep = function() {
	return Std.parseInt(co.doubleduck.BasePersistence.getValue("reputation"));
}
co.doubleduck.Persistence.setPlayerRep = function(rep) {
	co.doubleduck.BasePersistence.setValue("reputation","" + rep);
}
co.doubleduck.Persistence.setCoinTime = function(time) {
	co.doubleduck.BasePersistence.setValue("coinTime","" + time);
}
co.doubleduck.Persistence.getCoinTime = function() {
	return Std.parseFloat(co.doubleduck.BasePersistence.getValue("coinTime"));
}
co.doubleduck.Persistence.__super__ = co.doubleduck.BasePersistence;
co.doubleduck.Persistence.prototype = $extend(co.doubleduck.BasePersistence.prototype,{
	__class__: co.doubleduck.Persistence
});
co.doubleduck.RouletteWheel = $hxClasses["co.doubleduck.RouletteWheel"] = function(casinoID) {
	this._numberToRoll = -1;
	createjs.Container.call(this);
	this._casinoID = casinoID;
	this._base = co.doubleduck.Utils.getCenteredImage("images/session/casinos/" + this._casinoID + "/base.png",true);
	this.addChild(this._base);
	this._base.mouseEnabled = true;
	this._numbers = co.doubleduck.Utils.getCenteredImage("images/session/casinos/" + this._casinoID + "/nmbrs.png",true);
	this.addChild(this._numbers);
	this._scaledBall = co.doubleduck.Utils.getCenteredImage("images/session/ball.png",true);
	this._ball = new createjs.Container();
	this._ball.addChild(this._scaledBall);
	this._ball.regX = this._base.image.width * 0.5 * 0.6 * co.doubleduck.BaseGame.getScale();
	this._ball.rotation = -56;
	this.addChild(this._ball);
	this._handleShadow = co.doubleduck.Utils.getCenteredImage("images/session/casinos/" + this._casinoID + "/handles_shdw.png",true);
	this._handleShadow.x = this._handleShadow.y = 10 * co.doubleduck.BaseGame.getScale();
	this.addChild(this._handleShadow);
	this._handle = co.doubleduck.Utils.getCenteredImage("images/session/casinos/" + this._casinoID + "/handles.png",true);
	this.addChild(this._handle);
	this._handleTop = co.doubleduck.Utils.getCenteredImage("images/session/casinos/" + this._casinoID + "/top.png",true);
	this.addChild(this._handleTop);
};
co.doubleduck.RouletteWheel.__name__ = ["co","doubleduck","RouletteWheel"];
co.doubleduck.RouletteWheel.__super__ = createjs.Container;
co.doubleduck.RouletteWheel.prototype = $extend(createjs.Container.prototype,{
	spinDone: function() {
		if(this.onSpinEnded != null) this.onSpinEnded(this._numberToRoll);
	}
	,kickstartEase: function(t) {
		if(t <= 0) return 0; else if(t >= 1) return 1;
		return 1.4 * t * t - 0.4 * t;
	}
	,getRadius: function() {
		if(this._base != null) return this._base.image.width / 2;
		return 0;
	}
	,splashSpin: function() {
		this._ball.visible = false;
		var lastTween = null;
		var spinables = [this._numbers,this._handleShadow,this._handle];
		var _g1 = 0, _g = spinables.length;
		while(_g1 < _g) {
			var i = _g1++;
			spinables[i].rotation = 0;
			lastTween = createjs.Tween.get(spinables[i]).to({ rotation : 360},co.doubleduck.RouletteWheel.TIME_PER_SPIN * 3);
		}
		lastTween.call($bind(this,this.splashSpin));
	}
	,spin: function(rigStopAt) {
		if(rigStopAt == null) rigStopAt = -1;
		co.doubleduck.SoundManager.playEffect("sound/theme_spin" + this._casinoID);
		if(js.Boot.__instanceof(rigStopAt,Int) && (rigStopAt >= 0 && rigStopAt <= 36)) this._numberToRoll = rigStopAt; else this._numberToRoll = Std.random(37);
		var stopAtAngle = 37 - Lambda.indexOf(co.doubleduck.Session.numOrder,this._numberToRoll) + 22;
		stopAtAngle *= co.doubleduck.RouletteWheel.SLOT_WIDTH;
		var lastTween = null;
		var spinables = [this._numbers,this._handleShadow,this._handle];
		var _g1 = 0, _g = spinables.length;
		while(_g1 < _g) {
			var i = _g1++;
			spinables[i].rotation = spinables[i].rotation % 360;
			lastTween = createjs.Tween.get(spinables[i]).wait(400);
			lastTween = lastTween.to({ rotation : spinables[i].rotation + 360},co.doubleduck.RouletteWheel.TIME_PER_SPIN * 2,$bind(this,this.kickstartEase));
			lastTween = lastTween.to({ rotation : 720},co.doubleduck.RouletteWheel.TIME_PER_SPIN * (1 - spinables[i].rotation / 360));
			lastTween = lastTween.to({ rotation : 360 * co.doubleduck.RouletteWheel.SPINS_COUNT},co.doubleduck.RouletteWheel.TIME_PER_SPIN * (co.doubleduck.RouletteWheel.SPINS_COUNT - 2));
			lastTween = lastTween.to({ rotation : 360 * co.doubleduck.RouletteWheel.SPINS_COUNT + stopAtAngle},co.doubleduck.RouletteWheel.TIME_PER_SPIN * (stopAtAngle / 360));
			lastTween = lastTween.to({ rotation : 360 * co.doubleduck.RouletteWheel.SPINS_COUNT + stopAtAngle + 720},co.doubleduck.RouletteWheel.TIME_PER_SPIN * 10,createjs.Ease.quintOut);
		}
		lastTween.call($bind(this,this.spinDone));
		this._ball.rotation = this._ball.rotation % 360;
		createjs.Tween.get(this._ball).wait(400).to({ rotation : -2936},11500,createjs.Ease.sineOut).wait(1200).call(co.doubleduck.SoundManager.playEffect,["sound/spin_end"]);
		createjs.Tween.get(this._ball).to({ regX : this._base.image.width * 0.5 * 0.93 * co.doubleduck.BaseGame.getScale()},380,createjs.Ease.sineInOut).wait(4000).to({ regX : this._base.image.width * 0.5 * 0.6 * co.doubleduck.BaseGame.getScale()},1000);
		var hopTween = createjs.Tween.get(this._scaledBall).wait(5000);
		var _g = 0;
		while(_g < 9) {
			var i = _g++;
			var scale = co.doubleduck.BaseGame.getScale() * (1.6 - 0.05 * i);
			hopTween = hopTween.to({ scaleX : scale, scaleY : scale},380,createjs.Ease.sineOut).to({ scaleX : co.doubleduck.BaseGame.getScale(), scaleY : co.doubleduck.BaseGame.getScale()},380,createjs.Ease.sineIn);
		}
	}
	,_numberToRoll: null
	,_casinoID: null
	,_ball: null
	,_scaledBall: null
	,_handleTop: null
	,_handle: null
	,_handleShadow: null
	,_handleBase: null
	,_numbers: null
	,_base: null
	,onSpinEnded: null
	,__class__: co.doubleduck.RouletteWheel
});
co.doubleduck.Session = $hxClasses["co.doubleduck.Session"] = function(properties) {
	this.CHIP_DURATION = 350;
	this._isRoundRigged = false;
	co.doubleduck.BaseSession.call(this);
	this._activeBets = [];
	this._placedChips = [];
	this._casinoId = properties.level;
	co.doubleduck.Session.lastCasinoId = this._casinoId;
	var bg = co.doubleduck.Utils.getCenteredImage("images/session/casinos/" + this._casinoId + "/bg.jpg",true);
	this.addChild(bg);
	bg.x = co.doubleduck.BaseGame.getViewport().width / 2;
	bg.y = co.doubleduck.BaseGame.getViewport().height / 2;
	this._betTable = new co.doubleduck.BetTable(this._casinoId);
	this._betTable.scaleX = this._betTable.scaleY = co.doubleduck.BaseGame.getScale();
	this.addChild(this._betTable);
	this._betTable.onTableClick = $bind(this,this.handleTableClick);
	this._betTable.y = co.doubleduck.BaseGame.getViewport().height - 10;
	this._betTable.x = 10;
	this._chipsContainer = new createjs.Container();
	this.addChild(this._chipsContainer);
	this._chipPack = new co.doubleduck.ChipPack(this._casinoId);
	this._ui = new co.doubleduck.UI(this._casinoId);
	this.addChild(this._ui);
	co.doubleduck.Utils.scaleObject(this._ui);
	this._ui.x = co.doubleduck.BaseGame.getViewport().width;
	this._ui.y = co.doubleduck.BaseGame.getViewport().height - 10;
	this._selectedChipValue = this._ui.getCurrVal();
	this._ui.onValueChanged = $bind(this,this.handleValueChanged);
	this._ui.onUndo = $bind(this,this.undoLastBet);
	this._lobbyBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/lobby_button.png"));
	this._lobbyBtn.x = 10 * co.doubleduck.BaseGame.getScale();
	co.doubleduck.Utils.scaleObject(this._lobbyBtn);
	this._lobbyBtn.onClick = $bind(this,this.handleBackToLobby);
	this.addChild(this._lobbyBtn);
	this._darkOverlay = new createjs.Shape();
	this._darkOverlay.graphics.beginFill("#000000");
	this._darkOverlay.graphics.drawRect(0,0,co.doubleduck.BaseGame.getViewport().width,co.doubleduck.BaseGame.getViewport().height);
	this._darkOverlay.graphics.endFill();
	this.addChild(this._darkOverlay);
	this._darkOverlay.alpha = 0;
	this._wheel = new co.doubleduck.RouletteWheel(this._casinoId);
	this._wheel.onSpinEnded = $bind(this,this.handleSpinDone);
	this.addChild(this._wheel);
	this._wheelPos = new createjs.Point(0,0);
	this._wheelPos.x = co.doubleduck.BaseGame.getViewport().width + this._wheel.getRadius() * co.doubleduck.BaseGame.getScale() * 0.3;
	this._wheelPos.y = -1 * (this._wheel.getRadius() * co.doubleduck.BaseGame.getScale() * 0.3);
	this._wheel.x = this._wheelPos.x;
	this._wheel.y = this._wheelPos.y;
	this._wheel.rotation += 360 / co.doubleduck.Session.numOrder.length;
	this._wheel.onClick = $bind(this,this.handleSpinClick);
	this._wheel.mouseEnabled = false;
	this._spinLabel = new co.doubleduck.SpinLabel();
	co.doubleduck.Utils.scaleObject(this._spinLabel);
	this.addChild(this._spinLabel);
	this._spinLabel.regX = this._spinLabel.image.width;
	this._spinLabel.x = this._wheel.x;
	this._spinLabel.y += this._wheel.y;
	this._hud = new co.doubleduck.HUD();
	this._hud.scaleX = this._hud.scaleY = co.doubleduck.BaseGame.getScale();
	this._hud.regX = this._hud.getWidth() / 2;
	this._hud.x = co.doubleduck.BaseGame.getViewport().width / 2;
	this.addChild(this._hud);
	this._hud.updateAll();
	co.doubleduck.SoundManager.playEffect("sound/casino_ambience");
	this.addChild(co.doubleduck.Transition.getInstance());
	co.doubleduck.Transition.transitionIn();
	this.checkFunds();
};
co.doubleduck.Session.__name__ = ["co","doubleduck","Session"];
co.doubleduck.Session.__super__ = co.doubleduck.BaseSession;
co.doubleduck.Session.prototype = $extend(co.doubleduck.BaseSession.prototype,{
	calculateRepAmount: function() {
		var betAmounts = [];
		var sumChances = 0;
		var _g = 0, _g1 = this._activeBets;
		while(_g < _g1.length) {
			var bet = _g1[_g];
			++_g;
			betAmounts.push(bet.getBetAmount());
			sumChances += 1 / bet.getRatio();
		}
		return Math.floor(Helper.average(betAmounts) / sumChances);
	}
	,updateRep: function(amount,delay,updateHud) {
		if(updateHud == null) updateHud = false;
		if(delay == null) delay = 0;
		var casinoData = co.doubleduck.DataLoader.getCasinoById(this._casinoId);
		var amountMin = casinoData.bets[0];
		var amountMax = js.Boot.__cast(casinoData.bets[2] , Int) * 36;
		var xpMin = casinoData.xpRangeMin;
		var xpMax = casinoData.xpRangeMax;
		amount = Math.floor(co.doubleduck.Utils.map(amount,amountMin,amountMax,xpMin,xpMax));
		co.doubleduck.Persistence.setPlayerRep(co.doubleduck.Persistence.getPlayerRep() + amount);
		if(updateHud) co.doubleduck.Utils.waitAndCall(null,delay,($_=this._hud,$bind($_,$_.updateReputation)));
	}
	,updateMoney: function(amount,delay) {
		if(delay == null) delay = 0;
		co.doubleduck.Persistence.setPlayerMoney(co.doubleduck.Persistence.getPlayerMoney() + amount);
		co.doubleduck.Utils.waitAndCall(null,delay,($_=this._hud,$bind($_,$_.updateMoney)));
	}
	,enableInteraction: function(bool) {
		this._betTable.mouseEnabled = bool;
		this._ui.mouseEnabled = bool;
		this._lobbyBtn.mouseEnabled = bool;
		if(bool == false) {
			this._hud.mouseEnabled = false;
			createjs.Tween.get(this._hud).to({ y : this._hud.y - this._hud.getHeight(), alpha : 0},800);
		} else {
			this._hud.mouseEnabled = true;
			createjs.Tween.get(this._hud).to({ y : this._hud.y + this._hud.getHeight(), alpha : 1},800).call(($_=this._hud,$bind($_,$_.updateReputation)));
		}
	}
	,toggleDarkOverlay: function() {
		var maxAlpha = 0.8;
		if(this._darkOverlay.alpha == 0) createjs.Tween.get(this._darkOverlay).to({ alpha : maxAlpha},this.CHIP_DURATION); else if(this._darkOverlay.alpha == maxAlpha) createjs.Tween.get(this._darkOverlay).to({ alpha : 0},this.CHIP_DURATION);
	}
	,getPlayerLocation: function() {
		var x = co.doubleduck.BaseGame.getViewport().width / 2 + Std.random(200);
		var y = co.doubleduck.BaseGame.getViewport().height;
		return new createjs.Point(x,y);
	}
	,undoLastBet: function() {
		if(this._activeBets.length == 0) return; else if(this._activeBets.length == 1) {
			this._wheel.mouseEnabled = false;
			createjs.Tween.get(this._spinLabel).to({ alpha : 0},this.CHIP_DURATION);
		}
		co.doubleduck.SoundManager.playEffect("sound/chip_remove");
		this.updateMoney(this._activeBets[this._activeBets.length - 1].getBetAmount());
		this._activeBets[this._activeBets.length - 1].clearBet();
		this._activeBets.pop();
		var chip = this._placedChips[this._placedChips.length - 1];
		this._placedChips.pop();
		createjs.Tween.get(chip).to({ x : this.getPlayerLocation().x, y : this.getPlayerLocation().y},this.CHIP_DURATION,createjs.Ease.sineIn).call(($_=this._chipsContainer,$bind($_,$_.removeChild)),[chip]);
		this.checkFunds();
	}
	,handleNotEnoughFunds: function() {
		null;
	}
	,checkFunds: function() {
		var values = co.doubleduck.DataLoader.getCasinoById(this._casinoId).bets;
		var _g1 = 0, _g = values.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(co.doubleduck.Persistence.getPlayerMoney() < values[i]) this._ui.deactivateChip(i); else this._ui.activateChip(i);
		}
	}
	,handleTableClick: function(cell) {
		var currFunds = co.doubleduck.Persistence.getPlayerMoney();
		if(this._selectedChipValue > currFunds) {
			this.handleNotEnoughFunds();
			return;
		}
		if(Lambda.indexOf(this._activeBets,cell) == -1) this._activeBets.push(cell); else return;
		co.doubleduck.SoundManager.playEffect("sound/chip_place");
		cell.placeBet(this._selectedChipValue);
		if(this._isRoundRigged) this._nextRiggedStop = co.doubleduck.Bet.betValueToInt(cell.getValue()[Std.random(cell.getValue().length)]);
		var chip = this._chipPack.getChip(this._selectedChipValue);
		co.doubleduck.Utils.scaleObject(chip);
		this._chipsContainer.addChild(chip);
		chip.x = this.getPlayerLocation().x;
		chip.y = this.getPlayerLocation().y;
		this._placedChips.push(chip);
		var cellPos = this._betTable.localToGlobal(cell.x,cell.y);
		var cellHeight = cell.getHeight() * co.doubleduck.BaseGame.getScale();
		var cellWidth = cell.getWidth() * co.doubleduck.BaseGame.getScale();
		var cellCenter = new createjs.Point(cellPos.x + cellWidth / 2,cellPos.y + cellHeight / 2);
		var offset = new createjs.Point(Std.random(Math.floor(cellWidth / 3.8)) * (Math.random() * 2 - 1),Std.random(Math.floor(cellHeight / 3.8)) * (Math.random() * 2 - 1));
		var nextX = cellCenter.x + offset.x;
		var nextY = cellCenter.y + offset.y;
		var dist = Helper.getDistance(new createjs.Point(chip.x,chip.y),new createjs.Point(nextX,nextY));
		createjs.Tween.get(chip).to({ x : nextX, y : nextY},dist * 1.2,createjs.Ease.sineOut).call(($_=this._spinLabel,$bind($_,$_.labelHeartbeat)),[this._placedChips.length]);
		this.updateMoney(-this._selectedChipValue);
		this._wheel.mouseEnabled = true;
		createjs.Tween.get(this._spinLabel).to({ alpha : 1},this.CHIP_DURATION);
		this.checkFunds();
	}
	,animateWin: function(chip) {
		createjs.Tween.get(chip).wait(Std.random(200) + 50).call($bind(chip,chip.flip),[1,500]).to({ scaleX : chip.scaleX * 2.3, scaleY : chip.scaleY * 2.3},500,createjs.Ease.sineOut).call($bind(chip,chip.flip),[2,500]).to({ scaleX : chip.scaleX * 2.8, scaleY : chip.scaleY * 2.8},1000,createjs.Ease.sineOut).call($bind(chip,chip.flip),[1,500]).to({ scaleX : chip.scaleX, scaleY : chip.scaleY},500,createjs.Ease.sineIn).wait(200).to({ x : this.getPlayerLocation().x, y : this.getPlayerLocation().y},this.CHIP_DURATION,createjs.Ease.sineIn).call(($_=this._chipsContainer,$bind($_,$_.removeChild)),[chip]);
	}
	,showWinMessage: function(amountToPay) {
		var message = new co.doubleduck.WinMessage(amountToPay,co.doubleduck.WinMessage.decideMega(amountToPay,this._casinoId));
		this.addChild(message);
		co.doubleduck.Utils.scaleObject(message);
		message.x = co.doubleduck.BaseGame.getViewport().width / 2;
		message.y = co.doubleduck.BaseGame.getViewport().height / 2;
		message.alpha = 0;
		var currScale = message.scaleX;
		message.scaleX = message.scaleY = 0;
		message.rotation = 20;
		createjs.Tween.get(message).to({ scaleX : currScale, scaleY : currScale, rotation : 0, alpha : 1},500,createjs.Ease.sineOut).wait(200).call($bind(message,message.showAmount)).wait(2000).to({ scaleX : 0, scaleY : 0, rotation : 10, alpha : 0},500,createjs.Ease.sineIn).call($bind(this,this.removeChild),[message]);
	}
	,payBets: function(result) {
		var amountToPay = 0;
		var _g1 = 0, _g = this._activeBets.length;
		while(_g1 < _g) {
			var i = _g1++;
			var bet = this._activeBets[i];
			var chip = this._placedChips[i];
			if(bet.matches(result)) {
				amountToPay += bet.payOff();
				this.animateWin(chip);
			} else createjs.Tween.get(chip).wait(Std.random(150) + 50).to({ x : -100, y : -100},this.CHIP_DURATION,createjs.Ease.sineIn).call(($_=this._chipsContainer,$bind($_,$_.removeChild)),[chip]);
		}
		if(amountToPay > 0) {
			this.updateMoney(amountToPay);
			this.showWinMessage(amountToPay);
		}
		this._betTable.clearBets();
		this._placedChips = [];
		this._activeBets = [];
		this.enableInteraction(true);
		this._nextRiggedStop = null;
		this.checkFunds();
	}
	,handleSpinDone: function(result) {
		createjs.Tween.get(this._wheel).to({ x : this._wheelPos.x, y : this._wheelPos.y},600,createjs.Ease.sineInOut).call($bind(this,this.payBets),[result]);
		this.toggleDarkOverlay();
	}
	,handleSpinClick: function() {
		createjs.Tween.get(this._wheel).to({ x : co.doubleduck.BaseGame.getViewport().width / 2, y : co.doubleduck.BaseGame.getViewport().height / 2},600,createjs.Ease.sineInOut).call(($_=this._wheel,$bind($_,$_.spin)),[this._nextRiggedStop]);
		this.enableInteraction(false);
		this._wheel.mouseEnabled = false;
		createjs.Tween.get(this._spinLabel).to({ alpha : 0},this.CHIP_DURATION);
		this.updateRep(this.calculateRepAmount());
		this.toggleDarkOverlay();
	}
	,handleValueChanged: function(val) {
		this._selectedChipValue = val;
	}
	,handleBackToLobby: function() {
		if(this.onBackToMenu != null) {
			this._lobbyBtn.onClick = null;
			var refund = 0;
			var _g = 0, _g1 = this._activeBets;
			while(_g < _g1.length) {
				var bet = _g1[_g];
				++_g;
				refund += bet.getBetAmount();
			}
			co.doubleduck.Persistence.setPlayerMoney(co.doubleduck.Persistence.getPlayerMoney() + refund);
			co.doubleduck.Transition.transitionOut(this.onBackToMenu);
		}
	}
	,CHIP_DURATION: null
	,_casinoId: null
	,_isRoundRigged: null
	,_wheelPos: null
	,_chipPack: null
	,_nextRiggedStop: null
	,_selectedChipValue: null
	,_placedChips: null
	,_activeBets: null
	,_hud: null
	,_lobbyBtn: null
	,_darkOverlay: null
	,_spinLabel: null
	,_ui: null
	,_wheel: null
	,_chipsContainer: null
	,_betTable: null
	,__class__: co.doubleduck.Session
});
co.doubleduck.SoundType = $hxClasses["co.doubleduck.SoundType"] = { __ename__ : ["co","doubleduck","SoundType"], __constructs__ : ["WEB_AUDIO","AUDIO_FX","AUDIO_NO_OVERLAP","HOWLER","NONE"] }
co.doubleduck.SoundType.WEB_AUDIO = ["WEB_AUDIO",0];
co.doubleduck.SoundType.WEB_AUDIO.toString = $estr;
co.doubleduck.SoundType.WEB_AUDIO.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.AUDIO_FX = ["AUDIO_FX",1];
co.doubleduck.SoundType.AUDIO_FX.toString = $estr;
co.doubleduck.SoundType.AUDIO_FX.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.AUDIO_NO_OVERLAP = ["AUDIO_NO_OVERLAP",2];
co.doubleduck.SoundType.AUDIO_NO_OVERLAP.toString = $estr;
co.doubleduck.SoundType.AUDIO_NO_OVERLAP.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.HOWLER = ["HOWLER",3];
co.doubleduck.SoundType.HOWLER.toString = $estr;
co.doubleduck.SoundType.HOWLER.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.NONE = ["NONE",4];
co.doubleduck.SoundType.NONE.toString = $estr;
co.doubleduck.SoundType.NONE.__enum__ = co.doubleduck.SoundType;
if(!co.doubleduck.audio) co.doubleduck.audio = {}
co.doubleduck.audio.AudioAPI = $hxClasses["co.doubleduck.audio.AudioAPI"] = function() { }
co.doubleduck.audio.AudioAPI.__name__ = ["co","doubleduck","audio","AudioAPI"];
co.doubleduck.audio.AudioAPI.prototype = {
	setVolume: null
	,pause: null
	,stop: null
	,playMusic: null
	,playEffect: null
	,init: null
	,__class__: co.doubleduck.audio.AudioAPI
}
co.doubleduck.audio.WebAudioAPI = $hxClasses["co.doubleduck.audio.WebAudioAPI"] = function(src) {
	this._src = src;
	this.loadAudioFile(this._src);
};
co.doubleduck.audio.WebAudioAPI.__name__ = ["co","doubleduck","audio","WebAudioAPI"];
co.doubleduck.audio.WebAudioAPI.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.WebAudioAPI.context = null;
co.doubleduck.audio.WebAudioAPI.webAudioInit = function() {
	co.doubleduck.audio.WebAudioAPI.context = new webkitAudioContext();
}
co.doubleduck.audio.WebAudioAPI.saveBuffer = function(buffer,name) {
	co.doubleduck.audio.WebAudioAPI._buffers[name] = buffer;
}
co.doubleduck.audio.WebAudioAPI.decodeError = function() {
	null;
}
co.doubleduck.audio.WebAudioAPI.prototype = {
	setVolume: function(volume) {
		if(this._gainNode != null) this._gainNode.gain.value = volume;
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		if(this._source != null) this._source.noteOff(0);
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
		this.playBuffer(this._src,loop);
		this.setVolume(volume);
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		this.playBuffer(this._src,loop);
		this.setVolume(volume);
	}
	,playBuffer: function(name,loop) {
		if(loop == null) loop = false;
		if(this._gainNode == null) {
			this._gainNode = co.doubleduck.audio.WebAudioAPI.context.createGainNode();
			this._gainNode.connect(co.doubleduck.audio.WebAudioAPI.context.destination);
		}
		this._buffer = Reflect.getProperty(co.doubleduck.audio.WebAudioAPI._buffers,this._src);
		if(this._buffer == null) return;
		this._source = co.doubleduck.audio.WebAudioAPI.context.createBufferSource();
		this._source.buffer = this._buffer;
		this._source.loop = loop;
		this._source.connect(this._gainNode);
		this._source.noteOn(0);
	}
	,loadAudioFile: function(src) {
		var request = new XMLHttpRequest();
		request.open("get",src,true);
		request.responseType = "arraybuffer";
		request.onload = function() { co.doubleduck.audio.WebAudioAPI.context.decodeAudioData(request.response, function(decodedBuffer) { buffer = decodedBuffer; co.doubleduck.audio.WebAudioAPI.saveBuffer(buffer,src); }, co.doubleduck.audio.WebAudioAPI.decodeError) }
		request.send();
	}
	,init: function() {
	}
	,_source: null
	,_gainNode: null
	,_buffer: null
	,_src: null
	,__class__: co.doubleduck.audio.WebAudioAPI
}
co.doubleduck.SoundManager = $hxClasses["co.doubleduck.SoundManager"] = function() {
};
co.doubleduck.SoundManager.__name__ = ["co","doubleduck","SoundManager"];
co.doubleduck.SoundManager.engineType = null;
co.doubleduck.SoundManager.EXTENSION = null;
co.doubleduck.SoundManager.getPersistedMute = function() {
	var mute = co.doubleduck.BasePersistence.getValue("mute");
	if(mute == "0") {
		mute = "false";
		co.doubleduck.SoundManager.setPersistedMute(false);
	}
	return mute == "true";
}
co.doubleduck.SoundManager.setPersistedMute = function(mute) {
	var val = "true";
	if(!mute) val = "false";
	co.doubleduck.BasePersistence.setValue("mute",val);
}
co.doubleduck.SoundManager.isSoundAvailable = function() {
	var isFirefox = /Firefox/.test(navigator.userAgent);
	var isChrome = /Chrome/.test(navigator.userAgent);
	var isMobile = /Mobile/.test(navigator.userAgent);
	var isAndroid = /Android/.test(navigator.userAgent);
	var isAndroid4 = /Android 4/.test(navigator.userAgent);
	var isSafari = /Safari/.test(navigator.userAgent);
	var agent = navigator.userAgent;
	var reg = new EReg("iPhone OS 6","");
	var isIOS6 = reg.match(agent) && isSafari && isMobile;
	var isIpad = /iPad/.test(navigator.userAgent);
	isIpad = isIpad && /OS 6/.test(navigator.userAgent);
	isIOS6 = isIOS6 || isIpad;
	if(isFirefox) {
		co.doubleduck.SoundManager.engineType = co.doubleduck.SoundType.AUDIO_FX;
		co.doubleduck.SoundManager.EXTENSION = ".ogg";
		return true;
	}
	if(isChrome && (!isAndroid && !isMobile)) {
		co.doubleduck.SoundManager.engineType = co.doubleduck.SoundType.WEB_AUDIO;
		co.doubleduck.audio.WebAudioAPI.webAudioInit();
		co.doubleduck.SoundManager.EXTENSION = ".ogg";
		return true;
	}
	co.doubleduck.SoundManager.engineType = co.doubleduck.SoundType.NONE;
	co.doubleduck.BasePersistence.initVar("mute");
	return false;
}
co.doubleduck.SoundManager.mute = function(persisted) {
	if(persisted == null) persisted = true;
	if(!co.doubleduck.SoundManager.available) return;
	co.doubleduck.SoundManager._muted = true;
	var _g1 = 0, _g = Reflect.fields(co.doubleduck.SoundManager._cache).length;
	while(_g1 < _g) {
		var currSound = _g1++;
		var mySound = Reflect.getProperty(co.doubleduck.SoundManager._cache,Reflect.fields(co.doubleduck.SoundManager._cache)[currSound]);
		if(mySound != null) mySound.setVolume(0);
	}
	if(persisted) co.doubleduck.SoundManager.setPersistedMute(co.doubleduck.SoundManager._muted);
}
co.doubleduck.SoundManager.unmute = function(persisted) {
	if(persisted == null) persisted = true;
	if(!co.doubleduck.SoundManager.available) return;
	co.doubleduck.SoundManager._muted = false;
	try {
		var _g1 = 0, _g = Reflect.fields(co.doubleduck.SoundManager._cache).length;
		while(_g1 < _g) {
			var currSound = _g1++;
			var mySound = Reflect.getProperty(co.doubleduck.SoundManager._cache,Reflect.fields(co.doubleduck.SoundManager._cache)[currSound]);
			if(mySound != null) mySound.setVolume(1);
		}
	} catch( e ) {
		null;
	}
	if(persisted) co.doubleduck.SoundManager.setPersistedMute(co.doubleduck.SoundManager._muted);
}
co.doubleduck.SoundManager.toggleMute = function() {
	if(co.doubleduck.SoundManager._muted) co.doubleduck.SoundManager.unmute(); else co.doubleduck.SoundManager.mute();
}
co.doubleduck.SoundManager.isMuted = function() {
	co.doubleduck.SoundManager._muted = co.doubleduck.SoundManager.getPersistedMute();
	return co.doubleduck.SoundManager._muted;
}
co.doubleduck.SoundManager.getAudioInstance = function(src) {
	if(!co.doubleduck.SoundManager.available) return new co.doubleduck.audio.DummyAudioAPI();
	src += co.doubleduck.SoundManager.EXTENSION;
	var audio = Reflect.getProperty(co.doubleduck.SoundManager._cache,src);
	if(audio == null) {
		switch( (co.doubleduck.SoundManager.engineType)[1] ) {
		case 1:
			audio = new co.doubleduck.audio.AudioFX(src);
			break;
		case 0:
			audio = new co.doubleduck.audio.WebAudioAPI(src);
			break;
		case 2:
			audio = new co.doubleduck.audio.NonOverlappingAudio(src);
			break;
		case 3:
			audio = new co.doubleduck.audio.HowlerAudio(src);
			break;
		case 4:
			return new co.doubleduck.audio.DummyAudioAPI();
		}
		Reflect.setProperty(co.doubleduck.SoundManager._cache,src,audio);
	}
	return audio;
}
co.doubleduck.SoundManager.playEffect = function(src,volume,optional) {
	if(optional == null) optional = false;
	if(volume == null) volume = 1;
	if(optional && co.doubleduck.SoundManager.engineType == co.doubleduck.SoundType.AUDIO_NO_OVERLAP) return new co.doubleduck.audio.DummyAudioAPI();
	var audio = co.doubleduck.SoundManager.getAudioInstance(src);
	var playVolume = volume;
	if(co.doubleduck.SoundManager._muted) playVolume = 0;
	audio.playEffect(playVolume);
	return audio;
}
co.doubleduck.SoundManager.playMusic = function(src,volume,loop) {
	if(loop == null) loop = true;
	if(volume == null) volume = 1;
	var audio = co.doubleduck.SoundManager.getAudioInstance(src);
	var playVolume = volume;
	if(co.doubleduck.SoundManager._muted) playVolume = 0;
	audio.playMusic(playVolume,loop);
	return audio;
}
co.doubleduck.SoundManager.initSound = function(src) {
	co.doubleduck.SoundManager.getAudioInstance(src);
}
co.doubleduck.SoundManager.prototype = {
	__class__: co.doubleduck.SoundManager
}
co.doubleduck.SpinLabel = $hxClasses["co.doubleduck.SpinLabel"] = function() {
	createjs.Container.call(this);
	this.alpha = 0;
	this.mouseEnabled = false;
	this._label = co.doubleduck.BaseAssets.getImage("images/session/spin.png");
	this._glow = co.doubleduck.BaseAssets.getImage("images/session/spin_glow.png");
	this.image = this._label.image;
	this.addChild(this._label);
	this.addChild(this._glow);
	this._glow.alpha = 0;
};
co.doubleduck.SpinLabel.__name__ = ["co","doubleduck","SpinLabel"];
co.doubleduck.SpinLabel.__super__ = createjs.Container;
co.doubleduck.SpinLabel.prototype = $extend(createjs.Container.prototype,{
	labelHeartbeat: function(num) {
		if(this.alpha == 0 || num > 1) return;
		var modifier = 1.2;
		createjs.Tween.get(this._glow).to({ alpha : 1},600,createjs.Ease.sineOut).to({ alpha : 0},600,createjs.Ease.sineIn).wait(300).call($bind(this,this.labelHeartbeat),[num]);
	}
	,image: null
	,_glow: null
	,_label: null
	,__class__: co.doubleduck.SpinLabel
});
co.doubleduck.Transition = $hxClasses["co.doubleduck.Transition"] = function() {
	createjs.Container.call(this);
	if(co.doubleduck.Transition._allowInstantiation == false) return;
	this.name = "Transition";
	this._blackOverlay = new createjs.Shape();
	this._blackOverlay.graphics.beginFill("#000000");
	this._blackOverlay.graphics.drawRect(0,0,co.doubleduck.BaseGame.getViewport().width,co.doubleduck.BaseGame.getViewport().height);
	this._blackOverlay.graphics.endFill();
	this.addChild(this._blackOverlay);
	this._blackOverlay.alpha = 0;
};
co.doubleduck.Transition.__name__ = ["co","doubleduck","Transition"];
co.doubleduck.Transition._instance = null;
co.doubleduck.Transition.getInstance = function() {
	co.doubleduck.Transition._allowInstantiation = true;
	if(co.doubleduck.Transition._instance != null) return co.doubleduck.Transition._instance;
	var instance = new co.doubleduck.Transition();
	co.doubleduck.Transition._instance = instance;
	return instance;
}
co.doubleduck.Transition.transitionIn = function() {
	if(co.doubleduck.Transition._instance == null) return;
	co.doubleduck.Transition._instance._blackOverlay.alpha = 1;
	createjs.Tween.get(co.doubleduck.Transition._instance._blackOverlay).to({ alpha : 0},1000);
}
co.doubleduck.Transition.transitionOut = function(handler,params) {
	if(co.doubleduck.Transition._instance == null) return;
	co.doubleduck.Transition._instance._blackOverlay.alpha = 0;
	createjs.Tween.get(co.doubleduck.Transition._instance._blackOverlay).to({ alpha : 1},500).call(handler,params);
}
co.doubleduck.Transition.__super__ = createjs.Container;
co.doubleduck.Transition.prototype = $extend(createjs.Container.prototype,{
	_blackOverlay: null
	,__class__: co.doubleduck.Transition
});
co.doubleduck.UI = $hxClasses["co.doubleduck.UI"] = function(casinoId) {
	this._minScale = 0.8;
	this._minAlpha = 0.6;
	createjs.Container.call(this);
	this._casinoId = casinoId;
	this._values = co.doubleduck.DataLoader.getCasinoById(casinoId).bets;
	this.extractChips();
	this.regX = this._chipButtons[0].spriteSheet._frameWidth / 2;
	this.drawUI();
	this.changeVal(this._values[0]);
};
co.doubleduck.UI.__name__ = ["co","doubleduck","UI"];
co.doubleduck.UI.__super__ = createjs.Container;
co.doubleduck.UI.prototype = $extend(createjs.Container.prototype,{
	activateChip: function(index) {
		var chip = this._chipButtons[index];
		if(chip.mouseEnabled == false) {
			chip.mouseEnabled = true;
			var selectedChip = this._chipButtons[Lambda.indexOf(this._values,this._currVal)];
			if(chip == selectedChip) createjs.Tween.get(chip).to({ rotation : 1, scaleX : 1, scaleY : 1, alpha : 1},100,createjs.Ease.sineOut); else createjs.Tween.get(chip).to({ rotation : 10, scaleX : this._minScale, scaleY : this._minScale, alpha : this._minAlpha},100,createjs.Ease.sineOut);
		}
	}
	,deactivateChip: function(index) {
		var chip = this._chipButtons[index];
		createjs.Tween.removeTweens(chip);
		chip.mouseEnabled = false;
		chip.rotation = 10;
		chip.scaleX = chip.scaleY = this._minScale;
		chip.alpha = 0.3;
	}
	,extractChips: function() {
		this._chipButtons = [];
		var spritesheet;
		var imageUrl = "images/session/casinos/" + this._casinoId + "/chips_big.png";
		var image = co.doubleduck.BaseAssets.getImage(imageUrl).image;
		var w = image.width;
		var h = image.height;
		var chipSize;
		if(w > h) chipSize = h; else chipSize = w;
		var data = { images : [imageUrl], frames : { width : chipSize, height : chipSize}};
		spritesheet = new createjs.SpriteSheet(data);
		var _g1 = 0, _g = this._values.length;
		while(_g1 < _g) {
			var i = _g1++;
			var newButton = new createjs.BitmapAnimation(spritesheet);
			newButton.gotoAndStop(i);
			newButton.regX = newButton.spriteSheet._frameWidth / 2;
			newButton.regY = newButton.spriteSheet._frameHeight / 2;
			this._chipButtons.push(newButton);
		}
	}
	,changeVal: function(val) {
		if(this.onValueChanged != null) this.onValueChanged(val);
		var selectedChip = this._chipButtons[Lambda.indexOf(this._values,val)];
		if(selectedChip.alpha != 1) co.doubleduck.SoundManager.playEffect("sound/chip_select");
		var _g = 0, _g1 = this._chipButtons;
		while(_g < _g1.length) {
			var button = _g1[_g];
			++_g;
			if(button == selectedChip) createjs.Tween.get(button).to({ rotation : 1, scaleX : 1, scaleY : 1, alpha : 1},100,createjs.Ease.sineOut); else if(button.mouseEnabled) createjs.Tween.get(button).to({ rotation : 10, scaleX : this._minScale, scaleY : this._minScale, alpha : this._minAlpha},100,createjs.Ease.sineOut);
		}
		this._currVal = val;
	}
	,handleBtnClick: function(e) {
		var val = this._values[Std.parseInt(e.target.name)];
		this.changeVal(val);
	}
	,handleUndoClick: function() {
		if(this.onUndo != null) this.onUndo();
	}
	,drawUI: function() {
		var _g1 = 0, _g = this._chipButtons.length;
		while(_g1 < _g) {
			var i = _g1++;
			var button = this._chipButtons[i];
			this.addChild(button);
			button.y = button.spriteSheet._frameHeight * i;
			button.alpha = this._minAlpha;
			button.onClick = $bind(this,this.handleBtnClick);
			button.name = "" + i;
		}
		var undoBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/return_button.png"));
		this.addChild(undoBtn);
		undoBtn.y = this._chipButtons[this._chipButtons.length - 1].y + this._chipButtons[this._chipButtons.length - 1].spriteSheet._frameHeight;
		undoBtn.regX = undoBtn.image.width / 2;
		undoBtn.regY = undoBtn.image.height / 2;
		this.addChild(undoBtn);
		undoBtn.setNoSound();
		undoBtn.onClick = $bind(this,this.handleUndoClick);
		this.regY = undoBtn.y + undoBtn.image.height;
	}
	,getCurrVal: function() {
		return this._currVal;
	}
	,_minScale: null
	,_minAlpha: null
	,onUndo: null
	,onValueChanged: null
	,_currVal: null
	,_values: null
	,_chipButtons: null
	,_casinoId: null
	,__class__: co.doubleduck.UI
});
co.doubleduck.Utils = $hxClasses["co.doubleduck.Utils"] = function() { }
co.doubleduck.Utils.__name__ = ["co","doubleduck","Utils"];
co.doubleduck.Utils.dateDeltaInDays = function(day1,day2) {
	var delta = Math.abs(day2.getTime() - day1.getTime());
	return delta / 86400000;
}
co.doubleduck.Utils.getTodayDate = function() {
	var newDate = new Date();
	return HxOverrides.dateStr(newDate);
}
co.doubleduck.Utils.getHour = function() {
	var newDate = new Date();
	return newDate.getHours();
}
co.doubleduck.Utils.rectOverlap = function(r1,r2) {
	var r1TopLeft = new createjs.Point(r1.x,r1.y);
	var r1BottomRight = new createjs.Point(r1.x + r1.width,r1.y + r1.height);
	var r1TopRight = new createjs.Point(r1.x + r1.width,r1.y);
	var r1BottomLeft = new createjs.Point(r1.x,r1.y + r1.height);
	var r2TopLeft = new createjs.Point(r2.x,r2.y);
	var r2BottomRight = new createjs.Point(r2.x + r2.width,r2.y + r2.height);
	var r2TopRight = new createjs.Point(r2.x + r2.width,r2.y);
	var r2BottomLeft = new createjs.Point(r2.x,r2.y + r2.height);
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1BottomLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2BottomLeft)) return true;
	return false;
}
co.doubleduck.Utils.overlap = function(obj1,obj1Width,obj1Height,obj2,obj2Width,obj2Height) {
	var o1TopLeft = new createjs.Point(obj1.x - obj1.regX * co.doubleduck.BaseGame.getScale(),obj1.y - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o1BottomRight = new createjs.Point(o1TopLeft.x - obj1.regX * co.doubleduck.BaseGame.getScale() + obj1Width * co.doubleduck.BaseGame.getScale(),o1TopLeft.y + obj1Height * co.doubleduck.BaseGame.getScale() - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o1TopRight = new createjs.Point(o1BottomRight.x - obj1.regX * co.doubleduck.BaseGame.getScale(),o1TopLeft.y - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o1BottomLeft = new createjs.Point(o1TopLeft.x - obj1.regX * co.doubleduck.BaseGame.getScale(),o1BottomRight.y - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o2TopLeft = new createjs.Point(obj2.x - obj2.regX * co.doubleduck.BaseGame.getScale(),obj2.y - obj2.regY * co.doubleduck.BaseGame.getScale());
	var o2BottomRight = new createjs.Point(o2TopLeft.x + obj2Width * co.doubleduck.BaseGame.getScale() - obj2.regX * co.doubleduck.BaseGame.getScale(),o2TopLeft.y + obj2Height * co.doubleduck.BaseGame.getScale() - obj2.regY * co.doubleduck.BaseGame.getScale());
	var o2TopRight = new createjs.Point(o2BottomRight.x - obj2.regX * co.doubleduck.BaseGame.getScale(),o2TopLeft.y - obj2.regY * co.doubleduck.BaseGame.getScale());
	var o2BottomLeft = new createjs.Point(o2TopLeft.x - obj2.regX * co.doubleduck.BaseGame.getScale(),o2BottomRight.y - obj2.regY * co.doubleduck.BaseGame.getScale());
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1BottomLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2BottomLeft)) return true;
	return false;
}
co.doubleduck.Utils.rectContainPoint = function(rectTopLeft,rectBottomRight,point) {
	return point.x >= rectTopLeft.x && point.x <= rectBottomRight.x && point.y >= rectTopLeft.y && point.y <= rectBottomRight.y;
}
co.doubleduck.Utils.objectContains = function(dyn,memberName) {
	return Reflect.hasField(dyn,memberName);
}
co.doubleduck.Utils.contains = function(arr,obj) {
	var _g = 0;
	while(_g < arr.length) {
		var element = arr[_g];
		++_g;
		if(element == obj) return true;
	}
	return false;
}
co.doubleduck.Utils.isMobileFirefox = function() {
	var isFirefox = /Firefox/.test(navigator.userAgent);
	return isFirefox && viewporter.ACTIVE;
}
co.doubleduck.Utils.get = function(x,y,tiles,columns) {
	return tiles[columns * y + x];
}
co.doubleduck.Utils.getBitmapLabel = function(label,fontType,padding) {
	if(padding == null) padding = 0;
	if(fontType == null) fontType = "";
	var fontHelper = new co.doubleduck.FontHelper(fontType);
	var bitmapText = fontHelper.getNumber(Std.parseInt(label),1,true,null,padding);
	return bitmapText;
}
co.doubleduck.Utils.concatWithoutDuplicates = function(array,otherArray) {
	var _g = 0;
	while(_g < otherArray.length) {
		var element = otherArray[_g];
		++_g;
		co.doubleduck.Utils.addToArrayWithoutDuplicates(array,element);
	}
	return array;
}
co.doubleduck.Utils.addToArrayWithoutDuplicates = function(array,element) {
	var _g = 0;
	while(_g < array.length) {
		var currElement = array[_g];
		++_g;
		if(currElement == element) return array;
	}
	array.push(element);
	return array;
}
co.doubleduck.Utils.getImageData = function(image) {
	var ctx = co.doubleduck.Utils.getCanvasContext();
	var img = co.doubleduck.BaseAssets.getImage(image);
	ctx.drawImage(img.image,0,0);
	return ctx.getImageData(0,0,img.image.width,img.image.height);
}
co.doubleduck.Utils.getCanvasContext = function() {
	var dom = js.Lib.document.createElement("Canvas");
	var canvas = dom;
	return canvas.getContext("2d");
}
co.doubleduck.Utils.joinArrays = function(a1,a2) {
	var arr = a1.slice();
	var _g = 0;
	while(_g < a2.length) {
		var el = a2[_g];
		++_g;
		arr.push(el);
	}
	return arr;
}
co.doubleduck.Utils.getRandomElement = function(arr) {
	return arr[Std.random(arr.length)];
}
co.doubleduck.Utils.splitArray = function(arr,parts) {
	var arrs = new Array();
	var _g = 0;
	while(_g < parts) {
		var p = _g++;
		arrs.push(new Array());
	}
	var currArr = 0;
	while(arr.length > 0) {
		arrs[currArr].push(arr.pop());
		currArr++;
		currArr %= parts;
	}
	return arrs;
}
co.doubleduck.Utils.map = function(value,aMin,aMax,bMin,bMax) {
	if(bMax == null) bMax = 1;
	if(bMin == null) bMin = 0;
	if(value <= aMin) return bMin;
	if(value >= aMax) return bMax;
	return (value - aMin) * (bMax - bMin) / (aMax - aMin) + bMin;
}
co.doubleduck.Utils.waitAndCall = function(parent,delay,func,args) {
	createjs.Tween.get(parent).wait(delay).call(func,args);
}
co.doubleduck.Utils.tintBitmap = function(src,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
	var colorFilter = new createjs.ColorFilter(redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
	src.cache(src.x,src.y,src.image.width,src.image.height);
	src.filters = [colorFilter];
	src.updateCache();
}
co.doubleduck.Utils.containBitmaps = function(bitmapList,spacing,isRow,dims) {
	if(isRow == null) isRow = true;
	if(spacing == null) spacing = 0;
	var totalWidth = 0;
	var totalHeight = 0;
	var result = new createjs.Container();
	var _g1 = 0, _g = bitmapList.length;
	while(_g1 < _g) {
		var currBitmap = _g1++;
		var bmp = bitmapList[currBitmap];
		bmp.regY = bmp.image.height / 2;
		if(currBitmap != 0) {
			if(isRow) {
				bmp.x = bitmapList[currBitmap - 1].x + bitmapList[currBitmap - 1].image.width + spacing;
				if(bmp.image.height > totalHeight) totalHeight = bmp.image.height;
				totalWidth += bmp.image.width + spacing;
			} else {
				bmp.y = bitmapList[currBitmap - 1].y + bitmapList[currBitmap - 1].image.height + spacing;
				if(bmp.image.width > totalWidth) totalWidth = bmp.image.width;
				totalHeight += bmp.image.height + spacing;
			}
		} else {
			totalWidth = bmp.image.width;
			totalHeight = bmp.image.height;
		}
		result.addChild(bmp);
	}
	result.regX = totalWidth / 2;
	result.regY = totalHeight / 2;
	if(dims != null) {
		dims.width = totalWidth;
		dims.height = totalHeight;
	}
	return result;
}
co.doubleduck.Utils.getCenteredImage = function(name,scaleToGame) {
	if(scaleToGame == null) scaleToGame = false;
	var img = co.doubleduck.BaseAssets.getImage(name);
	img.regX = img.image.width / 2;
	img.regY = img.image.height / 2;
	if(scaleToGame) img.scaleX = img.scaleY = co.doubleduck.BaseGame.getScale();
	return img;
}
co.doubleduck.Utils.setCenterReg = function(bmp) {
	bmp.regX = bmp.image.width / 2;
	bmp.regY = bmp.image.height / 2;
}
co.doubleduck.Utils.shuffleArray = function(arr) {
	var tmp, j, i = arr.length;
	while(i > 0) {
		j = Math.random() * i | 0;
		tmp = arr[--i];
		arr[i] = arr[j];
		arr[j] = tmp;
	}
}
co.doubleduck.Utils.scaleObject = function(obj) {
	obj.scaleX = obj.scaleY = co.doubleduck.BaseGame.getScale();
}
co.doubleduck.Utils.getRectangle = function(rect,color) {
	var ret = new createjs.Shape();
	ret.graphics.beginFill(color);
	ret.graphics.drawRect(rect.x,rect.y,rect.width,rect.height);
	ret.graphics.endFill();
	return ret;
}
co.doubleduck.Utils.getDistance = function(p1,p2) {
	var distX = p1.x - p2.x;
	var distY = p1.y - p2.y;
	var dist = Math.sqrt(distX * distX + distY * distY);
	return dist;
}
co.doubleduck.Utils.average = function(arr) {
	var sum = 0;
	var _g = 0;
	while(_g < arr.length) {
		var i = arr[_g];
		++_g;
		sum += i;
	}
	return sum / arr.length;
}
co.doubleduck.Utils.radToDeg = function(rad) {
	return rad * 180 / Math.PI;
}
co.doubleduck.Utils.degToRad = function(deg) {
	return deg * Math.PI / 180;
}
co.doubleduck.Utils.sign = function(num) {
	if(num < 0) return -1; else if(num > 0) return 1;
	return 0;
}
co.doubleduck.Utils.loadSpriteSheet = function(imgPath,numberOfFrames,animName,animFrequency,centerReg) {
	if(centerReg == null) centerReg = true;
	if(animFrequency == null) animFrequency = 1;
	var ret;
	var data = { };
	var img = co.doubleduck.BaseAssets.getRawImage(imgPath);
	var numFrames = numberOfFrames;
	var imageHeight = 0;
	var imageWidth = 0;
	if(img.width > img.height) {
		imageWidth = img.width / numFrames;
		imageHeight = img.height;
	} else {
		imageHeight = img.height / numFrames;
		imageWidth = img.width;
	}
	if(centerReg) data.frames = { width : imageWidth, height : imageHeight, regX : imageWidth / 2, regY : imageHeight / 2}; else data.frames = { width : imageWidth, height : imageHeight};
	data.images = [img];
	data.animations = { };
	var framesArr = [];
	var _g = 0;
	while(_g < numFrames) {
		var i = _g++;
		framesArr.push(i);
	}
	data[animName] = { frames : framesArr, frequency : 5};
	ret = new createjs.SpriteSheet(data);
	return ret;
}
co.doubleduck.WinMessage = $hxClasses["co.doubleduck.WinMessage"] = function(amount,isMega) {
	if(isMega == null) isMega = false;
	createjs.Container.call(this);
	this._amount = amount;
	this._isMega = isMega;
	if(co.doubleduck.WinMessage.fh == null) co.doubleduck.WinMessage.fh = new co.doubleduck.FontHelper(co.doubleduck.WinMessage.FILE_PATH);
	var fileName = "win";
	if(this._isMega) {
		fileName = "mega_win";
		co.doubleduck.SoundManager.playEffect("sound/chip_win_big");
	} else co.doubleduck.SoundManager.playEffect("sound/chip_win_small");
	this._title = co.doubleduck.Utils.getCenteredImage(co.doubleduck.WinMessage.FILE_PATH + fileName + ".png",false);
	this.addChild(this._title);
};
co.doubleduck.WinMessage.__name__ = ["co","doubleduck","WinMessage"];
co.doubleduck.WinMessage.fh = null;
co.doubleduck.WinMessage.decideMega = function(amount,casinoId) {
	var bets = co.doubleduck.DataLoader.getCasinoById(casinoId).bets;
	var maxBet = bets[bets.length - 1];
	if(amount >= maxBet * 36 * 0.5) return true;
	return false;
}
co.doubleduck.WinMessage.__super__ = createjs.Container;
co.doubleduck.WinMessage.prototype = $extend(createjs.Container.prototype,{
	emphasizeTitle: function(index) {
		if(index != this._number.getNumChildren() - 1) return;
		var maxScale = 1.5;
		createjs.Tween.get(this._title).to({ scaleX : this._title.scaleX * maxScale, scaleY : this._title.scaleY * maxScale, y : this._title.y - 20},200,createjs.Ease.sineOut).to({ scaleX : this._title.scaleX, scaleY : this._title.scaleY, y : this._title.y},200,createjs.Ease.sineOut);
	}
	,showAmount: function() {
		var rect = new createjs.Rectangle(0,0,0,0);
		this._number = co.doubleduck.WinMessage.fh.getNumber(this._amount,1,true,rect,-5,true);
		this.addChild(this._number);
		this._number.y = this._title.image.height * 0.5 + rect.height * 0.5;
		this._number.y += rect.height / 2;
		var _g1 = 0, _g = this._number.getNumChildren();
		while(_g1 < _g) {
			var i = _g1++;
			var child = this._number.getChildAt(i);
			child.alpha = 0;
			child.regX = child.image.width / 2;
			child.regY = child.image.height / 2;
			child.x += child.image.width / 2;
			child.scaleX = child.scaleY = 0;
			createjs.Tween.get(child).wait(100 * i).to({ alpha : 1, scaleX : 1.2, scaleY : 1.2, y : child.y + 20},150,createjs.Ease.sineOut).to({ scaleX : 1, scaleY : 1, y : child.y},150,createjs.Ease.sineOut).call($bind(this,this.emphasizeTitle),[i]).wait(1500).to({ scaleX : 1.2, scaleY : 1.2, y : child.y - 20},150,createjs.Ease.sineOut).to({ alpha : 0, scaleX : 0, scaleY : 0, y : child.y},150 * i,createjs.Ease.sineOut);
		}
	}
	,_number: null
	,_title: null
	,_isMega: null
	,_amount: null
	,__class__: co.doubleduck.WinMessage
});
co.doubleduck.audio.AudioFX = $hxClasses["co.doubleduck.audio.AudioFX"] = function(src) {
	this._jsAudio = null;
	this._src = src;
	this._loop = false;
	this._volume = 1;
};
co.doubleduck.audio.AudioFX.__name__ = ["co","doubleduck","audio","AudioFX"];
co.doubleduck.audio.AudioFX.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.AudioFX._currentlyPlaying = null;
co.doubleduck.audio.AudioFX.prototype = {
	setVolume: function(volume) {
		this._volume = volume;
		if(this._jsAudio != null) this._jsAudio.setVolume(volume);
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		this._jsAudio.stop();
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop,co.doubleduck.SoundManager.audioPoolSize);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,load: function(isLoop,pool) {
		if(pool == null) pool = 1;
		var pathNoExtension = this._src;
		this._jsAudio = AudioFX(pathNoExtension, { loop: isLoop, pool: pool });
	}
	,init: function() {
	}
	,_volume: null
	,_loop: null
	,_jsAudio: null
	,_src: null
	,__class__: co.doubleduck.audio.AudioFX
}
co.doubleduck.audio.DummyAudioAPI = $hxClasses["co.doubleduck.audio.DummyAudioAPI"] = function() {
};
co.doubleduck.audio.DummyAudioAPI.__name__ = ["co","doubleduck","audio","DummyAudioAPI"];
co.doubleduck.audio.DummyAudioAPI.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.DummyAudioAPI.prototype = {
	setVolume: function(volume) {
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
	}
	,init: function() {
	}
	,__class__: co.doubleduck.audio.DummyAudioAPI
}
co.doubleduck.audio.HowlerAudio = $hxClasses["co.doubleduck.audio.HowlerAudio"] = function(src) {
	this._jsAudio = null;
	this._src = src;
	this._loop = false;
	this._volume = 1;
};
co.doubleduck.audio.HowlerAudio.__name__ = ["co","doubleduck","audio","HowlerAudio"];
co.doubleduck.audio.HowlerAudio.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.HowlerAudio._currentlyPlaying = null;
co.doubleduck.audio.HowlerAudio.prototype = {
	setVolume: function(volume) {
		this._volume = volume;
		if(this._jsAudio != null) this._jsAudio.volume = volume;
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		this._jsAudio.stop();
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop,1);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,load: function(isLoop,pool) {
		if(pool == null) pool = 1;
		var pathNoExtension = this._src;
		var myUrls = new Array();
		myUrls.push(this._src + ".mp3");
		myUrls.push(this._src + ".ogg");
		this._jsAudio = new Howl({urls: myUrls, loop: false});
	}
	,init: function() {
	}
	,_volume: null
	,_loop: null
	,_jsAudio: null
	,_src: null
	,__class__: co.doubleduck.audio.HowlerAudio
}
co.doubleduck.audio.NonOverlappingAudio = $hxClasses["co.doubleduck.audio.NonOverlappingAudio"] = function(src) {
	this._src = src;
	this.load();
	this._isMusic = false;
};
co.doubleduck.audio.NonOverlappingAudio.__name__ = ["co","doubleduck","audio","NonOverlappingAudio"];
co.doubleduck.audio.NonOverlappingAudio.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying = null;
co.doubleduck.audio.NonOverlappingAudio.prototype = {
	getSrc: function() {
		return this._src;
	}
	,audio: function() {
		return this._audio;
	}
	,setVolume: function(volume) {
		if(this._audio != null) this._audio.volume = volume;
	}
	,pause: function() {
		if(this._audio != null) this._audio.pause();
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		if(this._isMusic) co.doubleduck.audio.NonOverlappingAudio._musicPlaying = false;
		if(this._audio != null) {
			this._audio.removeEventListener("ended",$bind(this,this.handleEnded));
			this._audio.currentTime = 0;
			this._audio.pause();
		}
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(volume == null) volume = 1;
		if(co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying != null) co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying.stop();
		this._isMusic = true;
		co.doubleduck.audio.NonOverlappingAudio._musicPlaying = true;
		this._audio.play();
		this._audio.volume = volume;
		this._audio.loop = loop;
		if(!loop) this._audio.addEventListener("ended",$bind(this,this.stop));
	}
	,handleEnded: function() {
		this._audio.removeEventListener("ended",$bind(this,this.handleEnded));
		this._audio.currentTime = 0;
	}
	,handleTimeUpdate: function() {
		if(this._audio.currentTime >= this._audio.duration - 0.3) this.stop();
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		if(co.doubleduck.audio.NonOverlappingAudio._musicPlaying) return;
		if(overrideOtherEffects && co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying != null) co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying.stop();
		this._audio.play();
		this._audio.volume = volume;
		this._audio.loop = loop;
		if(!loop) this._audio.addEventListener("ended",$bind(this,this.stop));
		co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying = this;
	}
	,handleError: function() {
	}
	,handleCanPlay: function() {
	}
	,load: function() {
		this._audio = new Audio();
		this._audio.src = this._src;
		this._audio.initialTime = 0;
		this._audio.addEventListener("canplaythrough",$bind(this,this.handleCanPlay));
		this._audio.addEventListener("onerror",$bind(this,this.handleError));
	}
	,init: function() {
	}
	,_isMusic: null
	,_audio: null
	,_src: null
	,__class__: co.doubleduck.audio.NonOverlappingAudio
}
var haxe = haxe || {}
haxe.Log = $hxClasses["haxe.Log"] = function() { }
haxe.Log.__name__ = ["haxe","Log"];
haxe.Log.trace = function(v,infos) {
	js.Boot.__trace(v,infos);
}
haxe.Log.clear = function() {
	js.Boot.__clear_trace();
}
haxe.Public = $hxClasses["haxe.Public"] = function() { }
haxe.Public.__name__ = ["haxe","Public"];
haxe.StackItem = $hxClasses["haxe.StackItem"] = { __ename__ : ["haxe","StackItem"], __constructs__ : ["CFunction","Module","FilePos","Method","Lambda"] }
haxe.StackItem.CFunction = ["CFunction",0];
haxe.StackItem.CFunction.toString = $estr;
haxe.StackItem.CFunction.__enum__ = haxe.StackItem;
haxe.StackItem.Module = function(m) { var $x = ["Module",1,m]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.StackItem.FilePos = function(s,file,line) { var $x = ["FilePos",2,s,file,line]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.StackItem.Method = function(classname,method) { var $x = ["Method",3,classname,method]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.StackItem.Lambda = function(v) { var $x = ["Lambda",4,v]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.Stack = $hxClasses["haxe.Stack"] = function() { }
haxe.Stack.__name__ = ["haxe","Stack"];
haxe.Stack.callStack = function() {
	var oldValue = Error.prepareStackTrace;
	Error.prepareStackTrace = function(error,callsites) {
		var stack = [];
		var _g = 0;
		while(_g < callsites.length) {
			var site = callsites[_g];
			++_g;
			var method = null;
			var fullName = site.getFunctionName();
			if(fullName != null) {
				var idx = fullName.lastIndexOf(".");
				if(idx >= 0) {
					var className = HxOverrides.substr(fullName,0,idx);
					var methodName = HxOverrides.substr(fullName,idx + 1,null);
					method = haxe.StackItem.Method(className,methodName);
				}
			}
			stack.push(haxe.StackItem.FilePos(method,site.getFileName(),site.getLineNumber()));
		}
		return stack;
	};
	var a = haxe.Stack.makeStack(new Error().stack);
	a.shift();
	Error.prepareStackTrace = oldValue;
	return a;
}
haxe.Stack.exceptionStack = function() {
	return [];
}
haxe.Stack.toString = function(stack) {
	var b = new StringBuf();
	var _g = 0;
	while(_g < stack.length) {
		var s = stack[_g];
		++_g;
		b.b += Std.string("\nCalled from ");
		haxe.Stack.itemToString(b,s);
	}
	return b.b;
}
haxe.Stack.itemToString = function(b,s) {
	var $e = (s);
	switch( $e[1] ) {
	case 0:
		b.b += Std.string("a C function");
		break;
	case 1:
		var m = $e[2];
		b.b += Std.string("module ");
		b.b += Std.string(m);
		break;
	case 2:
		var line = $e[4], file = $e[3], s1 = $e[2];
		if(s1 != null) {
			haxe.Stack.itemToString(b,s1);
			b.b += Std.string(" (");
		}
		b.b += Std.string(file);
		b.b += Std.string(" line ");
		b.b += Std.string(line);
		if(s1 != null) b.b += Std.string(")");
		break;
	case 3:
		var meth = $e[3], cname = $e[2];
		b.b += Std.string(cname);
		b.b += Std.string(".");
		b.b += Std.string(meth);
		break;
	case 4:
		var n = $e[2];
		b.b += Std.string("local function #");
		b.b += Std.string(n);
		break;
	}
}
haxe.Stack.makeStack = function(s) {
	if(typeof(s) == "string") {
		var stack = s.split("\n");
		var m = [];
		var _g = 0;
		while(_g < stack.length) {
			var line = stack[_g];
			++_g;
			m.push(haxe.StackItem.Module(line));
		}
		return m;
	} else return s;
}
if(!haxe.unit) haxe.unit = {}
haxe.unit.TestCase = $hxClasses["haxe.unit.TestCase"] = function() {
};
haxe.unit.TestCase.__name__ = ["haxe","unit","TestCase"];
haxe.unit.TestCase.__interfaces__ = [haxe.Public];
haxe.unit.TestCase.prototype = {
	assertEquals: function(expected,actual,c) {
		this.currentTest.done = true;
		if(actual != expected) {
			this.currentTest.success = false;
			this.currentTest.error = "expected '" + Std.string(expected) + "' but was '" + Std.string(actual) + "'";
			this.currentTest.posInfos = c;
			throw this.currentTest;
		}
	}
	,assertFalse: function(b,c) {
		this.currentTest.done = true;
		if(b == true) {
			this.currentTest.success = false;
			this.currentTest.error = "expected false but was true";
			this.currentTest.posInfos = c;
			throw this.currentTest;
		}
	}
	,assertTrue: function(b,c) {
		this.currentTest.done = true;
		if(b == false) {
			this.currentTest.success = false;
			this.currentTest.error = "expected true but was false";
			this.currentTest.posInfos = c;
			throw this.currentTest;
		}
	}
	,print: function(v) {
		haxe.unit.TestRunner.print(v);
	}
	,tearDown: function() {
	}
	,setup: function() {
	}
	,currentTest: null
	,__class__: haxe.unit.TestCase
}
haxe.unit.TestResult = $hxClasses["haxe.unit.TestResult"] = function() {
	this.m_tests = new List();
	this.success = true;
};
haxe.unit.TestResult.__name__ = ["haxe","unit","TestResult"];
haxe.unit.TestResult.prototype = {
	toString: function() {
		var buf = new StringBuf();
		var failures = 0;
		var $it0 = this.m_tests.iterator();
		while( $it0.hasNext() ) {
			var test = $it0.next();
			if(test.success == false) {
				buf.b += Std.string("* ");
				buf.b += Std.string(test.classname);
				buf.b += Std.string("::");
				buf.b += Std.string(test.method);
				buf.b += Std.string("()");
				buf.b += Std.string("\n");
				buf.b += Std.string("ERR: ");
				if(test.posInfos != null) {
					buf.b += Std.string(test.posInfos.fileName);
					buf.b += Std.string(":");
					buf.b += Std.string(test.posInfos.lineNumber);
					buf.b += Std.string("(");
					buf.b += Std.string(test.posInfos.className);
					buf.b += Std.string(".");
					buf.b += Std.string(test.posInfos.methodName);
					buf.b += Std.string(") - ");
				}
				buf.b += Std.string(test.error);
				buf.b += Std.string("\n");
				if(test.backtrace != null) {
					buf.b += Std.string(test.backtrace);
					buf.b += Std.string("\n");
				}
				buf.b += Std.string("\n");
				failures++;
			}
		}
		buf.b += Std.string("\n");
		if(failures == 0) buf.b += Std.string("OK "); else buf.b += Std.string("FAILED ");
		buf.b += Std.string(this.m_tests.length);
		buf.b += Std.string(" tests, ");
		buf.b += Std.string(failures);
		buf.b += Std.string(" failed, ");
		buf.b += Std.string(this.m_tests.length - failures);
		buf.b += Std.string(" success");
		buf.b += Std.string("\n");
		return buf.b;
	}
	,add: function(t) {
		this.m_tests.add(t);
		if(!t.success) this.success = false;
	}
	,success: null
	,m_tests: null
	,__class__: haxe.unit.TestResult
}
haxe.unit.TestRunner = $hxClasses["haxe.unit.TestRunner"] = function() {
	this.result = new haxe.unit.TestResult();
	this.cases = new List();
};
haxe.unit.TestRunner.__name__ = ["haxe","unit","TestRunner"];
haxe.unit.TestRunner.print = function(v) {
	var msg = StringTools.htmlEscape(js.Boot.__string_rec(v,"")).split("\n").join("<br/>");
	var d = document.getElementById("haxe:trace");
	if(d == null) alert("haxe:trace element not found"); else d.innerHTML += msg;
}
haxe.unit.TestRunner.customTrace = function(v,p) {
	haxe.unit.TestRunner.print(p.fileName + ":" + p.lineNumber + ": " + Std.string(v) + "\n");
}
haxe.unit.TestRunner.prototype = {
	runCase: function(t) {
		var old = haxe.Log.trace;
		haxe.Log.trace = haxe.unit.TestRunner.customTrace;
		var cl = Type.getClass(t);
		var fields = Type.getInstanceFields(cl);
		haxe.unit.TestRunner.print("Class: " + Type.getClassName(cl) + " ");
		var _g = 0;
		while(_g < fields.length) {
			var f = fields[_g];
			++_g;
			var fname = f;
			var field = Reflect.field(t,f);
			if(StringTools.startsWith(fname,"test") && Reflect.isFunction(field)) {
				t.currentTest = new haxe.unit.TestStatus();
				t.currentTest.classname = Type.getClassName(cl);
				t.currentTest.method = fname;
				t.setup();
				try {
					field.apply(t,new Array());
					if(t.currentTest.done) {
						t.currentTest.success = true;
						haxe.unit.TestRunner.print(".");
					} else {
						t.currentTest.success = false;
						t.currentTest.error = "(warning) no assert";
						haxe.unit.TestRunner.print("W");
					}
				} catch( $e0 ) {
					if( js.Boot.__instanceof($e0,haxe.unit.TestStatus) ) {
						var e = $e0;
						haxe.unit.TestRunner.print("F");
						t.currentTest.backtrace = haxe.Stack.toString(haxe.Stack.exceptionStack());
					} else {
					var e = $e0;
					haxe.unit.TestRunner.print("E");
					if(e.message != null) t.currentTest.error = "exception thrown : " + Std.string(e) + " [" + Std.string(e.message) + "]"; else t.currentTest.error = "exception thrown : " + Std.string(e);
					t.currentTest.backtrace = haxe.Stack.toString(haxe.Stack.exceptionStack());
					}
				}
				this.result.add(t.currentTest);
				t.tearDown();
			}
		}
		haxe.unit.TestRunner.print("\n");
		haxe.Log.trace = old;
	}
	,run: function() {
		this.result = new haxe.unit.TestResult();
		var $it0 = this.cases.iterator();
		while( $it0.hasNext() ) {
			var c = $it0.next();
			this.runCase(c);
		}
		haxe.unit.TestRunner.print(this.result.toString());
		return this.result.success;
	}
	,add: function(c) {
		this.cases.add(c);
	}
	,cases: null
	,result: null
	,__class__: haxe.unit.TestRunner
}
haxe.unit.TestStatus = $hxClasses["haxe.unit.TestStatus"] = function() {
	this.done = false;
	this.success = false;
};
haxe.unit.TestStatus.__name__ = ["haxe","unit","TestStatus"];
haxe.unit.TestStatus.prototype = {
	backtrace: null
	,posInfos: null
	,classname: null
	,method: null
	,error: null
	,success: null
	,done: null
	,__class__: haxe.unit.TestStatus
}
var js = js || {}
js.Boot = $hxClasses["js.Boot"] = function() { }
js.Boot.__name__ = ["js","Boot"];
js.Boot.__unhtml = function(s) {
	return s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
}
js.Boot.__trace = function(v,i) {
	var msg = i != null?i.fileName + ":" + i.lineNumber + ": ":"";
	msg += js.Boot.__string_rec(v,"");
	var d;
	if(typeof(document) != "undefined" && (d = document.getElementById("haxe:trace")) != null) d.innerHTML += js.Boot.__unhtml(msg) + "<br/>"; else if(typeof(console) != "undefined" && console.log != null) console.log(msg);
}
js.Boot.__clear_trace = function() {
	var d = document.getElementById("haxe:trace");
	if(d != null) d.innerHTML = "";
}
js.Boot.isClass = function(o) {
	return o.__name__;
}
js.Boot.isEnum = function(e) {
	return e.__ename__;
}
js.Boot.getClass = function(o) {
	return o.__class__;
}
js.Boot.__string_rec = function(o,s) {
	if(o == null) return "null";
	if(s.length >= 5) return "<...>";
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) t = "object";
	switch(t) {
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) return o[0];
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2, _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) str += "," + js.Boot.__string_rec(o[i],s); else str += js.Boot.__string_rec(o[i],s);
				}
				return str + ")";
			}
			var l = o.length;
			var i;
			var str = "[";
			s += "\t";
			var _g = 0;
			while(_g < l) {
				var i1 = _g++;
				str += (i1 > 0?",":"") + js.Boot.__string_rec(o[i1],s);
			}
			str += "]";
			return str;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			return "???";
		}
		if(tostr != null && tostr != Object.toString) {
			var s2 = o.toString();
			if(s2 != "[object Object]") return s2;
		}
		var k = null;
		var str = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) { ;
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str.length != 2) str += ", \n";
		str += s + k + " : " + js.Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str += "\n" + s + "}";
		return str;
	case "function":
		return "<function>";
	case "string":
		return o;
	default:
		return String(o);
	}
}
js.Boot.__interfLoop = function(cc,cl) {
	if(cc == null) return false;
	if(cc == cl) return true;
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0, _g = intf.length;
		while(_g1 < _g) {
			var i = _g1++;
			var i1 = intf[i];
			if(i1 == cl || js.Boot.__interfLoop(i1,cl)) return true;
		}
	}
	return js.Boot.__interfLoop(cc.__super__,cl);
}
js.Boot.__instanceof = function(o,cl) {
	try {
		if(o instanceof cl) {
			if(cl == Array) return o.__enum__ == null;
			return true;
		}
		if(js.Boot.__interfLoop(o.__class__,cl)) return true;
	} catch( e ) {
		if(cl == null) return false;
	}
	switch(cl) {
	case Int:
		return Math.ceil(o%2147483648.0) === o;
	case Float:
		return typeof(o) == "number";
	case Bool:
		return o === true || o === false;
	case String:
		return typeof(o) == "string";
	case Dynamic:
		return true;
	default:
		if(o == null) return false;
		if(cl == Class && o.__name__ != null) return true; else null;
		if(cl == Enum && o.__ename__ != null) return true; else null;
		return o.__enum__ == cl;
	}
}
js.Boot.__cast = function(o,t) {
	if(js.Boot.__instanceof(o,t)) return o; else throw "Cannot cast " + Std.string(o) + " to " + Std.string(t);
}
js.Lib = $hxClasses["js.Lib"] = function() { }
js.Lib.__name__ = ["js","Lib"];
js.Lib.document = null;
js.Lib.window = null;
js.Lib.debug = function() {
	debugger;
}
js.Lib.alert = function(v) {
	alert(js.Boot.__string_rec(v,""));
}
js.Lib.eval = function(code) {
	return eval(code);
}
js.Lib.setErrorHandler = function(f) {
	js.Lib.onerror = f;
}
function $iterator(o) { if( o instanceof Array ) return function() { return HxOverrides.iter(o); }; return typeof(o.iterator) == 'function' ? $bind(o,o.iterator) : o.iterator; };
var $_;
function $bind(o,m) { var f = function(){ return f.method.apply(f.scope, arguments); }; f.scope = o; f.method = m; return f; };
if(Array.prototype.indexOf) HxOverrides.remove = function(a,o) {
	var i = a.indexOf(o);
	if(i == -1) return false;
	a.splice(i,1);
	return true;
}; else null;
Math.__name__ = ["Math"];
Math.NaN = Number.NaN;
Math.NEGATIVE_INFINITY = Number.NEGATIVE_INFINITY;
Math.POSITIVE_INFINITY = Number.POSITIVE_INFINITY;
$hxClasses.Math = Math;
Math.isFinite = function(i) {
	return isFinite(i);
};
Math.isNaN = function(i) {
	return isNaN(i);
};
String.prototype.__class__ = $hxClasses.String = String;
String.__name__ = ["String"];
Array.prototype.__class__ = $hxClasses.Array = Array;
Array.__name__ = ["Array"];
Date.prototype.__class__ = $hxClasses.Date = Date;
Date.__name__ = ["Date"];
var Int = $hxClasses.Int = { __name__ : ["Int"]};
var Dynamic = $hxClasses.Dynamic = { __name__ : ["Dynamic"]};
var Float = $hxClasses.Float = Number;
Float.__name__ = ["Float"];
var Bool = $hxClasses.Bool = Boolean;
Bool.__ename__ = ["Bool"];
var Class = $hxClasses.Class = { __name__ : ["Class"]};
var Enum = { };
var Void = $hxClasses.Void = { __ename__ : ["Void"]};
if(typeof document != "undefined") js.Lib.document = document;
if(typeof window != "undefined") {
	js.Lib.window = window;
	js.Lib.window.onerror = function(msg,url,line) {
		var f = js.Lib.onerror;
		if(f == null) return false;
		return f(msg,[url + ":" + line]);
	};
}
co.doubleduck.BaseAssets.onLoadAll = null;
co.doubleduck.BaseAssets._loader = null;
co.doubleduck.BaseAssets._cacheData = { };
co.doubleduck.BaseAssets._loadCallbacks = { };
co.doubleduck.BaseAssets.loaded = 0;
co.doubleduck.BaseAssets._useLocalStorage = false;
co.doubleduck.BaseGame._viewport = null;
co.doubleduck.BaseGame._scale = 1;
co.doubleduck.BaseGame.DEBUG = false;
co.doubleduck.BaseGame.LOGO_URI = "images/duckling/splash_logo.png";
co.doubleduck.BaseGame.LOAD_STROKE_URI = "images/duckling/loading_stroke.png";
co.doubleduck.BaseGame.LOAD_FILL_URI = "images/duckling/loading_fill.png";
co.doubleduck.BaseGame.ORIENT_PORT_URI = "images/duckling/orientation_error_port.png";
co.doubleduck.BaseGame.ORIENT_LAND_URI = "images/duckling/orientation_error_land.png";
co.doubleduck.BaseGame.isLocalized = false;
co.doubleduck.BasePersistence.GAME_PREFIX = "DUCK";
co.doubleduck.BasePersistence.available = co.doubleduck.BasePersistence.localStorageSupported();
co.doubleduck.Bet.numRef = [co.doubleduck.BetValue.ZERO,co.doubleduck.BetValue.ONE,co.doubleduck.BetValue.TWO,co.doubleduck.BetValue.THREE,co.doubleduck.BetValue.FOUR,co.doubleduck.BetValue.FIVE,co.doubleduck.BetValue.SIX,co.doubleduck.BetValue.SEVEN,co.doubleduck.BetValue.EIGHT,co.doubleduck.BetValue.NINE,co.doubleduck.BetValue.TEN,co.doubleduck.BetValue.ELEVEN,co.doubleduck.BetValue.TWELVE,co.doubleduck.BetValue.THIRTEEN,co.doubleduck.BetValue.FOURTEEN,co.doubleduck.BetValue.FIFTEEN,co.doubleduck.BetValue.SIXTEEN,co.doubleduck.BetValue.SEVENTEEN,co.doubleduck.BetValue.EIGHTEEN,co.doubleduck.BetValue.NINETEEN,co.doubleduck.BetValue.TWENTY,co.doubleduck.BetValue.TWENTY_ONE,co.doubleduck.BetValue.TWENTY_TWO,co.doubleduck.BetValue.TWENTY_THREE,co.doubleduck.BetValue.TWENTY_FOUR,co.doubleduck.BetValue.TWENTY_FIVE,co.doubleduck.BetValue.TWENTY_SIX,co.doubleduck.BetValue.TWENTY_SEVEN,co.doubleduck.BetValue.TWENTY_EIGHT,co.doubleduck.BetValue.TWENTY_NINE,co.doubleduck.BetValue.THIRTY,co.doubleduck.BetValue.THIRTY_ONE,co.doubleduck.BetValue.THIRTY_TWO,co.doubleduck.BetValue.THIRTY_THREE,co.doubleduck.BetValue.THIRTY_FOUR,co.doubleduck.BetValue.THIRTY_FIVE,co.doubleduck.BetValue.THIRTY_SIX];
co.doubleduck.Bet.RATIO_SINGLE = 36;
co.doubleduck.Bet.RATIO_DOZEN = 3;
co.doubleduck.Bet.RATIO_OUTSIDE = 2;
co.doubleduck.BetTable.NUM_COLS = 5;
co.doubleduck.BetTable.NUM_ROWS = 14;
co.doubleduck.BetTable.tableLayout = [[0,0],[0,0],[0,0],[1,1],[0,0],[1,2],[1,4],[1,1],[1,1],[1,1],[0,0],[0,0],[1,1],[1,1],[1,1],[1,2],[0,0],[1,1],[1,1],[1,1],[0,0],[0,0],[1,1],[1,1],[1,1],[1,2],[1,4],[1,1],[1,1],[1,1],[0,0],[0,0],[1,1],[1,1],[1,1],[1,2],[0,0],[1,1],[1,1],[1,1],[0,0],[0,0],[1,1],[1,1],[1,1],[1,2],[1,4],[1,1],[1,1],[1,1],[0,0],[0,0],[1,1],[1,1],[1,1],[1,2],[0,0],[1,1],[1,1],[1,1],[0,0],[0,0],[1,1],[1,1],[1,1],[0,0],[0,0],[1,1],[1,1],[1,1]];
co.doubleduck.Button.CLICK_TYPE_NONE = 0;
co.doubleduck.Button.CLICK_TYPE_TINT = 1;
co.doubleduck.Button.CLICK_TYPE_JUICY = 2;
co.doubleduck.Button.CLICK_TYPE_SCALE = 3;
co.doubleduck.Button.CLICK_TYPE_TOGGLE = 4;
co.doubleduck.Button.CLICK_TYPE_HOLD = 5;
co.doubleduck.Button._defaultSound = null;
co.doubleduck.Dropper.PREFIX = "droplet";
co.doubleduck.Dropper.DROPLET_SIZE = 61;
co.doubleduck.Dropper.DROPLET_COUNT = 5;
co.doubleduck.Dropper.DROP_TIME = 1600;
co.doubleduck.Menu.SCROLL_EASE = 0.008;
co.doubleduck.Menu.ROW_POS = 0.7;
co.doubleduck.Menu.BTN_PADDING = 10;
co.doubleduck.RouletteWheel.SPINS_COUNT = 2;
co.doubleduck.RouletteWheel.TIME_PER_SPIN = 1100;
co.doubleduck.RouletteWheel.SLOT_WIDTH = 360 / 37;
co.doubleduck.Session.numOrder = [0,32,15,19,4,21,2,25,17,34,6,27,13,36,11,30,8,23,10,5,24,16,33,1,20,14,31,9,22,18,29,7,28,12,35,3,26];
co.doubleduck.Session.lastCasinoId = -1;
co.doubleduck.audio.WebAudioAPI._buffers = { };
co.doubleduck.SoundManager._muted = false;
co.doubleduck.SoundManager._cache = { };
co.doubleduck.SoundManager.audioPoolSize = 2;
co.doubleduck.SoundManager.available = co.doubleduck.SoundManager.isSoundAvailable();
co.doubleduck.Transition._allowInstantiation = false;
co.doubleduck.WinMessage.FILE_PATH = "images/session/wins/";
co.doubleduck.audio.AudioFX._muted = false;
co.doubleduck.audio.HowlerAudio._muted = false;
co.doubleduck.audio.NonOverlappingAudio._musicPlaying = false;
js.Lib.onerror = null;
co.doubleduck.Main.main();

//@ sourceMappingURL=roulette.js.map