$(document).ready(function () {
    var $cidades = {};
    $.getJSON('feriados.json', {}, function ($json) {
        var $item = [];
        $.each($json.city, function ($id_cidade, $cidade) {
            $cidades[$id_cidade] = $cidade;
            var $template = '<li data-id_cidade="' + $id_cidade + '">' + ($cidade.name).toUpperCase() + '</li>';
            $item.push($template);
        });
        $("<ul/>", {
            "class": "list",
            html: $item.join("")
        }).appendTo("section#main article").find('li').click(function () {
            $('section#view').addClass('to_center').find('article').empty();
            var $id_cidade = $(this).data('id_cidade');
            var $cidade = $cidades[$id_cidade];

            $('section#view header .title strong').text($cidade.name);
            var $padroeiro = '';
            if ($.trim($cidade.padroeiro)) {
                $padroeiro = 'Padroeiro : ' + $cidade.padroeiro;
            }
            $('section#view header .title span').text($padroeiro);

            var $item = [];
            $.each($cidade.feriados, function ($id_feriado, $feriado) {
                var $date = ($feriado.date).split(' de ');
                var $day = $date[0];
                var $month = $date[1];
                var $description = $feriado.description;
                var $template = '<li class="event">\
                                    <time datetime="2014-07-20">\
                                        <span class="day">' + $day + '</span>\
                                        <span class="month">' + $month + '</span>\
                                    </time>\
                                    <div class="info">\
                                        <h2 class="title">' + $description + '</h2>\
                                    </div>\
                                    <div class="social">\
                                        <ul>\
                                            <!--<li class="save" style="width:50%;"><a href="#"><span class="icon save"></span></a></li>-->\
                                            <li class="share" style="width:50%;"><a href="#"><span class="icon share-alt"></span></a></li>\
                                        </ul>\
                                    </div>\
                                </li>';
                $item.push($template);
            });
            $("<ul/>", {
                "class": "event-list",
                html: $item.join("")
            }).appendTo("section#view article");
            $("section#view article ul li.save").click(function () {
                var $node = $(this).closest('.event');
                var $datetime = $node.find("time").attr('datetime');
                var $description = $node.find("h2").text();
            });
            $("section#view article ul li.share").click(function () {
                var $node = $(this).closest('.event');
                var $day = $node.find(".day").text();
                var $month = $node.find(".month").text();
                var $description = $node.find("h2").text();
                var subject = encodeURIComponent(JSON.stringify('Feriado no dia ' + $day + ' de ' + $month));
                var body = encodeURIComponent(JSON.stringify($description));
                var createEmail = new MozActivity({
                    name: "new",
                    data: {
                        type: "mail",
                        url: "mailto:?subject=" + subject + "&body=" + body,
                    }
                });
                createEmail.onerror = function () {
                    alert('Ocorreu ume erro ao criar o email');
                };
                createEmail.onsuccess = function () {
                    alert('Email enviado com sucesso');
                };
            });
        });
    });
    $('section#main header.subheader button').click(function () {
        var $query = $.trim(($('section#main header.subheader input').val()).toUpperCase());
        if ($query) {
            $("section#main article ul li").hide();
            $("section#main article ul li:contains('" + $query + "')").fadeIn();
        } else {
            $("section#main article ul li").show();
        }
    });
    $('section#view nav button').click(function () {
        $('section#view').removeClass('to_center');
    }).click();
    $('section#main header.subheader input').keypress(function($event){
        if($event.keyCode === 13){
            $('section#main header.subheader button').click();
        }
    }).val('');
});