//return an array of objects according to key, value, or key and value matching
function getObjects(obj, key, val) {
  var objects = [];
  for (var i in obj) {
    if (!obj.hasOwnProperty(i)) continue;
    if (typeof obj[i] == 'object') {
      objects = objects.concat(getObjects(obj[i], key, val));
    } else
    //if key matches and value matches or if key matches and value is not passed (eliminating the case where key matches but passed value does not)
    if (i == key && obj[i] == val || i == key && val == '') { //
      objects.push(obj);
    } else if (obj[i] == val && key == '') {
      //only add if the object is not already in the array
      if (objects.lastIndexOf(obj) == -1) {
        objects.push(obj);
      }
    }
  }
  return objects;
}

//return an array of values that match on a certain key
function getValues(obj, key) {
  var objects = [];
  for (var i in obj) {
    if (!obj.hasOwnProperty(i)) continue;
    if (typeof obj[i] == 'object') {
      objects = objects.concat(getValues(obj[i], key));
    } else if (i == key) {
      objects.push(obj[i]);
    }
  }
  return objects;
}

//return an array of keys that match on a certain value
function getKeys(obj, val) {
  var objects = [];
  for (var i in obj) {
    if (!obj.hasOwnProperty(i)) continue;
    if (typeof obj[i] == 'object') {
      objects = objects.concat(getKeys(obj[i], val));
    } else if (obj[i] == val) {
      objects.push(i);
    }
  }
  return objects;
}

var url = "http://asholei.com/html5/rtv/home-bn.php";
var xml = new JKL.ParseXML(url);
var RTVFuxData = xml.parse();
var FuxImage = (getValues(RTVFuxData, 'image'));
var FuxTitle = (getValues(RTVFuxData, 'title'));
var FuxVideo = (getValues(RTVFuxData, 'video'));
var FuxList = '<div id="vidloader"><div class="vidcontainer"><iframe class="fuxitem1" width="100%" height="100%" src="http://www.youtube.com/embed/' + (/.*\?v=(.*)/g.exec(FuxVideo[0])[1]) + '"></iframe></div></div>' +
  '<div class="newscontainer"><div class="fuxitems" id="fuxitem1"><img class="newsimage" src="' + FuxImage[0] + '"/><p class="newstitle">' + FuxTitle[2] + '</p></div>' +
  '<div class="fuxitems" id="fuxitem2"><img class="newsimage" src="' + FuxImage[1] + '"/><p class="newstitle">' + FuxTitle[3] + '</p></div>' +
  '<div class="fuxitems" id="fuxitem3"><img class="newsimage" src="' + FuxImage[2] + '"/><p class="newstitle">' + FuxTitle[4] + '</p></div>' +
  '<div class="fuxitems" id="fuxitem4"><img class="newsimage" src="' + FuxImage[3] + '"/><p class="newstitle">' + FuxTitle[5] + '</p></div>' +
  '<div class="fuxitems" id="fuxitem5"><img class="newsimage" src="' + FuxImage[4] + '"/><p class="newstitle">' + FuxTitle[6] + '</p></div></div>';

document.getElementById("container").innerHTML = FuxList;

var FuxShowVid1 = '<div class="vidcontainer"><iframe class="fuxitem1" width="100%" height="100%" src="http://www.youtube.com/embed/' + (/.*\?v=(.*)/g.exec(FuxVideo[0])[1]) + '"></iframe></div>';
var FuxShowVid2 = '<div class="vidcontainer"><iframe class="fuxitem2" width="100%" height="100%" src="http://www.youtube.com/embed/' + (/.*\?v=(.*)/g.exec(FuxVideo[1])[1]) + '"></iframe></div>';
var FuxShowVid3 = '<div class="vidcontainer"><iframe class="fuxitem3" width="100%" height="100%" src="http://www.youtube.com/embed/' + (/.*\?v=(.*)/g.exec(FuxVideo[2])[1]) + '"></iframe></div>';
var FuxShowVid4 = '<div class="vidcontainer"><iframe class="fuxitem4" width="100%" height="100%" src="http://www.youtube.com/embed/' + (/.*\?v=(.*)/g.exec(FuxVideo[3])[1]) + '"></iframe></div>';
var FuxShowVid5 = '<div class="vidcontainer"><iframe class="fuxitem5" width="100%" height="100%" src="http://www.youtube.com/embed/' + (/.*\?v=(.*)/g.exec(FuxVideo[4])[1]) + '"></iframe></div>';

document.getElementById('fuxitem1').addEventListener('click', function() {
  document.getElementById("vidloader").innerHTML = FuxShowVid1;
});
document.getElementById('fuxitem2').addEventListener('click', function() {
  document.getElementById("vidloader").innerHTML = FuxShowVid2;
});
document.getElementById('fuxitem3').addEventListener('click', function() {
  document.getElementById("vidloader").innerHTML = FuxShowVid3;
});
document.getElementById('fuxitem4').addEventListener('click', function() {
  document.getElementById("vidloader").innerHTML = FuxShowVid4;
});
document.getElementById('fuxitem5').addEventListener('click', function() {
  document.getElementById("vidloader").innerHTML = FuxShowVid5;
});
