/*User storage, adding own stations to the app*/

function checkfirstrun(){
	localforage.config({
    name        : 'RussianRadios',
    version     : 1.0,
    description : 'Offline app used to save urls and config.'
	});
	localforage.getItem('first_run',function(value){
		if (value==null){
			localforage.setItem('first_run',1,function(){console.log("Firstrun set.");});
			localforage.setItem('u_last_id',100,function(){console.log("User station_id set.");});
			localforage.setItem('u_highest_id',100,function(){console.log("Highest station_id set.");});
		}
		else console.log("The app stored something :)");
	});
}
//Reset data
function resetUserData(){
		alert("This will reset every setting of this app.");
		localforage.clear(function() { console.log('Database cleared.');});
}
//Remove a station by id
function removeStation(st_id,st_name){
	alert("Station "+st_name+" will be removed.");
	localforage.removeItem(st_id, function(){console.log("Key "+st_id+" removed successfully.");});
	localforage.getItem("u_last_id",function(value){
		if(value>st_id){
				localforage.setItem("u_last_id",st_id,function(){console.log("Key u_last_id updated successfully.");});
		}
	});
	hideElement("station-editor");
	manageUserStations();
}
//Fills the editor and buttons
function refreshEditor(st_ed){
	console.log("Called successfully");
	clearchilds("ed-genre-drop");
	for (j=0; j<Genre.genre_directory.length;j++){
			document.getElementById("ed-genre-drop").appendChild(document.createElement("option")).setAttribute('id',"drop-"+j);
			document.getElementById("drop-"+j).setAttribute('value',j);
			document.getElementById("drop-"+j).innerHTML=Genre.genre_directory[j].entry[0].genre_name;
	}
	document.getElementById("ed_name").value=st_ed.url_name;
	document.getElementById("ed_url").value=st_ed.listen_url;
	document.getElementById("ed_acro").value=st_ed.url_name_acro;
	document.getElementById("ed_web").value=st_ed.url_website;
	document.getElementById("ed-genre-drop").selectedIndex=st_ed.genre;
	document.getElementById("btnupdate").onclick=function(){updateStation(st_ed.station_id); hideElement("station-editor");};
	document.getElementById("btnremove").onclick=function(){removeStation(st_ed.station_id,st_ed.url_name); hideElement("station-editor");};
}
//After user creates a new station, clearing the form should be expected
function clearEditor(){
	document.getElementById("st_name").value=" ";
	document.getElementById("st_url").value=" ";
	document.getElementById("st_web").value=" ";
	document.getElementById("st_acro").value=" ";
	document.getElementById("cr-genre-drop").value="0";
}
//Updater
function updateStation(st_id){
	if(st_id==-1){
		localforage.getItem('u_last_id', function(value){
			station_array ={
				station_id: value,
				url_name:document.getElementById("st_name").value,
				listen_url: document.getElementById("st_url").value,
				url_website: document.getElementById("st_web").value,
				url_name_acro:document.getElementById("st_acro").value,
				genre: document.getElementById("cr-genre-drop").value
			};
			localforage.setItem(station_array.station_id, station_array, function(){console.log("Station key set successfully.");} );
			localforage.getItem(value+1,function(testitem){
				if(testitem==null){ 
					localforage.setItem('u_last_id', value+1);
					localforage.setItem('u_highest_id', value+1);
					}
			});
			clearEditor();
		});
		localforage.getItem('first_run', function(value){ console.log("FR: "+value);});
		localforage.length(function(value){console.log("L: "+value);});
	}
	else{
		station_array ={
				station_id: st_id,
				url_name:document.getElementById("ed_name").value,
				listen_url: document.getElementById("ed_url").value,
				url_website: document.getElementById("ed_web").value,
				url_name_acro:document.getElementById("ed_acro").value,
				genre: document.getElementById("ed-genre-drop").value
		};
		localforage.setItem(st_id,station_array,function(){console.log("Value "+st_id+" updated successfully.");});
		hideElement("station-editor");
		manageUserStations();
	}
}
//Add new stations
function addUserStation(){
		document.getElementById("addStation").onclick=function (){ hideElement("station-creator"); document.getElementById("addStation").onclick=function(){showElement("station-creator"); addUserStation();};};
		for (j=0; j<Genre.genre_directory.length;j++){
			document.getElementById("cr-genre-drop").appendChild(document.createElement("option")).setAttribute('id',"drop-"+j);
			document.getElementById("drop-"+j).setAttribute('value',j);
			document.getElementById("drop-"+j).innerHTML=Genre.genre_directory[j].entry[0].genre_name;
		}
		document.getElementById("btncreate").onclick=function (){updateStation(-1); };
}
//Manage stations, connects with the database and throws the output to refreshEditor.
function manageUserStations(){
		document.getElementById("manageStation").onclick=function (){ hideElement("station-manager"); document.getElementById("manageStation").onclick=function(){showElement("station-manager"); manageUserStations();};};
		localforage.getItem('u_last_id',function(value){
			console.log(value+" successfully obtained.");
			if(value==100)	document.getElementById("station-list").innerHTML="The list is empty, why you don't try to add a new station first?";
			else{
				clearchilds("station-list");
				for (var i=100;i<value;i++){
						localforage.getItem(i,function(st_ed){
								console.log(st_ed.station_id);
								document.getElementById("station-list").appendChild(document.createElement("div")).setAttribute("id","ed"+st_ed.station_id);
								document.getElementById("ed"+st_ed.station_id).setAttribute("class",'ed-st-style');
								document.getElementById("ed"+st_ed.station_id).innerHTML=st_ed.station_id +" | "+ st_ed.url_name;
								document.getElementById("ed"+st_ed.station_id).onclick=function(){showElement("station-editor"); refreshEditor(st_ed);};
						});
				}
			}	
		});
}
//Settings window
function loadSettings(){
	hideElement("aboutl");
	showElement("settings");
	showElement("back");
	etitle.innerHTML="Settings";
	eback.onclick=function(){hideElement("settings"); mainIndex();};
	/*Showing information*/
	document.getElementById("set-ver").innerHTML=versions.ver[0].vname;
	document.getElementById("build").innerHTML=build_info;
	/*Managing buttons*/
	document.getElementById("addStation").onclick=function(){showElement("station-creator"); addUserStation();};
	document.getElementById("manageStation").onclick=function(){showElement("station-manager"); manageUserStations();};
	document.getElementById("reset").onclick=function(){resetUserData();};
}
//User streams filler:
function indexUFiller(st_ed){
	getprid=document.getElementById("stream-index");
	getprid.appendChild(document.createElement("p")).setAttribute('id',"stream-name-"+st_ed.station_id);
	console.log(st_ed.url_name);
	getelid=document.getElementById("stream-name-"+st_ed.station_id);
	getelid.setAttribute('class', 'stream-n onhover-str');
	getelid.setAttribute('data-number', st_ed.station_id);
	getelid.onclick=function() {
		hideElement("stream-index");
		displayPlayer (Number(this.getAttribute('data-number')));
	};
	getelid.innerHTML=st_ed.url_name;
	if(getelid.lastChild=Stations.directory.length){
		getprid.appendChild(document.createElement("hr")).setAttribute('id', 'void');
	}	
}
//Shows tracks from user
function loadUserTracks(){
	hideElement("aboutl");
	showElement("user-index");
	clearchilds("user-index");
	showElement("back");
	etitle.innerHTML="User's Stations";
	searchstatus=3;
	eback.onclick=function(){hideElement("user-index"); mainIndex();};
	localforage.getItem('u_last_id',function(value){
			console.log(value+" successfully obtained.");
		if(value==100)	document.getElementById("station-list").innerHTML="The list is empty, why you don't try to add a new station first?";
		else{
			clearchilds("station-list");
			for (var i=100;i<value;i++){
					localforage.getItem(i,function(st_ed){
					getprid=document.getElementById("user-index");
					getprid.appendChild(document.createElement("p")).setAttribute('id',"stream-name-"+st_ed.station_id);
					getelid=document.getElementById("stream-name-"+st_ed.station_id);
					getelid.setAttribute('class', 'stream-n onhover-str');
					getelid.setAttribute('data-number', st_ed.station_id);
					getelid.onclick=function() {
						hideElement("user-index");
						displayPlayer (Number(this.getAttribute('data-number')));
					};
					getelid.innerHTML=st_ed.url_name;
			if(getelid.lastChild=Stations.directory.length){
				getprid.appendChild(document.createElement("hr")).setAttribute('id', 'void');
				}
			});
			}
		}
		});
}
