var rwthapp = rwthapp || {};
/***************************
Only permanent changes should be included to this file. Changes for testing purposes 
should be stores in a file called config.local.js within the same folder, see 
config.sample.js for further information.
****************************/
rwthapp.config = {
    "debug": false,
    "activeProxy": "live",
    "activeOauth": "live",
    "defaultMapsUrl": "google",
    "urls": {
        "proxy": {
            "live": "https://moped.ecampus.rwth-aachen.de/proxy/api/v2/",
            "testing": "https://moped.ecampus.rwth-aachen.de/proxy_testing/api/v2/"
        },
        "oauth": {
            "live": "https://oauth.campus.rwth-aachen.de/oauth2waitress/oauth2.svc/",
            "testing": "https://oauth.campus.rwth-aachen.de/oauth2waitress/oauth2.svc/"
        },
        "maps": {
            "google": "https://maps.google.com/maps?",
            "apple": "https://maps.apple.com/maps?",
            "bing": "https://www.bing.com/maps/?"
        },
        "store": {
            "android": "market://details?id=de.rwth_aachen.rz.rwthapp",
            "ios": "https://itunes.apple.com/de/app/rwthapp/id779524311",
            "windows": "https://www.microsoft.com/store/apps/9nblggh6cw3x"
        }
    },
    "versionNumber": "1.1.4",
    "versionCode": "114",
    "l2pDirectoryName": "RWTHApp Downloads",
    "oauth": {
        "clientId": "MGeS6cFckGD0Cgbl5IgEpS5eHnsdffzKebfRiEPRB63ZYVlrJ6FzbiNcbk1ER12.app.rwth-aachen.de",
        "scope": "l2p2013.rwth l2p.rwth campus.rwth ub.rwth userinfo.rwth"
    },
    "defaultLanguage": "en",
    "logLevel": 2,
    "enableInappcaching": true,
};

if (typeof module !== "undefined" && module && module.exports) {
    module.exports = rwthapp.config;
}
/***************************
Copy to config.local.js and change to your needs to add a dev-configuration.
The file config.local.js should not be added to source control.
****************************/
$.extend(true, rwthapp.config, {
    "debug": true, // Changes option debug to true
    "activeProxy": "live", // Changes the active proxy configuration, which is added in the next lines
    "urls": {
        "proxy": { // Adds a new proxy server url which is used for calls to the dev server
            "dev": "http://d-ew-th01.devlef.campus.rwth-aachen.de:8008/ProxyService/api/v2/"
        }
    },
    "logLevel": 1,
});