﻿/// <reference path="../scripts/references.js" />
rwthapp.util.initNamespace("languages");

rwthapp.languages.en = {
    titles: {
        gallery: "Gallery",
        studentReport: "Grades",
        details: "Details",
        canteenInfo: "Canteen details",
        canteenOverview: "Canteens",
        weekMenu: "Week menu",
        channelDetails: "Directfeedback",
        channelOverview: "Directfeedback",
        update: "Update",
        searchEmployees: "Employee search",
        searchRooms: "Room search",
        searchCourses: "Event search",
        employee: "Employee",
        room: "Room",
        event: "Event",
        courseDetails: "Course room"
    },
    subTitles: {
        channelOverview: "Overview",
        courseList: "Course rooms"
    },
    toasts: {

    },
    l2p: {
        olderCourses: "Older courses",
        details: {
            literature: "Literature",
            documents: "Documents",
            quizzes: "Quizz2Go",
            sharedDocuments: "Shared documents",
            structuredMaterials: "Structured materials",
            announcements: "Announcements",
            announcements_date: "Created:",
            toastDownloadSuccess: " was downloaded successfully",
            toastDownloadFailed: "Document could not be downloaded",
            emails: "Emails",
            emails_from: "From:",
            emails_date: "Sent:",
            hyperlinks: "Hyperlinks"
        },        
        news: {
            news: "L2P News",
            newsLastDays: "Last 14 days",
            date: "Created:",
            editor: "Date:",
            section: "Section:",
            title: "Title:",
            fileName: "Filename:",
            //Remember Proxy when changing following structure
            categories: {
                Announcements: "Accouncements",
                Calendar: "Calendar",
                EMails: "Emails",
                StructuredMaterials: "Learning Materials",
                Media: "Media Library",
                SharedDocuments: "Shared Dokumente",
                Assignments: "Assignments",
                DiscussionForum: "Discussion Forum",
                Literature: "Literature",
                Wiki: "Wiki",
                Hyperlinks: "Hyperlinks"
            }
        },
        ss: "Summer semester",
        ws: "Winter semester"
    },
    timetable: {
    outOfRangeMin: 'The first day of the requested week is before the possible minimal date. No data was requested.',
    outOfRangeMax: 'The last day of the requested week is after the possible maximum date. No data was requested.'
    },
    information: {
        data: "Data privacy statement",
        oauth: "OAuth Management Site",
        website: "RWTH Aachen University Website",
        outlook: "RWTH Aachen University Outlook",
        facebook: "RWTH Aachen University on Facebook",
        twitter: "RWTH Aachen University on Twitter",
        title: "About",
        rwthapp: "RWTHApp",
        version: "Version",
        itCenter: "IT Center",
        rwthAachen: "RWTH Aachen University",
    },
    settings: {
        languages: {
            label: "Language"
        },
        vibration: {
            label: "Vibration",
            on: "On",
            off: "Off"
        },
        wavesEffect: {
            label: "Click effect",
            description: "The click effect may cause performance issues on certain devices. If actions occur delayed, disabling this option can resolve the issues."
        },
        feedback: {
            button: "Feedback"
        },
        showChangelog: {
            buttonLabel: "Show changelog",
        },
        clearData: {
            buttonLabel: "Clear local data",
            confirmationText: "If you continue, RWTHApp data stored on this device, like favorites, offline-available quizzes and the OAuth authorization, will be deleted.",
            confirmationAgree: "Delete",
            confirmationCancel: "Cancel"
        },
        on: "On",
        off: "Off"
    },
    errors: {
        login: {
            general: "Login attempt failed. Please try again later.",
            noConnection: "To log in, you need to be connected to the internet. Please check your connection."
        },
        error: "Error",
        templateEventsNotLoaded: "The page could not be loaded correctly.",
        api: {
            general: "The requested information could not be retrieved.",
            tokenInvalid: "You do not have the permission to access this data. Try to log in again to authorize updated permissions."
        },
        oauth: {
            general: "A token could not be retrieved.",
            notLoggedIn: "You are not logged in.",
            refreshTokenInvalid: "Your login has expired, please log in again.",
            authenticationStartFailed: "The authentication could not be started.",
            authenticationFailed: "The authentication was not completed successfully.",
        },
        request: {
            noConnection: "Your device is not connected to the internet.",
            general: "The requested information could not be retrieved.",
            timeout: "The request timed out. This could be caused by the server or problems with your internet connection. Please try again later.",
            serverError: "The server returned an error. Please try again later.",
            clientError: "An error occurred while processing the request."
        },
        quiz: {
            quizOverviewNoCourse: "There are no available quizzes yet. A quiz can be created by your lecturers in L2P course rooms and will be displayed here afterwards.",
            quizNotOffline: "Not available offline.",
            quizNoQuestions: "This quiz is malformated or doesn't contains any questions."
        },
        studentReport: {
            no_report: "We did not find any grades for you."
        },
        feeds: {
            noFeeds: "There are no feeds available. Try enabling additional news feeds in the app settings."
        },
        freshmen: {
            noInfos: "This page displays a list of links which help with a good start into the semester. Unfortunately, no links are available at this point in time.",
        },
        courseDetails: {
            noContent: "This course room is either empty or you do not have the necessary permissions to enter it."
        }
    },
    errorpage: {
        retryButton: "Retry",
        messageHeader: "An error occurred:",
        sendReportButton: "Send error report",
        title: "Error page",
        genericDetails: "If this error occurs repeatedly, please send an error report via the button below.",
        detailedExplanation: {
            e2: "The link you followed seems to be invalid. If this error occurs repeatedly, please send an error report. Links in Quizz2Go and Directfeedback are controlled by the lecturer.",
        },
    },
    feedback: {
        debugInfoHeader: "The following details have been recorded:",
        sendButton: "Send feedback",
        feedbackLabel: "Feedback:",
        feedbackPlaceholder: "Feedback or remarks.",
        emailPlaceholder: "Email",
        emailExplanation: "To tell you the status of your feedback or to clarify any questions, you can leave us a contact address. This is explicit optional.",
        emailAgreement: "Would you like to send us your e-mail address @email@ to inform you about the status of your feedback or to ask questions about it?",
        toastSuccess: "Your feedback was sent successfully.",
        title: "Feedback",
        yes: "Yes",
        no: "No"
    },
    update: {
        appVersionNotSupportedExplanation: "This version of the RWTHApp is no longer supported. To continue using the app, please perform an update to the latest version.",
        appVersionDeprecatedExplanation: "The installed app version is deprecated and will not be supported in the near future. Please update to the latest version.",
        update: "Update"
    },
    login: {
        polling: {
            userMessage: "To enable access to personalized information, please log in to the opened website and confirm the access rights.",
            hintRestart: "If you closed the page without confirming the access rights, you can restart the authorization in the menu."
        }
    },
    quiz: {
        quiz_count: "Count: ",
        quiz_offline_available: "Available offline",
        quiz_next: "Next",
        quiz_previous: "Back",
        quiz_question: "Question",
        quiz_end: "Finish",
        quiz_points: "Overall points",
        quiz_evaluation: "Evaluation",
        quiz_answer: "Answer",
        quiz_correct_answers: "Correct answers",
        quiz_right: "Right!",
        quiz_wrong: "Wrong!",
        quiz_wrong2: "Wrong",
        quizOverview: "Quiz overview"
    },
    campus: {
        studentReport: {
            mark: "Grade",
            annotation: "Annotation",
            dateOfExam: "Date of exam",
            examNumber: "Exam number",
            semester: "Semester",
            credits: "Credits",
            swh: "SWH",
            key: "Key"
        },
        details: {
            rooms: {
                takePhoto: "Take photo.",
                gallery: "Gallery",
                contact: "Contact",
                address: "Address",
                toGallery: "To gallery"
            },
            courses: {
                name: "Event name",
                type: "Type",
                lvnr: "Event identifier",
                ects: "ECTS",
                campus: "Campus",
                l2p: "L2P",
                gotoCampus: "Open in browser",
                gotoL2P: "Go to course",
                titleLecturers: "Lecturers",
                titleAppointments: "Manage Appointments in Timetable",
                addEvent: "Event added to timetable.",
                addEventFailed: "Adding event failed.",
                deleteEvent: "Event deleted from timetable.",
                deleteEventFailed: "Deleting event failed."
            },
            employees: {
                room: "Room",
                consultation: "Consultation"
            },
            canteen: {
                openingTime: "Opening hours",
                address: "Address",
                phone: "Phone"
            }
        },
        search: {
            query: "Query",
            queryTooShort: "The query must contain at least 2 characters."
        },
        ub: {
            name: "University library",
            feedback: "Do you have any questions or want to leave feedback for us?",
            loaning: {
                name: "Loan",
                loanState: "Loan state",
                days: "days",
                expired: "expired",
                renewNum: "Renewing number",
                returnDate: "Return date",
                renew: "renew"
            },
            ordering: {
                name: "Order",
                location: "Fetching location",
                state: "State"
            },
            prebook: {
                name: "Reservation",
                position: "Position"
            },
            paying: {
                name: "Dues",
                due: "Due",
                dueFor: "Due since"
            }
        }
    },
    das: {
        channelOverview: {
            filterPlaceholder: "Filter",
            lastMessage: "Last message",
            noLastMessage: "No messages yet.",
            noChannelFound: "Currently, there are no open channels."
        },
        channelDetails: {
            messagePlaceholder: "Message",
            sendingMessageFailed: "Sending message failed, please try again.",
            notImplemented: "Not implemented yet.",
            passwordPrompt: "This channel requires a password",
            pollAlreadyClosed: "The poll has already been closed, your vote did not count.",
            pollAlreadyAnswered: "You have already submitted your vote.",
            channelClosed: "The channel is closed. Please try again later."
        }
    },
    organisation: {
        feeds: {
            gotoLink: "Go to article",
            eventGuests: "Guests",
            noFeedsAvailable: "The current feeds were not able to be load. Try again later. The result presented to you represents an old state."
        },
        timetable: {
            noAppointment: "This day does not contain any appointments."
        }
    },
    home: {
        welcome: "Welcome to the official app of RWTH Aachen University.",
        hintMenu: "To get started, open the menu via the button in the top left corner or just swipe in from the left. In the menu, you can also find the login button to use functions that require a personalized login.",
        labelHint: "Hint:",
        hintHomescreen: "You can configure a custom front page. First, mark a page as favorite by using the star icon in the top right corner. Then use the checkbox in the favorite section of the menu to choose your front page.",
        hintFeedback1: "Suggestions for improving RWTHApp are important to us. Use",
        labelFeedback: "Send feedback",
        hintFeedback2: "in the menu to submit your feedback.",
    },
    modal: {
        basic: {
            close: "Close"
        },
        passwordPrompt: {
            cancel: "Cancel",
            confirm: "OK",
            passwordPlaceholder: "Password",
        },
        takePhoto: {
            headerTitle: "Camera",
            cancel: "Cancel",
            upload: "Upload",
            takePicture: "Take photo",
            useGallery: "From gallery",
            fillerBetweenButtons: "or"
        },
        downloadL2P: {
            headerTitle: "Download",
            close: "Okay"
        },
        gallery: {
            headerTitle: "Photo",
            close: "Okay"
        }
    },
    menu: {
        pinMenu: "Pin menu",
        greeting: "Hello",
        anonym: "Anonymous mode",
        signInAdvise: "sign in to use the full feature range of RWTHApp",
        campus: {
            title: "Study",
            rooms: "Rooms",
            ub: "University library",
            employees: "Employees",
            mensa: "Canteens"
        },
        elearning: {
            title: "E-Learning",
            quiz: "Quizz2Go",
            l2p: "L2P",
            l2pnews: "L2P News",
            das: "Directfeedback"
        },
        organisation: {
            title: "RWTH",
            schedule: "Schedule",
            studentReport: "Grades",
            events: "Events",
            feeds: "News"
        },
        freshman: "Freshman",
        settings: "Settings",
        feedback: "Feedback & support",
        supportChat: "Support Chat",
        information: "About",
        favorites: {
            title: "Favorites",
            favoritesHomeHint: "Favorites (as home)",
            removeAll: "Remove all"
        },
        logoutWarning: "Do you really want to log out? After a logout the personalized offer of RWTHApp is available only after a new login via oAuth."
    },
    freshmen: {
        info: "Freshmen info",
        gotoLink: "Go to page"
    },
    tablet: {
        noResult: "No results"
    },
    maintenance: {
        message: "... is currently undergoing maintenance.",
        reason: "Reason",
        due: "Due",
    },
    supportChat: {
        introduction: "If you have questions concerning RWTHApp or other services of IT Center we have set up the chat support of IT-ServiceDesk for you:",
        feedbackHeading: "In case of technical issues or suggestions concerning RWTHApp you can also post your feedback right here:",
        title: "Chat Support",
        information: "Start your personal chat support here. Please note that chats can currently be answered in german only.",
        personName: "Name",
        email: "Email",
        category: "Category",
        start: "Start Chat",
        insertData: "Please insert your data!",
        lastChats: "Your latest chats:",
        lastMessage: "Created on",
        chatFull: "Welcome, thank you for using our chat support. Currently all our team members are busy helping other customers. Please try again in a couple of minutes.",
        chatClosed: "Welcome, thank you for using our chat support. The chat is currently closed.",
        openingHours: "Our Chat hours are: Monday and tuesday from 10.00 – 12.00 and 15.00 – 17.00 and Thursdays from 13.00 – 15.00.",
        contact: "Alternatively write us an e-mail or call us:",
        contactLink: "IT-ServiceDesk Contact",
        category: {
            category: "Category",
            choose: "choose",
            aAndO: "Administration & Organization",
            workStations: "Workstations",
            complaint: "Complaints",
            campus: "Campus",
            databases: "Databases",
            dns: "DNS",
            printservice: "Prinservice",
            eLearning: "eLearning",
            eMail: "E-Mail",
            fitTeam: "FiT-Team",
            fdm: "Research Data Management (FDM)",
            hpc: "HPC",
            idm: "Identity Management",
            infowesen: "PR",
            itc: "IT Center specific",
            itil: "ITIL",
            itsd: "IT-SD-specific",
            itsmtool: "ITSM-Tool",
            network: "Data network",
            pcpool: "PC-Pool",
            serverhosting: "Server services for institutes",
            sharePoint: "Sharepoint (of IT Center)",
            software: "Software",
            other: "Other",
            telephone: "Telephone",
            vr: "Virtual Reality",
            webservices: "Webserivces",
            educationEvents: "Education events",
            certificates: "Certificates"
        }
    },
    changelog: {
        notFound: "There is no changelog available for the current version.",
        "1.0.7": [
            "[Feature] Improved behavior on tablets",
            "[Feature] News feed now includes university cinema program",
            "", // Add line break
            "[Fix] Fixed problems with missing icons under Android 4.2 and Android 4.3",
            "[Fix] Fixed rendering error on long pages",
            "[Fix] L2P: Closed course rooms are marked",
            "[Fix] L2P: Number of documents is displayed correctly",
            "[Fix] News feed titles are truncated properly",
        ],
        "1.1.1": [
            "[Feature] Redesign of schedule. Added dynamic loading of additional entries and ability to jump to a specific week",
            "[Feature] L2P course rooms now include hyperlinks and emails",
            "[Feature] IT-ServiceDesk chat support is now available under \"Feedback & support\"",
            "",
            "[Fix] Click effects can be disabled via settings. This can improve performance on certain devices",
            "[Fix] App can be closed with the back button again if a custom start page is configured (Android and Windows)",
        ]
    }
};

// Set as default (mainly for code completion)
rwthapp.langStrings = rwthapp.languages.en;