﻿/// <reference path="../references.js" />

rwthapp.util.initNamespace("connection.api.campus");

rwthapp.connection.api.campus.getEmployees = function (query) {
    var parameters = {
        query: query
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("Employees/FindEmployees", {
        data: parameters
    });
};

rwthapp.connection.api.campus.getEmployeeById = function (id) {
    var parameters = {
        employeeId: id
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("Employees/GetEmployee", {
        data: parameters
    });
};

rwthapp.connection.api.campus.getRooms = function (query) {
    var parameters = {
        query: query
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("Rooms/FindRooms", {
        data: parameters
    });
};

rwthapp.connection.api.campus.getRoomById = function (id) {
    var parameters = {
        roomId: id
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("Rooms/GetRoom", {
        data: parameters
    });
};

rwthapp.connection.api.campus.getCourses = function (query) {
    var parameters = {
        query: query
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("Events/FindEvents", {
        data: parameters
    });
};

rwthapp.connection.api.campus.getCourseById = function (id) {
    var parameters = {
        eventId: id
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("Events/GetEvent", {
        data: parameters
    });
};

rwthapp.connection.api.campus.getAppointments = function (gguid) {
    var parameters = {
        eventId: gguid,
        lang: rwthapp.localization.getCurrentLanguage()
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("Events/GetEventAppointments", {
        data: parameters
    });
};

rwthapp.connection.api.campus.getPersonalizedAppointments = function (gguid) {
    var parameters = {
        eventId: gguid,
        lang: rwthapp.localization.getCurrentLanguage()
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("Events/Timetable/GetEventAppointments", {
        data: parameters,
        cacheLocal: false // Event appointments can be booked by users, so this should not be cached
    });
};

rwthapp.connection.api.campus.getStudentReport = function () {
    var parameters = {
        lang: rwthapp.localization.getCurrentLanguage()
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("Exams/GetReport", {
        data: parameters
    });
};

rwthapp.connection.api.campus.getWeekTimetable = function (wIndex) {
    var parameters = {
        weekOffset: wIndex
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("Events/Timetable/GetWeek", {
        data: parameters,
        cacheLocal: false // Event appointments can be booked by users, so this should not be cached
    });
};

rwthapp.connection.api.campus.getTimetableWeeks = function (weekOffset, count) {
    var parameters = {
        weekOffset: weekOffset,
        count: count
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("Events/Timetable/GetWeeks", {
        data: parameters,
        cacheLocal: false // Event appointments can be booked by users, so this should not be cached
    });
};

rwthapp.connection.api.campus.addEvent = function (eventId, appointmentId) {
    var parameters = {
        eventId:eventId,
        appointmentId: appointmentId,
        lang:rwthapp.localization.getCurrentLanguage()
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("Events/Timetable/AddAppointment", {
        data: parameters
    });
};

rwthapp.connection.api.campus.deleteEvent = function (eventId, appointmentId) {
    var parameters = {
        eventId: eventId,
        appointmentId: appointmentId,
        lang: rwthapp.localization.getCurrentLanguage()
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("Events/Timetable/DeleteAppointment", {
        data: parameters
    });
};