﻿/// <reference path="../references.js" />

rwthapp.util.initNamespace("connection.api.canteen");

rwthapp.connection.api.canteen.getCanteens = function () {
    return rwthapp.connection.requestHelper.ajaxProxyApi("Canteens/GetCanteens");
};

rwthapp.connection.api.canteen.getWeekMenu = function (canteenId) {
    var parameters = {
        canteenId: canteenId,
        lang: rwthapp.localization.getCurrentLanguage()
    };
    return rwthapp.connection.requestHelper.ajaxProxyApi("Canteens/GetWeekMenu", {
        data: parameters
    });
};

rwthapp.connection.api.canteen.getCanteenInfo = function (canteenId) {
    var parameters = {
        canteenId: canteenId,
        lang: rwthapp.localization.getCurrentLanguage()
    };
    return rwthapp.connection.requestHelper.ajaxProxyApi("Canteens/GetCanteenInfo", {
        data: parameters
    });
};