﻿/// <reference path="../references.js" />

rwthapp.util.initNamespace("connection.api.das");


rwthapp.connection.api.das.createPhotoURL = function (photoId) {
    return rwthapp.options.getProxyUrl() + "eLearning/DAS/GetPicture/" + photoId + ".jpg";
};

rwthapp.connection.api.das.getChannelList = function () {
    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/DAS/GetChannels");
};

rwthapp.connection.api.das.getMessages = function (channelId, userId, nextIndex, password) {
    var parameters = {
        channelId: channelId,
        userSecret: userId,
        nextIndex: nextIndex,
        password: password
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/DAS/GetMessages", {
        data: parameters,
        cacheLocal: false
    });
};

rwthapp.connection.api.das.sendMessage = function (message, channelId, type, userId, password, angle) {
    var queryParameters = {
        channelId: channelId,
        type: type,
        userSecret: userId,
        password: password,
        angle: angle
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/DAS/SendMessage", {
        queryParameters: queryParameters,
        data: message,
        type: "POST"
    });
};