﻿/// <reference path="../references.js" />
var rwthapp = rwthapp || {};
rwthapp.connection = rwthapp.connection || {};
rwthapp.connection.api = rwthapp.connection.api || {};

//rwthapp.util.initNamespace("connection.api");

rwthapp.connection.api.version = function () {
    return rwthapp.connection.requestHelper.ajaxProxyApi("Version", {
        appendToken: false,
    });
};

rwthapp.connection.api.getHomepageFeed = function (feedArray, count, skip) {
    var parameters = {
        pages: feedArray,
        count: count,
        skip: skip,
        lang: rwthapp.localization.getCurrentLanguage()
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("News/GetPageFeeds", {
        data: parameters
    });
};

rwthapp.connection.api.getFeedConfiguration = function () {
    var parameters = {
        lang: rwthapp.localization.getCurrentLanguage()
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("News/GetPages", {
        data: parameters
    });
};

rwthapp.connection.api.getFreshmenInfo = function () {
    var parameters = {
        lang: rwthapp.localization.getCurrentLanguage()
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("News/GetFreshmenInfo", {
        data: parameters
    });
};

rwthapp.connection.api.sendFeedback = function (message, additionalInformation) {
    var queryParameters = {
        message: message
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("/Apps/RWTHApp/SendFeedback", {
        data: additionalInformation,
        queryParameters: queryParameters,
        type: "POST"
    });
};

rwthapp.connection.api.getUserInfo = function () {

    return rwthapp.connection.requestHelper.ajaxProxyApi("User/GetInfo");
};

rwthapp.connection.api.getMenuConfiguration = function () {
    var parameters = {
        lang: rwthapp.localization.getCurrentLanguage()
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("/Apps/RWTHApp/GetMenu", {
        data: parameters,
    });
};