﻿/// <reference path="../references.js" />

rwthapp.util.initNamespace("connection.api.l2p");

rwthapp.connection.api.l2p.createDownloadLink = function (method,parameters) {
    return rwthapp.tokenManager.getToken().then(function (data) {
        var url = rwthapp.options.getProxyUrl() + method;
        parameters.token = data;
        return url+rwthapp.connection.requestHelper.createQueryString(parameters);
    });
};

rwthapp.connection.api.l2p.getCourses = function (term) {
    var parameters = {
        termOffset: term
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/CourseRooms/GetCourseRooms", {
        data: parameters
    });
};

rwthapp.connection.api.l2p.getCourseAnnouncements = function (courseRoomId) {
    var parameters = {
        courseRoomId: courseRoomId
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/CourseRooms/GetAnnouncements", {
        data: parameters
    });
};

rwthapp.connection.api.l2p.getCourseRoomOverview = function (courseRoomId) {
    var parameters = {
        courseRoomId: courseRoomId
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/CourseRooms/GetCourseRoom", {
        data: parameters
    });
};

rwthapp.connection.api.l2p.getCourseRoomDocuments = function (courseRoomId) {
    var parameters = {
        courseRoomId: courseRoomId
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/CourseRooms/GetDocuments", {
        data: parameters
    });
};

rwthapp.connection.api.l2p.getCourseRoomLiterature = function (courseRoomId) {
    var parameters = {
        courseRoomId: courseRoomId
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/CourseRooms/GetLiterature", {
        data: parameters
    });
};

rwthapp.connection.api.l2p.getCourseRoomSharedDocuments = function (courseRoomId) {
    var parameters = {
        courseRoomId: courseRoomId
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/CourseRooms/GetSharedDocuments", {
        data: parameters
    });
};

rwthapp.connection.api.l2p.getCourseRoomStructuredMaterials = function (courseRoomId) {
    var parameters = {
        courseRoomId: courseRoomId
    };

return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/CourseRooms/GetStructuredMaterials", {
        data : parameters
    });
};

rwthapp.connection.api.l2p.getCourseRoomLiterature = function (courseRoomId) {
    var parameters = {
        courseRoomId: courseRoomId
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/CourseRooms/GetLiterature", {
        data: parameters
    });
};

rwthapp.connection.api.l2p.getCourseRoomEMails = function (courseRoomId) {
    var parameters = {
        courseRoomId: courseRoomId
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/CourseRooms/GetEMails", {
        data: parameters
    });
}

rwthapp.connection.api.l2p.getCourseRoomHyperlinks = function (courseRoomId) {
    var parameter = {
        courseRoomId: courseRoomId
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/CourseRooms/GetHyperlinks", {
        data: parameter
    });
}

rwthapp.connection.api.l2p.getL2PSPEvents = function (days, skip) {
    var parameter = {
        days: days,
        skip: skip
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/GetL2PSPEvents", {
        data: parameter
    });
}

rwthapp.connection.api.l2p.downloadCourseRoomLiterature = function (name, courseRoomId, fileId) {
    var parameters = {
        courseRoomId: courseRoomId,
        fileId: fileId
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/CourseRooms/DownloadLiterature/" + name, {
        data: parameters
    });
};

rwthapp.connection.api.l2p.downloadCourseRoomSharedDocument = function (name, courseRoomId, fileId) {
    var parameters = {
        courseRoomId: courseRoomId,
        fileId: fileId
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/CourseRooms/DownloadSharedDocument/" + name, {
        data: parameters
    });
};

rwthapp.connection.api.l2p.downloadCourseRoomDocument = function (name, courseRoomId, fileId) {
    var parameters = {
        courseRoomId: courseRoomId,
        fileId: fileId
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/CourseRooms/DownloadDocument/" +name, {
    data: parameters
});
};

rwthapp.connection.api.l2p.downloadCourseStructuredMaterial = function (name, courseRoomId, fileId) {
    var parameters = {
        courseRoomId: courseRoomId,
        fileId: fileId
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/CourseRooms/DownloadStructuredMaterial/" +name, {
    data: parameters
});
};

rwthapp.connection.api.l2p.getQuizOverview = function (courseRoomId) {
    var parameters = {
        courseRoomId: courseRoomId
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/Quiz/GetCourseRoomQuizzes", {
        data: parameters
    });
};

rwthapp.connection.api.l2p.getQuizOverviewAll = function () {
    var parameters = {
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/Quiz/GetQuizzes", {
        data: parameters
    });
};

rwthapp.connection.api.l2p.getQuiz = function (courseRoomId, id) {
    var parameters = {
        courseRoomId: courseRoomId,
        quizId: id
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("eLearning/Quiz/GetQuiz", {
        data: parameters
    });
};