﻿/// <reference path="../references.js" />
rwthapp.util.initNamespace("connection.api.library");

rwthapp.connection.api.library = (function () {

    var getAccount = function (clearCache) {

		var parameters = {
		    lang: rwthapp.localization.getCurrentLanguage(),
		    clearCache: clearCache
		};

		return rwthapp.connection.requestHelper.ajaxProxyApi("Library/GetAccount", {
		    data: parameters,
            cacheLocal: !clearCache
		});
	};

	var cancelRequestedItem = function (itemIdentifierValue) {

		var settings = { type: 'post', queryParameters: { mediaId: itemIdentifierValue, lang: rwthapp.localization.getCurrentLanguage() } };

		return rwthapp.connection.requestHelper.ajaxProxyApi("Library/CancelPrebookedMedia", settings);
	};

	var renewItem = function (itemIdentifierValue) {

		var settings = { type: 'post', queryParameters: { mediaId: itemIdentifierValue, lang: rwthapp.localization.getCurrentLanguage() } };

		return rwthapp.connection.requestHelper.ajaxProxyApi("Library/RenewLoanedMedia", settings);
	};

	return {
		getAccount: getAccount,
		cancelRequestedItem: cancelRequestedItem,
		renewItem: renewItem
	};
}());