﻿/// <reference path="../references.js" />
rwthapp.util.initNamespace("connection.api.photo");

rwthapp.connection.api.photo.uploadPhotoForRoom = function (content, roomId, userId, angle) {
    var queryParameters = {
        roomId: roomId,
        userId: userId,
        angle: angle
    };

    return rwthapp.connection.requestHelper.ajaxProxyApi("Rooms/Photos/Manage/AddForRoom", {
        queryParameters: queryParameters,
        data: content,
    	type: "post"
    });
};

rwthapp.connection.api.photo.ratePhotoWarning = function (photoId, userId) {
	var parameters = {
	    photoId: photoId,
	    userId: userId
	};

	return rwthapp.connection.requestHelper.ajaxProxyApi("Rooms/Photos/Manage/RateWarning", {
	    queryParameters: parameters,
	    data:{},
        type:"post"
	});
};

rwthapp.connection.api.photo.ratePhotoPositive = function (photoId, userId) {
	var parameters = {
	    photoId: photoId,
        userId:userId
	};

	return rwthapp.connection.requestHelper.ajaxProxyApi("Rooms/Photos/Manage/RatePositive", {
	    queryParameters: parameters,
	    data:{},
	    type: "post"
	});
};

rwthapp.connection.api.photo.getPhotosForRoom = function (roomId,userId) {
	var parameters = {
	    roomId: roomId,
        userId:userId
	};
	return rwthapp.connection.requestHelper.ajaxProxyApi("Rooms/Photos/GetPhotosForRoom", {
	    data: parameters
	});
};

rwthapp.connection.api.photo.getBestPhotosForRoom = function (roomId) {
	var parameters = {
		roomId: roomId
	};

	return rwthapp.connection.requestHelper.ajaxProxyApi("Rooms/Photos/GetBestPhotosForRoom", {
		data: parameters
	});
};
