﻿/// <reference path="../references.js" />

rwthapp.util.initNamespace("connection.oauth");

rwthapp.connection.oauth.startAuthentication = function (clientId, scopes) {
    /*jshint -W106 */
    var parameters = {
        client_id: clientId,
        scope: scopes
    };
    /*jshint +W106 */
    return rwthapp.connection.requestHelper.ajax({
        url: rwthapp.options.getOauthUrl() + "code",
        type: 'post',
        data: parameters
    });
};

/*rwthapp.connection.oauth.token = function (clientId, grantType, refreshToken, deviceCode, deviceOs, deviceName) {
    var parameters = {
        client_id: clientId,
        grant_type: grantType,
        refresh_token: refreshToken,
        code: deviceCode,
        device_os: deviceOs,
        device_name: deviceName
    };
    return rwthapp.connection.requestHelper.ajax({
        url: rwthapp.options.getOauthUrl() + "token",
        type: 'post',
        data: parameters
    });
};*/

rwthapp.connection.oauth.getAccessTokenAnonymous = function (clientId) {
    /*jshint -W106 */
    var parameters = {
        client_id: clientId,
        grant_type: 'anonymous'
    };
    /*jshint +W106 */
    return rwthapp.connection.requestHelper.ajax({
        url: rwthapp.options.getOauthUrl() + "token",
        type: 'post',
        data: parameters
    });
};

rwthapp.connection.oauth.checkAuthorization = function (clientId, deviceCode, deviceOs, deviceName) {
    /*jshint -W106 */
    var parameters = {
        client_id: clientId,
        grant_type: 'device',
        code: deviceCode,
        device_os: deviceOs,
        device_name: deviceName
    };
    /*jshint +W106 */
    return rwthapp.connection.requestHelper.ajax({
        url: rwthapp.options.getOauthUrl() + "token",
        type: 'post',
        data: parameters
    });
};

rwthapp.connection.oauth.getAccessTokenPersonalized = function (clientId, refreshToken) {
    /*jshint -W106 */
    var parameters = {
        client_id: clientId,
        grant_type: 'refresh_token',
        refresh_token: refreshToken
    };
    /*jshint +W106 */
    return rwthapp.connection.requestHelper.ajax({
        url: rwthapp.options.getOauthUrl() + "token",
        type: 'post',
        data: parameters
    });
};

rwthapp.connection.oauth.invalidateRefreshToken = function (clientId, refreshToken) {
    /*jshint -W106 */
    var parameters = {
        client_id: clientId,
        grant_type: 'invalidate',
        refresh_token: refreshToken
    };
    /*jshint +W106 */
    return rwthapp.connection.requestHelper.ajax({
        url: rwthapp.options.getOauthUrl() + "token",
        type: 'post',
        data: parameters
    });
};