﻿/// <reference path="../../references.js" />

rwthapp.util.initNamespace("templates.campus.details");

rwthapp.templates.campus.details.employees = {

    load : function (template, parameters) {

        return rwthapp.connection.api.campus.getEmployeeById(parameters.gguid).then(function (data) {

            var street = data.street.replace("(Post/Lieferanschrift)", "").trim();

            // Add navigation link
            data.mapLink = rwthapp.options.getMapsUrl() + "q=" + street + ",+" + data.zip + "+" + data.city;
            data.phone = rwthapp.util.fixPhoneFormat(data.phone);
            return {
                template: template,
                parameters: {
                    // accessible in campus.details.employees.tpl.html with #with notation
                    employee: data
                },
                title: rwthapp.localization.getLocalizedString("titles.employee"),
                subTitle: data.name + ", " + data.firstname,
                tabletMode: { links: ['#campus.search?type=employees'], position: 'left' }
            };
        });
    },

    ready : function () {

    },

    exit : function () {

    }
}