﻿/// <reference path="../../references.js" />

rwthapp.util.initNamespace("templates.campus.details");

rwthapp.templates.campus.details.rooms = (function(){
    var displayedRoom;

    var load = function (template, parameters) {
        return rwthapp.connection.api.campus.getRoomById(parameters.id).then(function (room) {
            // Add navigation link
            room.mapLink = rwthapp.options.getMapsUrl() + "q=" + room.address + ",+" + "Aachen";

            if (room.roomcontact && room.roomcontact.length > 0) {

                room.facilitymanager = room.roomcontact[0];

                // contactphone might be null delivered from campus
                if (room.facilitymanager.contactphone) {

                    room.facilitymanager.contactphone = room.facilitymanager.contactphone.split(",")[0].split("VPN")[0];
                    room.facilitymanager.contactphone = rwthapp.util.fixPhoneFormat(room.facilitymanager.contactphone);
                }
            }

            room.userId = rwthapp.tokenManager.getUserId();

            displayedRoom = room;

            return rwthapp.connection.api.photo.getBestPhotosForRoom(room.id).then(function (data) {
                for (var i = 0; i < data.length; i++) {
                    data[i].content = rwthapp.options.getProxyUrl() + data[i].content.replace("Thumb","Photo");
                }

                room.images = data;

                return {
                    template: template,
                    parameters: {
                        room: room
                    },
                    title:rwthapp.localization.getLocalizedString("titles.room"),
                    subTitle: room.roomname,
                    tabletMode: { links: ['#campus.search?type=rooms'], position: 'left' }
                };
            }).catch(function () {
                // Still show room details even if request for photos failed
                return {
                    template: template,
                    parameters: {
                        room: room
                    },
                    title: rwthapp.localization.getLocalizedString("titles.room"),
                    subTitle: room.roomname,
                    tabletMode: { links: ['#campus.search?type=rooms'], position: 'left' }
                };
            });
        });
    };

    var ready = function () {
        $('#maps').on("click", function (e) {
            window.open(rwthapp.options.getMapsUrl() + "q=" + displayedRoom.address + ",+" + "Aachen", "_system", "");
        });
        $('#camera').on("click", function (e) {
            rwthapp.cameraHelper.showPhotoDialog().then(function (photoData) {
                if (photoData !== undefined) {
                    rwthapp.connection.api.photo.uploadPhotoForRoom(photoData.b64, displayedRoom.id, rwthapp.tokenManager.getUserId(), photoData.angle).then(function (data) {
                        rwthapp.navigator.gotoPage("campus.details.rooms", { id: displayedRoom.id }, false);
                    });
                }
            });
            // TODO add error handling
        });

    };

    var exit = function () {

    };

    return {
        load: load,
        ready: ready,
        exit: exit
    };
})();