﻿/// <reference path="../../references.js" />

rwthapp.util.initNamespace("templates.campus.studentReport");

rwthapp.templates.campus.studentReport = {
    load: function (template, parameters) {
        return rwthapp.connection.api.campus.getStudentReport().then(function (data) {

            for (var i = 0; i < data.length; i++) {

                for (var j = 0; j < data[i].entries.length; j++) {

                    if (data[i].entries[j].lectureName && data[i].entries[j].lectureName.length > 40) {

                        data[i].entries[j].lectureNameShort = data[i].entries[j].lectureName.substring(0, 40) + "..";
                    }
                    else {

                        data[i].entries[j].lectureNameShort = data[i].entries[j].lectureName ? data[i].entries[j].lectureName : "-";
                    }
                }

                if (!data[i].modules) {

                    data[i].modules =[];
                }

                for (var j = 0; j < data[i].modules.length; j++) {

                    if (data[i].modules[j].moduleName && data[i].modules[j].moduleName.length > 40) {

                        data[i].modules[j].moduleNameShort = data[i].modules[j].moduleName.substring(0, 40) + "..";
                    }
                    else {

                        data[i].modules[j].moduleNameShort = data[i].modules[j].moduleName ? data[i].modules[j].moduleName: "-";
                    }
                }
            }

            return {

                template: template,
                parameters: {
                    report: data
                },
                title: rwthapp.localization.getLocalizedString("menu.organisation.studentReport")
            };

        }).catch(function (e) {

            return {

                template: template,
                parameters: {
                    report: {},
                    error: rwthapp.localization.getLocalizedString("errors.studentReport.no_report")
                },
                title: rwthapp.localization.getLocalizedString("titles.studentReport")
            };
        });
    },

    ready: function () {

        $('.collapsible').collapsible({

            accordion: false // A setting that changes the collapsible behavior to expandable instead of the default accordion style
        });
    },

    exit: function () {


    }
};