﻿/// <reference path="../../references.js" />

rwthapp.util.initNamespace("templates.canteen");

rwthapp.templates.canteen.info = {

    load: function (template, parameters) {
        var canteenId = parameters.canteenId;
        return rwthapp.connection.api.canteen.getCanteenInfo(canteenId).then(function (data) {
            return {
                template: template,
                parameters: {
                    info: data
                },
                title: rwthapp.localization.getLocalizedString("titles.canteenInfo"),
                subTitle: data.canteenName,
                tabletMode: { position: 'left', links: ['#canteen.overview'] }
            };
        });
    },

    ready: function () {
        $('.parallax').parallax();
    },

    exit: function () {
        
    }
};