﻿/// <reference path="../../references.js" />

rwthapp.util.initNamespace("templates.canteen");

rwthapp.templates.canteen.weekMenu = {

    load: function (template, parameters) {
        var canteenId = parameters.canteenId;
        return rwthapp.connection.api.canteen.getWeekMenu(canteenId).then(function (data) {
            var dayMenues = data.dayMenues;
            //deletes all dayMenues till today
            var today = 0;
            for (var i = 0; i < dayMenues.length; i++) {
                if (dayMenues[i].isToday == true) {
                    today = i;
                    break;
                }
            }
            data.dayMenues = dayMenues.slice(today, dayMenues.length);
            return {
                template: template,
                title: rwthapp.localization.getLocalizedString("titles.weekMenu"),
                subTitle: data.canteenName,
                parameters: {
                    weekMenu: data
                },
                tabletMode: { position: 'left', links: ['#canteen.overview'] }
            };
        });
    },

    ready: function () {

    },

    exit: function () {


    }
};