﻿/// <reference path="../references.js" />

rwthapp.util.initNamespace("templates");

rwthapp.templates.errorpage = {
    load: function (template, parameters) {
        var message = parameters.message;
        var targetPage = parameters.targetPage;
        var error = parameters.error;
        var detailedExplanation = "";

        if (error) {
            try {
                var errorObject = JSON.parse(error);
                var langString = rwthapp.localization.getLocalizedString("errorpage.detailedExplanation.e" + errorObject.code);
                if (langString) {
                    detailedExplanation = langString;
                }
            }
            catch (e) {

            }
        }

        return {
            template: template,
            parameters: {
                message: message,
                target: targetPage,
                error: error,
                detailedExplanation: detailedExplanation
            },
            title: rwthapp.localization.getLocalizedString("errorpage.title")
        };
    },
    ready: function () {
        // Replace errorpage navigation in history (if supported), skips error page on back navigation
        if (rwthapp.navigator.currentPage.target.parameters.targetPage) {
            rwthapp.navigator.replaceCurrentHashWithoutNavigation(rwthapp.navigator.currentPage.target.parameters.targetPage);
        }

        // History modification could cause retry link to be the same as current link, reload should still happen
        $('#button-retry').on('click', function () {
            if ($('#button-retry').attr('href') === location.hash) {
                $(window).trigger('hashchange');
                return false;
            }
        });
    },
    exit: function () {
        $('#button-retry').off('click');
    }
};