﻿/// <reference path="../references.js" />

rwthapp.util.initNamespace("templates");

rwthapp.templates.feedback = (function () {
    var error = null;
    var debugInformation = "";
    var lastFeedback = ""; // Store feedback in case an error occurs
    var email = null;
    var emailCache = "";

    var load = function (template, parameters) {


        error = null;
        debugInformation = "";

        if (parameters.error) {
            try {
                error = JSON.parse(parameters.error);
            } catch (e) {
                // Probably just an error string
                error = parameters.error;
            }

        }

        if (!parameters.debugInfo) {
            debugInformation = JSON.stringify(rwthapp.error.generateDebugInformation(error), null, 2);
        } else {
            debugInformation = parameters.debugInfo;
        }

        var disableSending = true;

        if (lastFeedback.length > 0) {

            disableSending = false;
        }
        
        if (rwthapp.tokenManager.isLoginPersonalized()) {

            return rwthapp.connection.api.getUserInfo().then(function (data) {

                email = data.EMail;
                var agreement = rwthapp.langStrings.feedback.emailAgreement.replace("@email@", email);

                return {
                    template: template,
                    parameters: {
                        debugInfo: debugInformation,
                        lastFeedback: lastFeedback,
                        email: email,
                        personalizedEmailAgreement: agreement,
                        disableSending: disableSending,
                        error: error
                    },
                    title: rwthapp.localization.getLocalizedString("feedback.title"),
                };
            }).catch(function () {
                // in case getUserInfo goes wrong still display feedback page!
                // TODO: remove duplicated code!
                return {
                    template: template,
                    parameters: {
                        debugInfo: debugInformation,
                        lastFeedback: lastFeedback,
                        emailCache: emailCache,
                        disableSending: disableSending,
                        error: error
                    },
                    title: rwthapp.localization.getLocalizedString("feedback.title"),
                };
            });
        }

        return {
            template: template,
            parameters: {
                debugInfo: debugInformation,
                lastFeedback: lastFeedback,
                emailCache: emailCache,
                disableSending: disableSending,
                error: error
            },
            title: rwthapp.localization.getLocalizedString("feedback.title"),
        };
    };

    var ready = function () {

        $('#button-send').on('click', function () {

            if ($(this).hasClass("disabled")) {

                return;
            }

            var sendEmailInfo = false;

            if (email) {

                if ($('#agree').attr("checked")) {

                    sendEmailInfo = email;
                }
            }
            else {

                if ($('#email').val().length > 0) {

                    sendEmailInfo = $('#email').val();
                }
            }

            if (sendEmailInfo) {

                debugInformation = JSON.parse(debugInformation);
                debugInformation.email = sendEmailInfo;
                debugInformation = JSON.stringify(debugInformation, null, 2);
            }

            rwthapp.util.showLoadingScreen();

            var feedback = $('#feedback').val();
            // Store feedback to restore it in error case
            lastFeedback = feedback;
            emailCache = sendEmailInfo;
            rwthapp.connection.api.sendFeedback(feedback, debugInformation).then(function () {
                rwthapp.util.hideLoadingScreen();

                // Feedback was send, remove stored feedback
                lastFeedback = "";
                emailCache = "";

                // Show success message
                rwthapp.notifications.showToastShort(rwthapp.localization.getLocalizedString("feedback.toastSuccess"));

                rwthapp.navigator.gotoPage("home");
            }).catch(function (error) {
                rwthapp.error.handleError(error);
            });

            return false;
        });

        $('#feedback').on('keyup', function (e) {

            if ($(this).val().length > 0) {

                $('#button-send').removeClass("disabled");
            }
            else {

                $('#button-send').addClass("disabled");
            }
        });

        if (rwthapp.tokenManager.isLoginPersonalized()) {

            $("#agree").on("click", function () {

                $("#agree").attr("checked", "");
                $("#deny").removeAttr("checked");
            });

            $("#deny").on("click", function () {

                $("#deny").attr("checked", "");
                $("#agree").removeAttr("checked");
            });
        }
    };

    var exit = function () {
        $('#button-send').off('click');
    };

    return {
        load: load,
        ready: ready,
        exit: exit

    };
})();