﻿/// <reference path="../../references.js" />

rwthapp.util.initNamespace("templates.organisation");

rwthapp.templates.freshmen = {

    load: function (template, parameters) {

        return rwthapp.connection.api.getFreshmenInfo().then(function (data) {

            var error;
            if (data.length < 1) {

                error = rwthapp.localization.getLocalizedString("errors.freshmen.noInfos");
            }

            return {
                template: template,
                parameters: {
                    entries: data,
                    error:error
                },
                title: rwthapp.localization.getLocalizedString("freshmen.info")
            };
        });
    }
};