﻿/// <reference path="../../references.js" />

rwthapp.util.initNamespace("templates.l2p.courseDetails");

rwthapp.templates.l2p.courseDetails.announcements = {
    courseId: "",
    title: "",
    load: function (template, parameters) {
        var me = this;
        this.courseId = parameters.courseid;
        this.title = parameters.title;
        return rwthapp.connection.api.l2p.getCourseAnnouncements(parameters.courseid).then(function (data) {
            return {
                template: template,
                parameters: { entries: data, title: parameters.title },
                title: rwthapp.localization.getLocalizedString("l2p.details.announcements"),
                subTitle: parameters.title,
                tabletMode: { position: 'left', links: ['#l2p.courseList'] }
            };
        });
    },

    ready: function () {
        var me = this;
        rwthapp.downloadL2PHelper.init({ f: "getCourseRoomAnnouncementDocuments", f_name: "eLearning/CourseRooms/DownloadAnnouncementAttachment/", courseid: me.courseId, title: me.title });
        $(".file-download").click(function () {
            rwthapp.downloadL2PHelper.downloadFile($(this).data("filename"), $(this).data("fileid"), $(this).data("folder"));
        });
    }
};