﻿/// <reference path="../../references.js" />

rwthapp.util.initNamespace("templates.l2p.courseDetails");

rwthapp.templates.l2p.courseDetails.hyperlinks = {
    courseId: "",
    title: "",
    load: function (template, parameters) {
        var me = this;
        this.courseId = parameters.courseid;
        this.title = parameters.title;
        return rwthapp.connection.api.l2p.getCourseRoomHyperlinks(parameters.courseid).then(function (data) {
            return {
                template: template,
                parameters: { entries: data, title: parameters.title },
                title: rwthapp.localization.getLocalizedString("l2p.details.hyperlinks"),
                subTitle: parameters.title,
                tabletMode: { position: 'left', links: ['#l2p.courseList'] }
            };
        });
    },
    
    ready: function () {
        var me = this;
        $(".openLink").click(function () {
            window.open($(this).data("url"), "_system");
        });
    }
};