﻿/// <reference path="../../references.js" />

rwthapp.util.initNamespace("templates.l2p");

rwthapp.templates.l2p.courseDetails = {
    courseId: "",
    title: "",
    load: function (template, parameters) {
        this.courseId = parameters.courseid;
        this.title = parameters.title;
        var me = this;
        return rwthapp.connection.api.l2p.getCourseRoomOverview(parameters.courseid).then(function (data) {
            // TODO improve detection, differentiate between empty and no permission
            var notEmpty = false;
            for (var key in data) {
                if (key !== "courseInformation" && data[key] !== 0) {
                        notEmpty = true;
                }
                
            }
            var error = notEmpty ? "" : rwthapp.localization.getLocalizedString("errors.courseDetails.noContent");
            return {
                template: template,
                parameters: { overview: data, title: me.title, error: error },
                title: rwthapp.localization.getLocalizedString("titles.courseDetails"),
                subTitle: me.title,
                tabletMode: { position: 'left', links: ['#l2p.courseList'] }
            };
        });
    },

    ready: function () {
        var me = this;
        $("#quizzes").click(function () {
            rwthapp.navigator.gotoPage("l2p.quizOverview", {tablet_support:"l2p.quiz",courseid:me.courseId,title:me.title}, true);
        });
        $("#literature").click(function () {
            rwthapp.navigator.gotoPage("l2p.courseDetails.literature", { f: "getCourseRoomLiterature", f_name: "eLearning/courseRooms/DownloadLiterature/", courseid: me.courseId, title: me.title, mode: "literature" }, true);
        });
        $("#structuredMaterials").click(function () {
            rwthapp.modal.createModal(rwthapp.downloadL2PHelper.init, "modal.downloadL2P", { f: "getCourseRoomStructuredMaterials", f_name: "eLearning/courseRooms/DownloadStructuredMaterial/", courseid: me.courseId, title: me.title });
        });
        $("#documents").click(function () {
            rwthapp.modal.createModal(rwthapp.downloadL2PHelper.init, "modal.downloadL2P", { f: "getCourseRoomDocuments", f_name: "eLearning/courseRooms/DownloadDocument/", courseid: me.courseId, title: me.title });
        });
        $("#sharedDocuments").click(function () {
            rwthapp.modal.createModal(rwthapp.downloadL2PHelper.init, "modal.downloadL2P", { f: "getCourseRoomSharedDocuments", f_name: "eLearning/courseRooms/DownloadSharedDocument/", courseid: me.courseId, title: me.title });
        });
        $("#announcements").click(function () {
            rwthapp.navigator.gotoPage("l2p.courseDetails.announcements", { courseid: me.courseId, title: me.title }, true);
        });
        $("#emails").click(function () {
            rwthapp.navigator.gotoPage("l2p.courseDetails.emails", { courseid: me.courseId, title: me.title }, true);
        });
        $("#hyperlinks").click(function () {
            rwthapp.navigator.gotoPage("l2p.courseDetails.hyperlinks", { courseid: me.courseId, title: me.title }, true);
        });
    }
};