﻿/// <reference path="../../references.js" />

rwthapp.util.initNamespace("templates.l2p.courseDetails");

rwthapp.templates.l2p.courseDetails.literature = {
    config: {},
    load: function (template, parameters) {
        this.config = parameters;

        return {
            template: template,
            parameters: {},
            title: rwthapp.localization.getLocalizedString("l2p.details.literature"),
            subTitle: parameters.title,
            tabletMode: { position: 'left', links: ['#l2p.courseList'] }
        };

    },
    ready: function () {
        rwthapp.util.showLoadingScreen();
        rwthapp.downloadL2PHelper.init(this.config).then(function () { rwthapp.util.hideLoadingScreen(); }).catch(function () { rwthapp.util.hideLoadingScreen(); });
    }
};