﻿/// <reference path="../../references.js" />

rwthapp.util.initNamespace("templates.l2p");

rwthapp.templates.l2p.courseList = (function(){
    var oldestTerm = 3;

    var load = function (template, parameters) {
		var calls = [];

		for (var i = 0; i <= oldestTerm; i++) {
            calls.push(loadTerm(i));
        }

		return Promise.all(calls).then(function (result) {
            return {
                template: template,
                parameters: { courses: result },
                title: rwthapp.localization.getLocalizedString("menu.elearning.l2p"),
                subTitle: rwthapp.localization.getLocalizedString("subTitles.courseList"),
                tabletMode: { position: 'right', mainView: true }
            };
        });
    };

    var ready = function () {
        $("#load_older").click(function () {
            oldestTerm += 1;
            loadTerm(oldestTerm).then(function(semesterResult) {
                var semesterCourses = rwthapp.templateRenderer.fetch("l2p.courseList.partial", { semesterResult: semesterResult });
                $("#course_list").append(semesterCourses);

                // Perform postprocessing (fixing icons, removing waves effect) if necessary
                rwthapp.templateRenderer.performPostprocessing();
            });
        });
    };

    var loadTerm = function (term) {
        return rwthapp.connection.api.l2p.getCourses(term).then(function (data) {
            if (data.length > 0) {
                var termName = getSemesternameFromCourseId(data[0].CourseId);

                for (var i = 0; i < data.length; i++) {
                    // Check if course room is closed
                    if (data[i].Status === "closed" // l2p 2013
                            || data[i].Status === "0" || data[i].Status === "3") { // l2p 2007
                        data[i].Closed = true;
                    } else {
                        data[i].Closed = false;
                    }
                }

                // Sort course rooms (push to end if closed)
                for (var i = data.length - 1; i >= 0; i--) {
                    if (data[i].Closed === true) {
                        // Move element to the end of the array
                        var element = data[i];
                        data.splice(i, 1);
                        data.push(element);
                    }
                }

                return {
                    courseList: data,
                    termName: termName
                };
            } else {
                return;
            }
        });
    };

    var getSemesternameFromCourseId = function (courseId) {
        var termKey = courseId.split("-")[0];

        var semesterType = termKey.substr(2, 2);
        var semesterYear = (parseInt(termKey.substr(0, 2)) < 50 ? "20" : "19") + termKey.substr(0, 2);

        var termName = semesterType === "ws" ? rwthapp.localization.getLocalizedString("l2p.ws") : rwthapp.localization.getLocalizedString("l2p.ss");
        termName += " " + semesterYear;

        if (semesterType === "ws") {
            termName += "/" + (parseInt(semesterYear) + 1);
        }

        return termName;
    };

    return {
        ready: ready,
        load: load,
    };
})();