﻿/// <reference path="../../references.js" />

rwthapp.util.initNamespace("templates.l2p.news");

var l2pSections = new Array("Announcements", "EMails", "StructuredMaterials", "SharedDocuments", "Hyperlinks");

rwthapp.templates.l2p.news = {

    load: function (template, parameters) {
        var me = this;        
        return rwthapp.connection.api.l2p.getL2PSPEvents('14', '0').then(function (data) {
            var dataToShow = [];
            for (var i = 0; i < data.length; i++) {
                var s = data[i].Section.split(".")[data[i].Section.split(".").length - 1];
                if ($.inArray(s, l2pSections) != -1) {
                    dataToShow.push(data[i]);
                }
            }
            return {
                template: template,
                parameters: { entries: dataToShow, title: parameters.title },
                title: rwthapp.localization.getLocalizedString("l2p.news.news"),
                subTitle: rwthapp.localization.getLocalizedString("l2p.news.newsLastDays")
            };
        });
    },

    ready: function () {
        var me = this;
    }
};