﻿/// <reference path="../../references.js" />
 
rwthapp.util.initNamespace("templates.l2p");

rwthapp.templates.l2p.quiz = {
    load: function (template, parameters) {
        
        Quiz.Mediator.load(parameters.courseid, parameters.id,parameters.main);
        $("#overlayQuiz").show();
        return {
            template: template,
            parameters: {},
            title:rwthapp.localization.getLocalizedString("l2p.details.quizzes"),
            subTitle: parameters.title,
            tabletMode: { position: 'left', links: ['#l2p.quizOverview'] }
        };
    },
    ready: function () {
        try{
            Quiz.Mediator.retrieveData();
            $("#overlayQuiz").hide();
        } catch (e) {
            $("#overlayQuiz").hide();
            $("#quizContent").html(rwthapp.templateRenderer.fetch("errorpartial", { message: e.message }));

            // Perform postprocessing (fixing icons, removing waves effect) if necessary
            rwthapp.templateRenderer.performPostprocessing();
        }
    }
};