﻿/// <reference path="../../references.js" />

rwthapp.util.initNamespace("templates.l2p");
 
rwthapp.templates.l2p.quizOverview = {
    course: {},
    title: "",
    load: function (template, parameters) {
        var me = this;
        this.title = parameters.title||"";
        Quiz.Mediator.initCache();
        Quiz.Mediator.checkConnection();
        if (Quiz.Mediator.online) {
            return (parameters.courseid ? rwthapp.connection.api.l2p.getQuizOverview(parameters.courseid) : rwthapp.connection.api.l2p.getQuizOverviewAll()).then(function (data) {
                return me.init(data, template, parameters);
            }).catch(function (e) {
                return {
                    template: template,
                    parameters: { overview: {}, error: rwthapp.localization.getLocalizedString("errors.quiz.quizOverviewNoCourse") },
                    title: rwthapp.localization.getLocalizedString("l2p.details.quizzes"),
                    subTitle: parameters.title
                };
            });
        } else {
            var storage = new rwthapp.Storage("quizOverview");
            var data = storage.getItem("overviewCache" + parameters.courseid || "");
            return me.init(data, template, parameters);
        }
    },
    init: function (data, template, parameters) {
        try {
            var overview = data.data;
            var x = Quiz.Mediator.cache;
            for (var i = 0; i < overview.length; i++) {
                for (var j = 0; j < overview[i].courseQuiz.length; j++) {
                    overview[i].courseQuiz[j].courseId = overview[i].courseName;
                    if (Quiz.Mediator.hasCache(overview[i].courseName, overview[i].courseQuiz[j].id)) {
                        overview[i].courseQuiz[j].offlineAvailable = 1;
                    } else {
                        overview[i].courseQuiz[j].offlineAvailable = 0;
                    }
                    overview[i].courseQuiz[j].main = parameters.courseid ? false : true
                }
            }
            var storage = new rwthapp.Storage("quizOverview");
            storage.setItem("overviewCache" + parameters.courseid || "", data);
            if (overview.length > 0) {
                return {
                    template: template,
                    parameters: { overview: overview },
                    title: rwthapp.localization.getLocalizedString("l2p.details.quizzes"),
                    subTitle: parameters.courseid ? this.title : "",
                    tabletMode: { position: 'right', mainView: true }
                };
            } else {
                return {
                    template: template,
                    parameters: { overview: {}, error: rwthapp.localization.getLocalizedString("errors.quiz.quizOverviewNoCourse") },
                    title: rwthapp.localization.getLocalizedString("l2p.details.quizzes"),
                    subTitle: parameters.courseid ? this.title : ""
                };
            }
        } catch (e) {
            return {
                template: template,
                parameters: { overview: {}, error: rwthapp.localization.getLocalizedString("errors.quiz.quizOverviewNoCourse") },
                title: rwthapp.localization.getLocalizedString("l2p.details.quizzes")
            };
        }
    },
    ready: function () {
        $(".quizz").on("click", function () {
            Quiz.Mediator.checkConnection();
            if ($(this).hasClass("offline")||Quiz.Mediator.online) {
                rwthapp.navigator.gotoPage("l2p.quiz", { title: $(this).data("title"), id: $(this).data("id"), courseid: $(this).data("courseid"),main:$(this).data("main") }, true);
            } else {
                rwthapp.notifications.showToastShort(rwthapp.localization.getLocalizedString("errors.quiz.quizNotOffline"))
            }
        });
    },
    exit: function () {
        $(".quizz").off("click");
    }
};