﻿/// <reference path="../../references.js" />

rwthapp.util.initNamespace("templates.organisation");

rwthapp.templates.organisation.feeds = {

    load: function (template, parameters) {

        return rwthapp.options.feeds.getAvailableFeedsAndPersistInStorage().then(function (result) {

            var feed_string = '';

            $.each(result.feeds, function (index, value) {

                var feedId = value.id;

                if (value.isActive) {

                    feed_string += feedId + ",";
                }
            });

            return rwthapp.connection.api.getHomepageFeed(feed_string, 10, 0).then(function (data) {

                var error;

                if (data.length < 1) {

                    error = rwthapp.localization.getLocalizedString("errors.feeds.noFeeds");
                }

                return {
                    template: template,
                    parameters: {
                        entries: data,
                        error: error,
                        proxy: rwthapp.config.urls.proxy[rwthapp.config.activeProxy]
                    },
                    title: rwthapp.localization.getLocalizedString("menu.organisation.feeds"),
                };
            });
        });
    }
};