﻿/// <reference path="../references.js" />

rwthapp.util.initNamespace("templates");

rwthapp.templates.settings = {
    load: function (template, parameters) {

        var languages = rwthapp.localization.getAvailableLanguages();
        var currentLanguage = rwthapp.localization.getCurrentLanguage();

        for (var i = 0; i < languages.length; i++) {

            languages[i].active = languages[i].id === currentLanguage;
        }

        var vibration = rwthapp.options.vibration.isEnabled();
        var wavesEffect = rwthapp.options.wavesEffect.isEnabled();

        return rwthapp.options.feeds.getAvailableFeedsAndPersistInStorage().then(function (result) {

            return {
                template: template,
                parameters: {
                    languages: languages,
                    feeds: result.feeds,
                    error: result.error,
                    vibration: vibration,
                    wavesEffect: wavesEffect,
                },
                title: rwthapp.localization.getLocalizedString("menu.settings"),
            }
        });
    },

    ready: function () {

        var feeds = rwthapp.options.feeds.getCachedFeeds();

        $.each(feeds, function (index, value) {

            var feedId = value.id;

            $("#" + feedId).on("click", function () {

                var id = $(this).attr('id');
                var checked = $(this).prop("checked");

                rwthapp.options.feeds.setActive(id, rwthapp.options.feeds.getCachedFeed(id), checked);
            });
        });

        $('#languageSelect').on('change', function () {

            var lang = $("#languageSelect option:selected").val();

            rwthapp.localization.setLanguage(lang, true);

            rwthapp.templates.menu.initMenuLang();
            // Reload page
            rwthapp.navigator.gotoPage("settings", { _: Date.now() }, false);
        });

        $('#vibrationCheckbox').on('change', function () {

            var checked = $(this).prop("checked");

            rwthapp.options.vibration.set(checked);
        });

        $('#wavesEffectCheckbox').on('change', function () {
            var checked = $(this).prop("checked");

            rwthapp.options.wavesEffect.set(checked);
        });

        $('#showChangelog').on('click', function () {
            rwthapp.updater.showChangelog();
        });

        $('#clearData').on('click', function () {

            rwthapp.notifications.showConfirmationDialog(
                    rwthapp.localization.getLocalizedString("settings.clearData.confirmationText"),
                    rwthapp.localization.getLocalizedString("settings.clearData.confirmationAgree"),
                    rwthapp.localization.getLocalizedString("settings.clearData.confirmationCancel")).then(function (userAgreed) {

                        if (userAgreed) {

                    localStorage.clear();
                    window.location.reload();
                }
            });
        });
    },

    exit: function () {

        $('#languageSelect').off('change');
        $('#vibrationCheckbox').off('change');
        $('#login').off('click');
        $('#clearData').off('click');
    }
};