﻿/// <reference path="../references.js" />

rwthapp.util.initNamespace("templates");

rwthapp.templates.update = {
    load: function (template, parameters) {
        // Disable all further navigation
        rwthapp.navigator.disableNavigation();

        // TODO create helper method to disable favorite button
        $("#favorite").hide();

        var imageURL = rwthapp.options.getStoreImageUrl();
        var storeURL = rwthapp.options.getStoreUrl();

        return {
            template: template,
            parameters: {
                storeURL: storeURL,
                imageURL: imageURL
            },
            title: rwthapp.localization.getLocalizedString("titles.update"),
        };
    },
    ready: function () {

    },
    exit: function () {

    }
};