﻿/// <reference path="../references.js" />

rwthapp.cameraHelper = (function () {
    var rotationAngle = 0;
    var rippleImage = "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";

    var rotateImage = function () {
        rotationAngle = (rotationAngle + 90) % 360;
        $("#modal-picture").rotate(rotationAngle);
    };

    var setHeader = function (header_text) {
        $("#modal-header").html(header_text);
    };

    var setPicture = function (b64) {
        $("#modal-picture").attr("src", "data:image/gif;base64," + b64);
        $("#modal-picture").show();
        // Enable upload once picture is set
        enableUploadButton();
    };

    var enableUploadButton = function () {
        $("#modal-button-agree").removeClass("disabled");
    };

    var takePhoto = function () {
        return new Promise(function (resolve, reject) {
            if (rwthapp.platformInfo.isRipple()) {
                resolve(rippleImage);
            } else {
                navigator.camera.getPicture(
                    function (b64) {
                        resolve(b64);
                    }, function () {
                        reject();
                    }, {
                        quality: 90, // TODO https://github.com/apache/cordova-plugin-camera#ios-quirks-1 (quality lower than 50 needed for iOS?)
                        destinationType: Camera.DestinationType.DATA_URL,
                        correctOrientation: true,
                        sourceType: Camera.PictureSourceType.CAMERA,
                    });
            }
        });
    };

    var getPhotoFromGallery = function () {
        return new Promise(function (resolve, reject) {
            if (rwthapp.platformInfo.isRipple()) {
                resolve(rippleImage);
            } else {
                navigator.camera.getPicture(
                    function (b64) {
                        resolve(b64);
                    }, function () {
                        reject();
                    }, {
                        destinationType: Camera.DestinationType.DATA_URL,
                        correctOrientation: true,
                        sourceType: Camera.PictureSourceType.PHOTOLIBRARY,
                    });
            }
        });
    };

    var showPhotoDialog = function () {
        return new Promise(function (resolve, reject) {
            var photoB64;

            var modalInit = function () {
                rotationAngle = 0;


                // Bind event handlers
                $("#modal-button-agree").on("click", function () {
                    if (photoB64 !== undefined) {
                        resolve({
                            b64: photoB64,
                            angle: rotationAngle
                        });
                    } else {
                        resolve();
                    }
                });

                // TODO upload button can be click even if it is disabled

                $("#modal-button-rotate").on("click", function () {
                    rotateImage();
                });

                $("#modal-button-take-picture").on("click", function () {
                    // Use camera to get a picture
                    takePhoto().then(function (photo) {
                        $("#modal-camera-source-buttons").hide();
                        setPicture(photo);
                        photoB64 = photo;
                    });
                });

                $("#modal-button-picture-from-gallery").on("click", function () {
                    // Get a picture from the gallery
                    getPhotoFromGallery().then(function (photo) {
                        $("#modal-camera-source-buttons").hide();
                        setPicture(photo);
                        photoB64 = photo;
                    });
                });
            };

            rwthapp.modal.createModal(modalInit, "modal.takePhoto").then(function () {
                resolve();
            });
        });
    };

    return {
        takePhoto: takePhoto,
        getPhotoFromGallery: getPhotoFromGallery,
        showPhotoDialog: showPhotoDialog,
    };
})();