﻿/// <reference path="../references.js" />

(function () {
    var rwthBlue= {
        "lighten-4":  "#E8F1FA",
        "lighten-3":  "#C7DDF2",
        "lighten-2":  "#8EBAE5",
        "lighten-1":  "#407FB7",
        "base":       "#00549F",
        "darken-7":   "#00417A",
    };

    var rwthBlack= {
        "lighten-4":  "#ECEDED",
        "lighten-3":  "#CFD1D2",
        "lighten-2":  "#9C9E9F",
        "lighten-1":  "#646567",
        "base":       "#000000"
    };

    var rwthMagenta= {
        "lighten-4":  "#FDEEF0",
        "lighten-3":  "#F9D2DA",
        "lighten-2":  "#F19EB1",
        "lighten-1":  "#E96088",
        "base":       "#E30066"
    };

    var rwthYellow= {
        "lighten-4":  "#FFFDEE",
        "lighten-3":  "#FFFAD1",
        "lighten-2":  "#FFF59B",
        "lighten-1":  "#FFF055",
        "base":       "#FFED00"
    };

    var rwthPetrol= {
        "lighten-4":  "#E6ECEC",
        "lighten-3":  "#BFD0D1",
        "lighten-2":  "#7DA4A7",
        "lighten-1":  "#2D7F83",
        "base":       "#006165"
    };

    var rwthTurquoise= {
        "lighten-4":  "#EBF6F6",
        "lighten-3":  "#CAE7E7",
        "lighten-2":  "#89CCCF",
        "lighten-1":  "#00B1B7",
        "base":       "#0098A1"
    };

    var rwthGreen= {
        "lighten-4":  "#F2F7EC",
        "lighten-3":  "#DDEBCE",
        "lighten-2":  "#B8D698",
        "lighten-1":  "#8DC060",
        "base":       "#57AB27"
    };

    var rwthMaigreen= {
        "lighten-4":  "#F9FAED",
        "lighten-3":  "#F0F3D0",
        "lighten-2":  "#E0E96A",
        "lighten-1":  "#D0D95C",
        "base":       "#BDCD00"
    };

    var rwthOrange= {
        "lighten-4":  "#FFF7EA",
        "lighten-3":  "#FEEAC9",
        "lighten-2":  "#FDD48F",
        "lighten-1":  "#FABE50",
        "base":       "#F6A800"
    };

    var rwthRed= {
        "lighten-4":  "#FAEBE3",
        "lighten-3":  "#F3CDBB",
        "lighten-2":  "#E69679",
        "lighten-1":  "#D85C41",
        "base":       "#CC071E"
    };

    var rwthBordeaux= {
        "lighten-4":  "#F5E8E5",
        "lighten-3":  "#E5C5C0",
        "lighten-2":  "#CD8B87",
        "lighten-1":  "#B65256",
        "base":       "#A11035"
    };

    var rwthViolett= {
        "lighten-4":  "#EDE5EA",
        "lighten-3":  "#D2C0CD",
        "lighten-2":  "#A8859E",
        "lighten-1":  "#834E75",
        "base":       "#612158"
    };

    var rwthLavender= {
        "lighten-4":  "#F2F0F7",
        "lighten-3":  "#DEDAEB",
        "lighten-2":  "#BCB5D7",
        "lighten-1":  "#9B91C1",
        "base":       "#7A6FAC"
    };

    var rwthWhite= {
        "base": "#FFFFFF"
    };

    var rwthColors= {
        "blue":      rwthBlue,
        "black":     rwthBlack,
        "magenta":   rwthMagenta,
        "yellow":    rwthYellow,
        "petrol":    rwthPetrol,
        "turquoise": rwthTurquoise,
        "green":     rwthGreen,
        "maigreen":  rwthMaigreen,
        "orange" :   rwthOrange,
        "red":       rwthRed,
        "bordeaux":  rwthBordeaux,
        "violett":   rwthViolett,
        "lavender":  rwthLavender,
        "white":     rwthWhite
    };

    rwthapp.colors = {};

    rwthapp.colors.getColor = function (color, type) {
        if (!type) type = "base";
        return rwthColors[color][type];
    };    

    for (var color in rwthColors) {
        (function(c){
            rwthapp.colors[c] = function (type) {
                return rwthapp.colors.getColor(c, type);
            };
        })(color);
    }
})();