﻿/// <reference path="../references.js" />

rwthapp.util.initNamespace("favorites");

var favCounter = 0;

var RWTHFavorite = function (route, title, isHomeScreen) {

    if (!isHomeScreen) {

        isHomeScreen = false;
    }

    this.route = route;
    this.title = title;
    this.visible = true;
    this.icon = 'star';
    this.isHomeScreen = isHomeScreen;
    this.isFavorite = true;
    this.favId = favCounter;
    favCounter++;
};

var resetHomeScreenFromOther = null, 
    persistFavorites = null;

RWTHFavorite.prototype.isEquivalent = function (compare) {

    if (!compare) {

        return false;
    }

    // check if favorites route equals for equality
    if (this.route !== compare.route) {

        return false;
    }

    // If we made it this far, objects
    // are considered equivalent
    return true;
};

RWTHFavorite.prototype.setHomeScreen = function (isHomeScreen) {

    this.isHomeScreen = isHomeScreen;

    if(this.isHomeScreen) {

        resetHomeScreenFromOther(this);
    }
    else {

        persistFavorites();
    }
}

rwthapp.favorites = (function () {

    var list = [];

    var favoritesStorage = new rwthapp.Storage("rwthapp.favorites");

    var initFromLocalStorage = function () {

        var storedList = favoritesStorage.getItem('favorites');

        // storedList contains objects and no RWTHFavorites, calls to isEquivalent or other 
        // prototype methods will fail because the object parsed from JSON is not associated
        // with this method, so we need to create new favorite with the parsed data
        if (storedList && storedList.length > 0) {

            storedList.forEach(function (element, index) {

                createRWTHFavorite(element.route, element.title, element.isHomeScreen);
            });
        }
    };

    var createRWTHFavorite = function (route, title, isHomeScreen) {

        var favorite = new RWTHFavorite(route, title, isHomeScreen);

        addRWTHFavorite(favorite);
    };

    var removeRWTHFavorite = function (favoritesRoute) {

        var result = false;

        if (favoritesRoute && favoritesRoute !== '') {

            $.each(list, function (index, value) {

                if (value.route === favoritesRoute) {

                    list.splice(index, 1);

                    if (list.length === 0) {

                        favoritesStorage.removeItem('favorites');
                    }
                    else {

                        persistFavorites();
                    }
                    result = true;
                    return false;
                }
            });
        }

        return result;
    };

    var getRWTHFavorite = function (hash) {

        var result = null;

        $.each(list, function (index, value) {

            if (value.route === hash) {

                result = value;

                return false;
            }
        });

        return result;
    };

    var getRWTHFavorites = function () {

        return list;
    };

    var getRWTHHomeFavorite = function () {

        var home = null;

        $.each(list, function (index, value) {

            if (value.isHomeScreen) {

                home = value;

                return false;
            }
        });

        return home;
    };

    var getFirstThreeRWTHFavoritesAndHomeScreen = function () {

        var result = [];
        var home = null;

        $.each(list, function (index, value) {

            if (value.isHomeScreen) {

                home = value;
            }
            else {

                if (result.length < 3) {

                    result.push(value);
                }
            }

            if (result.length === 3 && home) {

                return false;
            }
        });

        if (home) {

            result.unshift(home);
        }

        return result;
    };

    var addRWTHFavorite = function (favorite) {

        if (!isFavoriteAlreadySet(favorite)) {

            list.push(favorite);

            persistFavorites();
        }
    };

    var removeAll = function () {

        list = [];
        favoritesStorage.removeItem('favorites');
    };

    var isFavoriteAlreadySet = function(favorite) {

        var route, result = false;

        if (favorite !== undefined && !(favorite instanceof RWTHFavorite)) {

            route = favorite;
        }
        else if (!favorite) {

            return false;
        }

        $.each(list, function (index, value) {

            if (route !== undefined) {

                if (route === value.route) {

                    result = true;
                    return false
                }
            }
            else {

                if (value.isEquivalent(favorite)) {

                    result = true;
                    return false;
                }
            }
        });

        return result;
    };

    persistFavorites = function () {

        favoritesStorage.setItem("favorites", list);
    };

    resetHomeScreenFromOther = function (favorite) {

        $.each(list, function (index, value) {

            if (!value.isEquivalent(favorite)) {

                value.setHomeScreen(false);
            }
        });

        persistFavorites();
    }

    return {

        removeRWTHFavorite: removeRWTHFavorite,
        getRWTHFavorite: getRWTHFavorite,
        getRWTHFavorites: getRWTHFavorites,
        getRWTHHomeFavorite: getRWTHHomeFavorite,
        getFirstThreeRWTHFavoritesAndHomeScreen: getFirstThreeRWTHFavoritesAndHomeScreen,
        addRWTHFavorite: addRWTHFavorite,
        removeAll: removeAll,
        isFavoriteAlreadySet: isFavoriteAlreadySet,
        initFromLocalStorage: initFromLocalStorage,
        createRWTHFavorite: createRWTHFavorite
    };

})();



