﻿/// <reference path="../references.js" />

var rwthapp = rwthapp || {};

rwthapp.fileManager = (function () {
    var me = {};

    me.createFolder = function (folder) {
        return new Promise(function (resolve, reject) {
            window.requestFileSystem(LocalFileSystem.PERSISTENT, 0, function (fs) {
                function createDir(rootDirEntry, folders) {
                    if (folders[0] == '.' || folders[0] == '') {
                        folders = folders.slice(1);
                    }
                    rootDirEntry.getDirectory(folders[0], { create: true }, function (dirEntry) {
                        if (folders.length > 2) {
                            return createDir(dirEntry, folders.slice(1));
                        } else {
                            return resolve(dirEntry);
                        }

                    }, function (err) {
                        reject(err);
                    });
                }
                return createDir(fs.root, folder.split('/'));
            });
        });
    };

    me.downloadFile = function (url, name, folder) {
        return new Promise(function (resolve, reject) {
            if (rwthapp.platformInfo.isAndroid()) {
                //if (rwthapp.platformInfo.isAndroid()) {
                rwthapp.util.showLoadingScreen();
                me.createFolder(folder).then(function (dirEntry) {
                    dirEntry.getFile(
                        name,
                        {
                            create: true,
                            exclusive: false
                        },
                        function gotFileEntry(fe) {
                            var p = fe.toURL();
                            fe.remove();
                            var ft = new FileTransfer();
                            ft.download(
                                encodeURI(url),
                                p,
                                function (entry) {
                                    rwthapp.util.hideLoadingScreen();
                                    resolve(true);
                                },
                                function (error) {
                                    rwthapp.util.hideLoadingScreen();
                                    reject(false);
                                },
                                false,
                                null
                            );
                        },
                        function () {
                            rwthapp.util.hideLoadingScreen();
                            reject(false);
                        }
                    );
                });
            } else window.open(url, "_system");
        });
            /*.then(
            function () { rwthapp.notifications.showToastLong("<p>" + name + rwthapp.localization.getLocalizedString("l2p.details.toastDownloadSuccess") + "</p>"); },
            function () { rwthapp.notifications.showToastLong("<p>" + rwthapp.localization.getLocalizedString("l2p.details.toastDownloadFailed")); }
        );*/
    };

    return me;
})();
