﻿/// <reference path="../references.js" />

var rwthapp = rwthapp || {};

rwthapp.fileRenderer = (function () {
        var folders = {};

        var Folder = function (path) {
            var pathParts = path.split('/');
            // assume path ends with / => slice(-1) is empty
            this.name = pathParts.slice(-2)[0] || '/';
            this.children = [];
            this.path = path;
            this.is_file = false;

            this.getParentFolder = function () {
                if (this.path == '/') return null;
                var lastPos = this.path.slice(0, -1).lastIndexOf('/');
                return new Folder(this.path.slice(0, lastPos + 1));
            };

            this.addChild = function (child) {
                this.children.push(child);
            };

            var parentFolder = this.getParentFolder();
            if (parentFolder) {
                parentFolder.name = '..';
                this.addChild(parentFolder);
            }
        };

        var File = function (name, fileId, folder, time, size, citationInfo) {
            this.citationInfo = citationInfo;
            this.name = name;
            this.fileId = fileId;
            this.folder = folder;
            this.time = time;
            this.size = size;
            this.is_file = true;
        };

        this.getFolderStructure = function (files) {
            folders = {};
            // make sure the root folder is always there
            folders['/'] = new Folder('/');

            // create folder tree
            for (var i = 0; i < files.length; i++) {
                // normalize folders
                if (files[i].Folder.slice(-1) != '/') {
                    files[i].Folder += '/';
                }

                var path = files[i].Folder;
                if (!folders[path]) {
                    folders[path] = new Folder(path);
                    var child = folders[path];
                    var parent = child.getParentFolder();
                    // add parents of the current folder if needed
                    while (parent) {
                        if (!folders[parent.path]) {
                            parent.addChild(child);
                            folders[parent.path] = parent;
                            child = parent;
                            parent = child.getParentFolder();
                        } else {
                            folders[parent.path].addChild(child);
                            break;
                        }
                    }
                }
            }

            // add files to folders
            for (var i = 0; i < files.length; i++) {
                folders[files[i].Folder].addChild(new File(files[i].Name, files[i].FileId, files[i].Folder, files[i].LastUpdate, files[i].ReadableSize, files[i].CitationInfo || ''));
            }

            // find common directory prefix:
            var commondirectoryPrefix = '/';
            while (folders[commondirectoryPrefix].children.length <= 2) {
                var nextIndex = Math.min(folders[commondirectoryPrefix].children.length - 1, 2);
                if (!folders[commondirectoryPrefix].children[nextIndex].is_file) {
                    commondirectoryPrefix = folders[commondirectoryPrefix].children[nextIndex].path;
                } else {
                    break;
                }
            }
            // remove folder up navigation from common prefix
            folders[commondirectoryPrefix].children.splice(0, 1);

            return { entries: folders[commondirectoryPrefix].children };
        };

        this.getFolderItems = function (path) {
            //me.commondirectoryPrefix = path;
            return { entries: folders[path].children };
        };

        return this;
})();