﻿/// <reference path="../references.js" />

var rwthapp = rwthapp || {};

rwthapp.galleryHelper = (function () {
    var me = {};
    me.init = function (config) {
        return new Promise(function (resolve) {
            me.renderModal(config);
            resolve(true);
        });
    };

    me.renderModal = function (properties) {
        rwthapp.templateRenderer.render("#modal-content", "modal.gallery.partial", properties);
        $("#modal-button-rate").on("click", function () {
            me.rate(properties.id);
        });
        $("#modal-button-warn").on("click", function () {
            me.warn(properties.id);
        });
        $("#rateicon").css("color",properties.rated == 1 ? "#00ff00" : "#bbbbbb");
        $("#warnicon").css("color", properties.warned == 1 ? "#ff0000" : "#bbbbbb");
        properties.img = properties.img.replace("Thumb", "Photo");
        $("#modal-image").prop("src", properties.img);
    };



    me.rate = function (id) {
        var userId = rwthapp.tokenManager.getUserId();
        rwthapp.connection.api.photo.ratePhotoPositive(id, userId).then(function (data) {
            if (data.result == "liked") {
                $("#"+id).data("rated","1");
                $("#rateicon").css("color", "#ff0000");
            } else {
                $("#"+id).data("rated","-1");
                $("#rateicon").css("color", "#bbbbbb");
            }
        });
    };

    me.warn = function (id) {
        var userId = rwthapp.tokenManager.getUserId();
        rwthapp.connection.api.photo.ratePhotoWarning(id, userId).then(function (data) {
            if (data.result == "warned") {
                $("#"+id).data("warned", "1");
                $("#warnicon").css("color", "#ffff00");
            } else {
                $("#"+id).data("warned","-1");
                $("#warnicon").css("color", "#dddddd");
            }
        });
    };


    return me;
})();