﻿/// <reference path="../references.js" />

rwthapp.util.initNamespace("logging.Logger");

rwthapp.logging.LogLevel = Object.freeze({
    Debug: 1,
    Info: 2,
    Error: 3
});

rwthapp.logging.Logger = function (minimumLogLevel, maxHistoryLength) {
    if (minimumLogLevel !== undefined) {
        this.minimumLogLevel = minimumLogLevel;
    } else {
        this.minimumLogLevel = rwthapp.logging.LogLevel.Info;
    }

    if (maxHistoryLength !== undefined) {
        this.maxHistoryLength = maxHistoryLength;
    } else {
        this.maxHistoryLength = 50;
    }
    
    this.history = [];
};

rwthapp.logging.Logger.prototype.setMinimumLogLevel = function (minimumLogLevel) {
    this.minimumLogLevel = minimumLogLevel;
};

rwthapp.logging.Logger.prototype.log = function (logLevel, message, errorObject) {
    if (logLevel >= this.minimumLogLevel) {
        var historyEntry = {
            timestamp: Date.now(),
            loglevel: logLevel,
            message: message,
            error: errorObject
        };

        this.history.push(historyEntry);

        if (this.history.length > this.maxHistoryLength) {
            this.history.shift();
        }

        if (typeof console !== "undefined" && console.log) {
            console.log(this.formatEntry(historyEntry));
        }
    }
};

rwthapp.logging.Logger.prototype.formatEntry = function (entry) {
    return entry.message;
};

// Shortcuts for log method
rwthapp.logging.Logger.prototype.debug = function (message, errorObject) {
    this.log(rwthapp.logging.LogLevel.Debug, message, errorObject);
};

rwthapp.logging.Logger.prototype.info = function (message, errorObject) {
    this.log(rwthapp.logging.LogLevel.Info, message, errorObject);
};

rwthapp.logging.Logger.prototype.error = function (message, errorObject) {
    this.log(rwthapp.logging.LogLevel.Error, message, errorObject);
};

rwthapp.logging.logger = new rwthapp.logging.Logger(rwthapp.options.getLogLevel());