﻿/// <reference path="../references.js" />

rwthapp.util.initNamespace("modal");

rwthapp.modal.createModal = function (initMethod, contentTemplate, params) {
    // Returns a promise that resolves when the modal is dismissed
    return new Promise(function (resolve) {
        // Avoids problems if there is still an open modal
        if ($("#modal").length) {
            $('#modal').closeModal();
        }

        params = params || {};
        rwthapp.templateRenderer.render("#modal-placeholder", contentTemplate, params);

        var initialization;
        if (typeof initMethod === "function") {
            initialization = Promise.resolve(initMethod(params));
        } else {
            initialization = Promise.resolve();
        }

        initialization.then(function () {
            // Remove modal on dismissal
            $('#modal').openModal({
                complete: function () {
                    $("#modal").remove();
                    resolve();
                }
            });
        });
    });
};