﻿/// <reference path="../references.js" />

rwthapp.notifications = (function () {
    var toastDurationShort = 3000;
    var toastDurationLong = 6000;

    var showToast = function (message, duration) {
        return new Promise(function(resolve) {
            Materialize.toast("<div style='word-wrap: break-word;'>" + message+"</div>", duration, "", function () {
                resolve();
                $(".toast").css("height", "inherit");
                $(".toast").css("line-height", "inherit");
            });
        });
    };

    var showToastShort = function (message) {
        return showToast(message, toastDurationShort);
    };

    var showToastLong = function (message) {
        return showToast(message, toastDurationLong);
    };

    var showDialog = function (message) {
        return rwthapp.modal.createModal(null, "modal.basic", { message: message });
    };

    var showDialogWithFixedFooter = function (message) {
        return rwthapp.modal.createModal(null, "modal.basic.fixedFooter", { message: message });
    };

    var showConfirmationDialog = function (message, agreeButtonText, cancelButtonText) {
        /// <summary>Displays a confirmation dialog with the given message and button labels.</summary>
        /// <return>Promise<bool>, true if user agreed, false if user canceled</returns>
        return new Promise(function (resolve, reject) {
            var modalInit = function () {
                // Bind event handlers
                $("#modal-button-agree").on("click", function () {
                    resolve(true); // User agreed
                });
                $("#modal-button-cancel").on("click", function () {
                    resolve(false); // User canceled dialog
                });
            };

            rwthapp.modal.createModal(modalInit, "modal.confirmation", { message: message, buttonTextAgree: agreeButtonText, buttonTextCancel: cancelButtonText }).then(function () {
                resolve(false); // User canceled dialog
            });
        });
        
    };

    return {
        showToast: showToast,
        showToastShort: showToastShort,
        showToastLong: showToastLong,
        showDialog: showDialog,
        showDialogWithFixedFooter: showDialogWithFixedFooter,
        showConfirmationDialog: showConfirmationDialog
    };
})();


