﻿/// <reference path="../references.js" />

rwthapp.options = (function () {
    // TODO copy to prevent modifications?
    var defaultOptions = rwthapp.config;

    var storage = new rwthapp.Storage("options");
    storage.addAttribute("vibration");
    storage.addAttribute("wavesEffectEnabled");

    var feedPrefix = "feeds";

    // Namespaces
    var feeds = {};
    var vibration = {};
    var wavesEffect = {};

    var getProxyUrl = function () {
        var url = defaultOptions.urls.proxy[defaultOptions.activeProxy];
        if (!url) {
            url = defaultOptions.urls.proxy.live;
        }
        return url;
    };

    var getActiveProxyConfigName = function () {
        return defaultOptions.activeProxy;
    };

    var getOauthUrl = function () {
        var url = defaultOptions.urls.oauth[defaultOptions.activeOauth];
        if (!url) {
            url = defaultOptions.urls.oauth.live;
        }
        return url;
    };

    var getMapsUrl = function () {
        var defaultUrl = defaultOptions.urls.maps[defaultOptions.defaultMapsUrl];
        if (rwthapp.platformInfo.isIOS()
            && rwthapp.util.versionCompare(rwthapp.platformInfo.getPlatformVersion(), '6.0') >= 0) { // iOS >= 6.0

            return defaultOptions.urls.maps.apple;
        }
        else if (rwthapp.platformInfo.isWindowsUniversal() || rwthapp.platformInfo.isWP8()) {

            return defaultOptions.urls.maps.bing;
        }
        return defaultUrl;
    };

    var getStoreUrl = function () {
        if (rwthapp.platformInfo.isAndroid()) {
            return defaultOptions.urls.store.android;
        } else if (rwthapp.platformInfo.isIOS()) {
            return defaultOptions.urls.store.ios;
        } else if (rwthapp.platformInfo.isWindowsUniversal() || rwthapp.platformInfo.isWP8()) {
            return defaultOptions.urls.store.windows;
        }
        return null;
    };

    var getStoreImageUrl = function () {
        if (rwthapp.platformInfo.isAndroid()) {
            return "img/getapp-android.png";
        } else if (rwthapp.platformInfo.isIOS()) {
            return "img/getapp-ios.png";
        } else if (rwthapp.platformInfo.isWindowsUniversal() || rwthapp.platformInfo.isWP8()) {
            return "img/getapp-windows.png";
        }
        return null;
    };

    var isDebug = function () {
        return defaultOptions.debug;
    };

    var getVersionNumber = function () {
        return defaultOptions.versionNumber;
    };

    var getVersionCode = function () {

        return defaultOptions.versionCode;
    };

    feeds.getAvailableFeedsAndPersistInStorage = function () {

        return rwthapp.connection.api.getFeedConfiguration().then(function (feeds) {

            return { feeds: feeds };
        }).catch(function (error) {
            
            return { feeds: feeds.getCachedFeeds(), error: rwthapp.localization.getLocalizedString("organisation.feeds.noFeedsAvailable") };
        }).then(function (result) {

            var feeds = result.feeds;

            //$.each(feeds, function (index, value) {
            for(var i = 0; i < feeds.length; i++) {

                var isActive = rwthapp.options.feeds.isActive(feeds[i].id)

                if (isActive === null || isActive === undefined) {

                    isActive = feeds[i].enabled;
                    rwthapp.options.feeds.setActive(feeds[i].id, feeds[i], feeds[i].enabled);
                }

                if (isActive) {

                    feeds[i].checked = "checked";
                }

                feeds[i].isActive = isActive;
            }

            return {
                feeds: feeds,
                error: result.error
            };
        });
    };

    feeds.isActive = function (feedId) {

        var feed = storage.getItem(feedPrefix + "." + feedId);

        if (!feed || (feed && (feed.isActive === null || feed.isActive === undefined))) {

            return null
        }

        return feed.isActive;
    };

    feeds.getCachedFeeds = function () {
        
        var optionsStorageEntries = storage.getKeysForCategory('options'), result = [];
        
        for(var i = 0; i < optionsStorageEntries.length; i++) {

            if (optionsStorageEntries[i].indexOf("feeds.") >= 0) {

                result.push(storage.getItem(optionsStorageEntries[i]));
            }
        };

        return result;
        }

    feeds.getCachedFeed = function (feedId) {
    
        return storage.getItem(feedPrefix + "." + feedId);
    };

    feeds.setActive = function (feedId, feed, active) {
        
        feed.isActive = active;

        storage.setItem(feedPrefix + "." + feedId, feed);
    };

    vibration.set = function (enabled) {
        storage.setVibration(enabled);
    };

    vibration.isEnabled = function () {
        return storage.getVibration(true);
    };

    wavesEffect.set = function (enabled) {
        storage.setWavesEffectEnabled(enabled);
    };

    wavesEffect.isEnabled = function () {
        var isEnabled = storage.getWavesEffectEnabled();
        if (isEnabled === null) {
            // Determine default based on platform
            isEnabled = !rwthapp.platformInfo.hasIssuesWithWavesEffect();
        }
        return isEnabled;
    };

    var getDefaultLanguage = function () {
        return defaultOptions.defaultLanguage;
    };

    var getLogLevel = function () {
        return defaultOptions.logLevel;
    };

    var getOauthClientId = function () {
        return defaultOptions.oauth.clientId;
    };

    var getOauthScope = function () {
        return defaultOptions.oauth.scope;
    };

    var isInappcachingEnabled = function () {
        return defaultOptions.enableInappcaching;
    };

    var disableInappcaching = function () {
        defaultOptions.enableInappcaching = false;
    };

    var enableInappcaching = function () {
        defaultOptions.enableInappcaching = true;
    };

    return {
        getProxyUrl: getProxyUrl,
        getOauthUrl: getOauthUrl,
        getMapsUrl: getMapsUrl,
        getStoreUrl: getStoreUrl,
        getStoreImageUrl: getStoreImageUrl,
        isDebug: isDebug,
        getVersionNumber: getVersionNumber,
        getVersionCode: getVersionCode,
        getActiveProxyConfigName: getActiveProxyConfigName,
        feeds: feeds,
        vibration: vibration,
        wavesEffect: wavesEffect,
        getDefaultLanguage: getDefaultLanguage,
        getLogLevel: getLogLevel,
        getOauthClientId: getOauthClientId,
        getOauthScope: getOauthScope,
        isInappcachingEnabled: isInappcachingEnabled,
        disableInappcaching: disableInappcaching,
        enableInappcaching: enableInappcaching
    };
})();
