﻿/// <reference path="../references.js" />

rwthapp.util.initNamespace("platformInfo");

rwthapp.platformInfo = (function () {
    var oldAndroidVersionThreshold = "4.4.0";

    var getPlatformName = function () {
        return device.platform;
    };
    var getPlatformVersion = function () {
        return device.version;
    };

    var isOldAndroid = function () {
        return !isRipple()&&isAndroid() && rwthapp.util.versionCompare(getPlatformVersion(), oldAndroidVersionThreshold)<0;
    };

    var isAndroid = function () {
        return getPlatformName() === "Android";
    };

    var hasCorrectButtonLineHeight = function(){
        return !isOldAndroid() && !isIOS();
    };

    var isIOS = function () {
        return getPlatformName() === "iOS";
    };

    var isWindowsUniversal = function () {
        return getPlatformName() === "windows";
    };

    var isWP8 = function () {
        return getPlatformName() === "Win32NT";
    };

    var isUbuntu = function () {
        return getPlatformName() === "Linux";
    };

    var isFirefoxOS = function () {
        return getPlatformName() === "firefoxos";
    };

    var isRipple = function () {
        return window.tinyHippos !== undefined;
    };

    var isWindowsTablet = function() {
        
        var userAgent = navigator.userAgent;

        if(userAgent.indexOf("Windows NT") !== -1 || userAgent.indexOf("Tablet PC 2.0") !== -1) {

            return true;
        }

        return false;
    };

    var needsBackButton = function () {

        if (isIOS() || isWindowsTablet() || isUbuntu()) {

            return true;
        }

        return false;
    };

    var isTablet = function () {

        var userAgent = navigator.userAgent;
        // Android Tablet with version >= 4.3
        return userAgent.indexOf("Mobile") === -1 && userAgent.indexOf("Android") !== -1 && rwthapp.util.versionCompare(getPlatformVersion(), "4.4.2") >= 0 ||
            // iOS Tablet
            userAgent.indexOf("iPad") !== -1 || isWindowsTablet();
            
    };

    var hasLigatureSupport = function () {
        // TODO check platform support on other devices
        // Should be supported on non-android devices and android devices with a version >= 4.4.
        // At least on Samsung devices with Android 4.4, there are problems, return support only 
        // for Android devices with version >= 5.0
        return !isAndroid() || rwthapp.util.versionCompare(getPlatformVersion(), "5.0") >= 0;
    };

    var hasPageTransitionIssue = function () {
        // When opening the menu, graphical bugs appear on certain Windows Phone 8.1 devices.
        // Seems to appear only if the content fits the display and no scroll bars are present.
        return isWindowsUniversal() && rwthapp.util.versionCompare(getPlatformVersion(), "6.4") < 0;
    };

    var hasAnimationHideBug = function () {
        // IE11 has a bug that occurs if you hide and then show a div with animated child elements
        return isWindowsUniversal();
    };

    var hasIssuesWithWavesEffect = function () {
        // Pre-4.4 Android devices have problems with the waves effect in the menu
        return isAndroid() && rwthapp.util.versionCompare(getPlatformVersion(), "4.4") < 0;
    };

    var shouldExitOnBack = function () {
        // On Android and Windows, the app should close if the back-button is pressed on the initial page
        return isAndroid() || isWindowsUniversal() || isWP8();
    };

    return {
        isAndroid: isAndroid,
        isOldAndroid: isOldAndroid,
        isIOS: isIOS,
        isWP8: isWP8,
        isWindowsUniversal: isWindowsUniversal,
        isUbuntu: isUbuntu,
        isFirefoxOS: isFirefoxOS,
        isRipple: isRipple,
        isTablet: isTablet,
        needsBackButton: needsBackButton,
        getPlatformName: getPlatformName,
        getPlatformVersion: getPlatformVersion,
        hasLigatureSupport: hasLigatureSupport,
        hasCorrectButtonLineHeight: hasCorrectButtonLineHeight,
        hasPageTransitionIssue: hasPageTransitionIssue,
        hasAnimationHideBug: hasAnimationHideBug,
        hasIssuesWithWavesEffect: hasIssuesWithWavesEffect,
        shouldExitOnBack: shouldExitOnBack
    };
})();
